/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.MethodSource;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.dotnet.AssemblyFile;
import soot.dotnet.members.AbstractDotnetMember;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;

public class DotnetProperty
extends AbstractDotnetMember {
    private static final Logger logger = LoggerFactory.getLogger(DotnetProperty.class);
    private final SootClass declaringClass;
    private final ProtoAssemblyAllTypes.PropertyDefinition protoProperty;
    private DotnetMethod setterMethod;
    private DotnetMethod getterMethod;

    public DotnetProperty(ProtoAssemblyAllTypes.PropertyDefinition protoProperty, SootClass declaringClass) {
        this.protoProperty = protoProperty;
        this.declaringClass = declaringClass;
        this.initDotnetMethods();
    }

    private void initDotnetMethods() {
        if (this.getCanGet() && this.protoProperty.hasGetter()) {
            this.getterMethod = new DotnetMethod(this.protoProperty.getGetter(), this.declaringClass, DotnetMethod.DotnetMethodType.PROPERTY);
        }
        if (this.getCanSet() && this.protoProperty.hasSetter()) {
            this.setterMethod = new DotnetMethod(this.protoProperty.getSetter(), this.declaringClass, DotnetMethod.DotnetMethodType.PROPERTY);
        }
    }

    public boolean getCanGet() {
        return this.protoProperty.getCanGet();
    }

    public boolean getCanSet() {
        return this.protoProperty.getCanSet();
    }

    public SootMethod makeSootMethodGetter() {
        if (!this.protoProperty.getCanGet() || !this.protoProperty.hasGetter()) {
            return null;
        }
        return this.getterMethod.toSootMethod(this.createPropertyMethodSource(false));
    }

    public SootMethod makeSootMethodSetter() {
        if (!this.protoProperty.getCanSet() || !this.protoProperty.hasSetter()) {
            return null;
        }
        return this.setterMethod.toSootMethod(this.createPropertyMethodSource(true));
    }

    private MethodSource createPropertyMethodSource(boolean isSetter) {
        return (m, phaseName) -> {
            AssemblyFile assemblyFile = (AssemblyFile)SourceLocator.v().dexClassIndex().get(this.declaringClass.getName());
            ProtoIlInstructions.IlFunctionMsg ilFunctionMsg = assemblyFile.getMethodBodyOfProperty(this.declaringClass.getName(), this.protoProperty.getName(), isSetter);
            DotnetMethod dotnetMethod = isSetter ? this.setterMethod : this.getterMethod;
            Body b = dotnetMethod.jimplifyMethodBody(ilFunctionMsg);
            m.setActiveBody(b);
            return m.getActiveBody();
        };
    }
}

