/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;

public abstract class AbstractInvokeExpr
implements InvokeExpr {
    protected SootMethodRef methodRef;
    protected final ValueBox[] argBoxes;

    protected AbstractInvokeExpr(SootMethodRef methodRef, ValueBox[] argBoxes) {
        this.methodRef = methodRef;
        this.argBoxes = argBoxes.length == 0 ? null : argBoxes;
    }

    @Override
    public void setMethodRef(SootMethodRef methodRef) {
        this.methodRef = methodRef;
    }

    @Override
    public SootMethodRef getMethodRef() {
        return this.methodRef;
    }

    @Override
    public SootMethod getMethod() {
        return this.methodRef.resolve();
    }

    @Override
    public abstract Object clone();

    @Override
    public Value getArg(int index) {
        if (this.argBoxes == null) {
            return null;
        }
        ValueBox vb = this.argBoxes[index];
        return vb == null ? null : vb.getValue();
    }

    @Override
    public List<Value> getArgs() {
        ArrayList<Value> r;
        ValueBox[] boxes = this.argBoxes;
        if (boxes == null) {
            r = new ArrayList<Value>(0);
        } else {
            r = new ArrayList(boxes.length);
            for (ValueBox element : boxes) {
                r.add(element == null ? null : element.getValue());
            }
        }
        return r;
    }

    @Override
    public int getArgCount() {
        return this.argBoxes == null ? 0 : this.argBoxes.length;
    }

    @Override
    public void setArg(int index, Value arg) {
        this.argBoxes[index].setValue(arg);
    }

    @Override
    public ValueBox getArgBox(int index) {
        return this.argBoxes[index];
    }

    @Override
    public Type getType() {
        return this.methodRef.returnType();
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        ValueBox[] boxes = this.argBoxes;
        if (boxes == null) {
            return Collections.emptyList();
        }
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        Collections.addAll(list, boxes);
        for (ValueBox element : boxes) {
            list.addAll(element.getValue().getUseBoxes());
        }
        return list;
    }
}

