/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewMultiArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewMultiArrayExpr;
import soot.util.Switch;

public abstract class AbstractNewMultiArrayExpr
implements NewMultiArrayExpr,
ConvertToBaf {
    protected ArrayType baseType;
    protected final ValueBox[] sizeBoxes;

    protected AbstractNewMultiArrayExpr(ArrayType type, ValueBox[] sizeBoxes) {
        this.baseType = type;
        this.sizeBoxes = sizeBoxes;
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewMultiArrayExpr) {
            AbstractNewMultiArrayExpr ae = (AbstractNewMultiArrayExpr)o;
            return this.baseType.equals(ae.baseType) && this.sizeBoxes.length == ae.sizeBoxes.length;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("newmultiarray (");
        buf.append(this.baseType.baseType.toString()).append(')');
        for (ValueBox element : this.sizeBoxes) {
            buf.append('[').append(element.getValue().toString()).append(']');
        }
        int e = this.baseType.numDimensions - this.sizeBoxes.length;
        for (int i = 0; i < e; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("newmultiarray (");
        up.type(this.baseType.baseType);
        up.literal(")");
        for (ValueBox element : this.sizeBoxes) {
            up.literal("[");
            element.toString(up);
            up.literal("]");
        }
        int e = this.baseType.numDimensions - this.sizeBoxes.length;
        for (int i = 0; i < e; ++i) {
            up.literal("[]");
        }
    }

    @Override
    public ArrayType getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(ArrayType baseType) {
        this.baseType = baseType;
    }

    @Override
    public ValueBox getSizeBox(int index) {
        return this.sizeBoxes[index];
    }

    @Override
    public int getSizeCount() {
        return this.sizeBoxes.length;
    }

    @Override
    public Value getSize(int index) {
        return this.sizeBoxes[index].getValue();
    }

    @Override
    public List<Value> getSizes() {
        ValueBox[] boxes = this.sizeBoxes;
        ArrayList<Value> toReturn = new ArrayList<Value>(boxes.length);
        for (ValueBox element : boxes) {
            toReturn.add(element.getValue());
        }
        return toReturn;
    }

    @Override
    public void setSize(int index, Value size) {
        this.sizeBoxes[index].setValue(size);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        Collections.addAll(list, this.sizeBoxes);
        for (ValueBox element : this.sizeBoxes) {
            list.addAll(element.getValue().getUseBoxes());
        }
        return list;
    }

    @Override
    public Type getType() {
        return this.baseType;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewMultiArrayExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        List<Value> sizes = this.getSizes();
        for (Value s : sizes) {
            ((ConvertToBaf)((Object)s)).convertToBaf(context, out);
        }
        NewMultiArrayInst u = Baf.v().newNewMultiArrayInst(this.getBaseType(), sizes.size());
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

