/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Context;
import soot.G;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.geom.dataRep.CgEdge;
import soot.jimple.spark.geom.dataRep.PlainConstraint;
import soot.jimple.spark.geom.geomE.FullSensitiveNodeGenerator;
import soot.jimple.spark.geom.geomPA.Constants;
import soot.jimple.spark.geom.geomPA.FIFO_Worklist;
import soot.jimple.spark.geom.geomPA.IEncodingBroker;
import soot.jimple.spark.geom.geomPA.IFigureManager;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.IWorklist;
import soot.jimple.spark.geom.geomPA.OfflineProcessor;
import soot.jimple.spark.geom.geomPA.PQ_Worklist;
import soot.jimple.spark.geom.geomPA.Parameters;
import soot.jimple.spark.geom.heapinsE.HeapInsNodeGenerator;
import soot.jimple.spark.geom.helper.GeomEvaluator;
import soot.jimple.spark.geom.ptinsE.PtInsNodeGenerator;
import soot.jimple.spark.geom.utils.SootInfo;
import soot.jimple.spark.geom.utils.ZArrayNumberer;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.options.SparkOptions;
import soot.toolkits.scalar.Pair;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class GeomPointsTo
extends PAG {
    private static final Logger logger = LoggerFactory.getLogger(GeomPointsTo.class);
    protected IWorklist worklist = null;
    protected IEncodingBroker nodeGenerator = null;
    protected TypeManager typeManager = null;
    protected OfflineProcessor offlineProcessor = null;
    public Map<Node, IVarAbstraction> consG = null;
    public ZArrayNumberer<IVarAbstraction> pointers = null;
    public ZArrayNumberer<IVarAbstraction> allocations = null;
    public ZArrayNumberer<PlainConstraint> constraints = null;
    public Set<Stmt> thread_run_callsites = null;
    public Set<Stmt> multiCallsites = null;
    public long[] context_size;
    public long[] max_context_size_block;
    public int[] block_num;
    public int max_scc_size;
    public int max_scc_id;
    public int n_func;
    public int n_calls;
    public int n_reach_methods;
    public int n_reach_user_methods;
    public int n_reach_spark_user_methods;
    public int n_init_constraints;
    public String dump_dir = null;
    public PrintStream ps = null;
    protected Map<String, Boolean> validMethods = null;
    protected CgEdge[] call_graph;
    protected Vector<CgEdge> obsoletedEdges = null;
    protected Map<Integer, LinkedList<CgEdge>> rev_call_graph = null;
    protected Deque<Integer> queue_cg = null;
    protected int[] vis_cg;
    protected int[] low_cg;
    protected int[] rep_cg;
    protected int[] indeg_cg;
    protected int[] scc_size;
    protected int pre_cnt;
    protected Map<SootMethod, Integer> func2int = null;
    protected Map<Integer, SootMethod> int2func = null;
    protected Map<Edge, CgEdge> edgeMapping = null;
    private boolean hasTransformed = false;
    private boolean hasExecuted = false;
    private boolean ddPrepared = false;

    public GeomPointsTo(SparkOptions opts) {
        super(opts);
    }

    public String toString() {
        return "Geometric Points-To Analysis";
    }

    private void prepareContainers() {
        this.consG = new HashMap<Node, IVarAbstraction>(39341);
        this.pointers = new ZArrayNumberer(25771);
        this.allocations = new ZArrayNumberer();
        this.constraints = new ZArrayNumberer(25771);
        this.thread_run_callsites = new HashSet<Stmt>(251);
        this.multiCallsites = new HashSet<Stmt>(251);
        this.queue_cg = new LinkedList<Integer>();
        this.func2int = new HashMap<SootMethod, Integer>(5011);
        this.int2func = new HashMap<Integer, SootMethod>(5011);
        this.edgeMapping = new HashMap<Edge, CgEdge>(19763);
        this.consG.clear();
        this.constraints.clear();
        this.func2int.clear();
        this.edgeMapping.clear();
    }

    public void parametrize(double spark_run_time) {
        String method_verify_file;
        int solver_encoding = this.opts.geom_encoding();
        if (solver_encoding == 1) {
            this.nodeGenerator = new FullSensitiveNodeGenerator();
        } else if (solver_encoding == 2) {
            this.nodeGenerator = new HeapInsNodeGenerator();
        } else if (solver_encoding == 3) {
            this.nodeGenerator = new PtInsNodeGenerator();
        }
        String encoding_name = this.nodeGenerator.getSignature();
        if (encoding_name == null) {
            throw new RuntimeException("No encoding given for geometric points-to analysis.");
        }
        if (this.nodeGenerator == null) {
            throw new RuntimeException("The encoding " + encoding_name + " is unavailable for geometric points-to analysis.");
        }
        switch (this.opts.geom_worklist()) {
            case 2: {
                this.worklist = new FIFO_Worklist();
                break;
            }
            case 1: {
                this.worklist = new PQ_Worklist();
            }
        }
        this.dump_dir = this.opts.geom_dump_verbose();
        File dir = null;
        if (!this.dump_dir.isEmpty()) {
            dir = new File(this.dump_dir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File log_file = new File(this.dump_dir, encoding_name + (this.opts.geom_blocking() ? "_blocked" : "_unblocked") + "_frac" + this.opts.geom_frac_base() + "_runs" + this.opts.geom_runs() + "_log.txt");
            try {
                this.ps = new PrintStream(log_file);
                logger.debug("[Geom] Analysis log can be found in: " + log_file.toString());
            }
            catch (FileNotFoundException e) {
                String msg = "[Geom] The dump file: " + log_file.toString() + " cannot be created. Abort.";
                logger.debug("" + msg);
                throw new RuntimeException(msg, e);
            }
        } else {
            this.ps = G.v().out;
        }
        if ((method_verify_file = this.opts.geom_verify_name()) != null) {
            try {
                FileReader fr = new FileReader(method_verify_file);
                Scanner fin = new Scanner(fr);
                this.validMethods = new HashMap<String, Boolean>();
                while (fin.hasNextLine()) {
                    this.validMethods.put(fin.nextLine(), Boolean.FALSE);
                }
                fin.close();
                fr.close();
                logger.debug("[Geom] Read in verification file successfully.\n");
            }
            catch (FileNotFoundException e) {
                this.validMethods = null;
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        Parameters.seedPts = this.opts.geom_app_only() ? 15 : Integer.MAX_VALUE;
        double mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.ps.println();
        this.ps.printf("[Spark] Time: %.3f s\n", spark_run_time / 1000.0);
        this.ps.printf("[Spark] Memory: %.1f MB\n", mem / 1024.0 / 1024.0);
        this.typeManager = this.getTypeManager();
        Parameters.max_cons_budget = this.opts.geom_frac_base();
        Parameters.max_pts_budget = Parameters.max_cons_budget * 2;
        Parameters.cg_refine_times = this.opts.geom_runs();
        if (Parameters.cg_refine_times < 1) {
            Parameters.cg_refine_times = 1;
        }
        this.prepareContainers();
        this.ps.println("[Geom] Start working on <" + (dir == null ? "NoName" : dir.getName()) + "> with <" + encoding_name + "> encoding.");
    }

    private void preprocess() {
        IVarAbstraction q;
        PlainConstraint cons;
        Node[] succs;
        Object p;
        this.n_func = Scene.v().getReachableMethods().size() + 1;
        this.call_graph = new CgEdge[this.n_func];
        this.n_calls = 0;
        this.n_reach_spark_user_methods = 0;
        int id = 1;
        QueueReader<MethodOrMethodContext> smList = Scene.v().getReachableMethods().listener();
        CallGraph soot_callgraph = Scene.v().getCallGraph();
        while (smList.hasNext()) {
            SootMethod func = smList.next().method();
            this.func2int.put(func, id);
            this.int2func.put(id, func);
            if (soot_callgraph.isEntryMethod(func) || func.isEntryMethod()) {
                CgEdge p2;
                this.call_graph[0] = p2 = new CgEdge(0, id, null, this.call_graph[0]);
                ++this.n_calls;
            }
            if (!func.isJavaLibraryMethod()) {
                ++this.n_reach_spark_user_methods;
            }
            ++id;
        }
        QueueReader<Edge> edgeList = Scene.v().getCallGraph().listener();
        while (edgeList.hasNext()) {
            Edge edge = edgeList.next();
            if (edge.isClinit()) continue;
            SootMethod sootMethod = edge.src();
            SootMethod sootMethod2 = edge.tgt();
            int s = this.func2int.get(sootMethod);
            int t = this.func2int.get(sootMethod2);
            p = new CgEdge(s, t, edge, this.call_graph[s]);
            this.call_graph[s] = p;
            this.edgeMapping.put(edge, (CgEdge)p);
            Stmt callsite = edge.srcStmt();
            if (edge.isThreadRunCall() || edge.kind().isExecutor() || edge.kind().isAsyncTask()) {
                this.thread_run_callsites.add(callsite);
            } else if (edge.isInstance() && !edge.isSpecial()) {
                InstanceInvokeExpr expr = (InstanceInvokeExpr)callsite.getInvokeExpr();
                if (expr.getMethodRef().getSignature().contains("<java.lang.Thread: void start()>")) {
                    this.thread_run_callsites.add(callsite);
                } else {
                    ((CgEdge)p).base_var = this.findLocalVarNode(expr.getBase());
                    if (SootInfo.countCallEdgesForCallsite(callsite, true) > 1 && ((CgEdge)p).base_var != null) {
                        this.multiCallsites.add(callsite);
                    }
                }
            }
            ++this.n_calls;
        }
        for (VarNode varNode : this.getVarNodeNumberer()) {
            IVarAbstraction iVarAbstraction = this.makeInternalNode(varNode);
            this.pointers.add(iVarAbstraction);
        }
        for (AllocDotField allocDotField : this.getAllocDotFieldNodeNumberer()) {
            SparkField sparkField = allocDotField.getField();
            if (sparkField instanceof SootField) {
                RefType decType = ((SootField)sparkField).getDeclaringClass().getType();
                Node[] baseType = allocDotField.getBase().getType();
                if (!this.castNeverFails((Type)baseType, decType)) continue;
            }
            IVarAbstraction pn2 = this.makeInternalNode(allocDotField);
            this.pointers.add(pn2);
        }
        for (AllocNode allocNode : this.getAllocNodeNumberer()) {
            IVarAbstraction iVarAbstraction = this.makeInternalNode(allocNode);
            this.allocations.add(iVarAbstraction);
        }
        for (Node node : this.allocSources()) {
            Node[] succs2;
            IVarAbstraction iVarAbstraction = this.makeInternalNode((AllocNode)node);
            for (Node element0 : succs2 = this.allocLookup((AllocNode)node)) {
                PlainConstraint cons2 = new PlainConstraint();
                IVarAbstraction p3 = this.makeInternalNode(element0);
                cons2.expr.setPair(iVarAbstraction, p3);
                cons2.type = 0;
                this.constraints.add(cons2);
            }
        }
        Pair<Node, Node> intercall = new Pair<Node, Node>();
        for (VarNode varNode : this.simpleSources()) {
            p = this.makeInternalNode(varNode);
            for (Node element0 : succs = this.simpleLookup(varNode)) {
                cons = new PlainConstraint();
                IVarAbstraction q2 = this.makeInternalNode(element0);
                cons.expr.setPair((IVarAbstraction)p, q2);
                cons.type = 1;
                intercall.setPair(varNode, element0);
                cons.interCallEdges = this.lookupEdgesForAssignment(intercall);
                this.constraints.add(cons);
            }
        }
        intercall = null;
        this.assign2edges.clear();
        Iterator<FieldRefNode> iterator = this.loadSources().iterator();
        while (iterator.hasNext()) {
            Node[] succs3;
            FieldRefNode fieldRefNode;
            FieldRefNode frn = fieldRefNode = iterator.next();
            IVarAbstraction p4 = this.makeInternalNode(frn.getBase());
            for (Node element0 : succs3 = this.loadLookup(frn)) {
                PlainConstraint cons3 = new PlainConstraint();
                q = this.makeInternalNode(element0);
                cons3.f = frn.getField();
                cons3.expr.setPair(p4, q);
                cons3.type = 2;
                this.constraints.add(cons3);
            }
        }
        for (VarNode varNode : this.storeSources()) {
            p = this.makeInternalNode(varNode);
            for (Node element0 : succs = this.storeLookup(varNode)) {
                cons = new PlainConstraint();
                FieldRefNode frn = (FieldRefNode)element0;
                q = this.makeInternalNode(frn.getBase());
                cons.f = frn.getField();
                cons.expr.setPair((IVarAbstraction)p, q);
                cons.type = 3;
                this.constraints.add(cons);
            }
        }
        this.n_init_constraints = this.constraints.size();
        this.low_cg = new int[this.n_func];
        this.vis_cg = new int[this.n_func];
        this.rep_cg = new int[this.n_func];
        this.indeg_cg = new int[this.n_func];
        this.scc_size = new int[this.n_func];
        this.block_num = new int[this.n_func];
        this.context_size = new long[this.n_func];
        this.max_context_size_block = new long[this.n_func];
    }

    private void mergeLocalVariables() {
        Node lhs;
        IVarAbstraction my_rhs;
        IVarAbstraction my_lhs;
        int[] count = new int[this.pointers.size()];
        for (PlainConstraint cons : this.constraints) {
            my_lhs = cons.getLHS();
            my_rhs = cons.getRHS();
            switch (cons.type) {
                case 0: 
                case 1: {
                    int n = my_rhs.id;
                    count[n] = count[n] + 1;
                    break;
                }
                case 2: {
                    lhs = my_lhs.getWrappedNode();
                    int n = my_rhs.id;
                    count[n] = count[n] + lhs.getP2Set().size();
                }
            }
        }
        Iterator<PlainConstraint> cons_it = this.constraints.iterator();
        while (cons_it.hasNext()) {
            SootMethod sm2;
            SootMethod sm1;
            PlainConstraint cons;
            cons = cons_it.next();
            if (cons.type != 1) continue;
            my_lhs = cons.getLHS();
            my_rhs = cons.getRHS();
            lhs = my_lhs.getWrappedNode();
            Node rhs = my_rhs.getWrappedNode();
            if (!(lhs instanceof LocalVarNode) || !(rhs instanceof LocalVarNode) || (sm1 = ((LocalVarNode)lhs).getMethod()) != (sm2 = ((LocalVarNode)rhs).getMethod()) || count[my_rhs.id] != 1 || lhs.getType() != rhs.getType()) continue;
            my_rhs.merge(my_lhs);
            cons_it.remove();
        }
        for (PlainConstraint cons : this.constraints) {
            my_lhs = cons.getLHS();
            my_rhs = cons.getRHS();
            switch (cons.type) {
                case 0: {
                    cons.setRHS(my_rhs.getRepresentative());
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    cons.setLHS(my_lhs.getRepresentative());
                    cons.setRHS(my_rhs.getRepresentative());
                }
            }
        }
    }

    private void callGraphDFS(int s) {
        int t;
        ++this.pre_cnt;
        this.vis_cg[s] = this.low_cg[s];
        this.queue_cg.addLast(s);
        CgEdge p = this.call_graph[s];
        while (p != null) {
            t = p.t;
            if (this.vis_cg[t] == 0) {
                this.callGraphDFS(t);
                this.low_cg[s] = Math.min(this.low_cg[s], this.low_cg[t]);
            } else {
                this.low_cg[s] = Math.min(this.low_cg[s], this.vis_cg[t]);
            }
            p = p.next;
        }
        if (this.low_cg[s] < this.vis_cg[s]) {
            this.scc_size[s] = 1;
            return;
        }
        this.scc_size[s] = this.queue_cg.size();
        do {
            t = this.queue_cg.getLast();
            this.queue_cg.removeLast();
            this.rep_cg[t] = s;
            int n = t;
            this.low_cg[n] = this.low_cg[n] + this.n_func;
        } while (s != t);
        int n = s;
        this.scc_size[n] = this.scc_size[n] - this.queue_cg.size();
        if (this.scc_size[s] > this.max_scc_size) {
            this.max_scc_size = this.scc_size[s];
            this.max_scc_id = s;
        }
    }

    private void encodeContexts(boolean connectMissedEntries) {
        int j;
        int i;
        int n_reachable = 0;
        int n_scc_reachable = 0;
        int n_full = 0;
        long max_contexts = Long.MIN_VALUE;
        Random rGen = new Random();
        this.pre_cnt = 1;
        this.max_scc_size = 1;
        for (i = 0; i < this.n_func; ++i) {
            this.vis_cg[i] = 0;
            this.indeg_cg[i] = 0;
            this.max_context_size_block[i] = 0L;
        }
        this.queue_cg.clear();
        this.callGraphDFS(0);
        if (connectMissedEntries) {
            for (i = 1; i < this.n_func; ++i) {
                if (this.vis_cg[i] != 0) continue;
                this.callGraphDFS(i);
            }
        }
        for (i = 0; i < this.n_func; ++i) {
            if (this.vis_cg[i] == 0) continue;
            CgEdge p = this.call_graph[i];
            while (p != null) {
                if (this.rep_cg[i] == this.rep_cg[p.t]) {
                    p.scc_edge = true;
                } else {
                    p.scc_edge = false;
                    int n = this.rep_cg[p.t];
                    this.indeg_cg[n] = this.indeg_cg[n] + 1;
                }
                p = p.next;
            }
            ++n_reachable;
            if (this.rep_cg[i] != i) continue;
            ++n_scc_reachable;
        }
        if (connectMissedEntries) {
            for (i = 1; i < this.n_func; ++i) {
                CgEdge p;
                int rep_node = this.rep_cg[i];
                if (this.indeg_cg[rep_node] != 0) continue;
                this.call_graph[0] = p = new CgEdge(0, i, null, this.call_graph[0]);
                ++this.n_calls;
            }
        }
        for (i = 0; i < this.n_func; ++i) {
            if (this.vis_cg[i] == 0 || this.rep_cg[i] == i) continue;
            CgEdge p = this.call_graph[i];
            while (p.next != null) {
                p = p.next;
            }
            p.next = this.call_graph[this.rep_cg[i]];
            this.call_graph[this.rep_cg[i]] = this.call_graph[i];
        }
        this.max_context_size_block[0] = 1L;
        this.queue_cg.addLast(0);
        while (!this.queue_cg.isEmpty()) {
            i = this.queue_cg.getFirst();
            this.queue_cg.removeFirst();
            CgEdge p = this.call_graph[i];
            while (p != null) {
                if (!p.scc_edge) {
                    j = this.rep_cg[p.t];
                    if (0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i] < this.max_context_size_block[j]) {
                        long start = rGen.nextLong();
                        if (start < 0L) {
                            start = -start;
                        }
                        if (start > 0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i]) {
                            start = 0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i];
                            this.max_context_size_block[j] = 0x7FFFFFFFFFFFFFFEL;
                        } else if (this.max_context_size_block[j] < start + this.max_context_size_block[i]) {
                            this.max_context_size_block[j] = start + this.max_context_size_block[i];
                        }
                        p.map_offset = start + 1L;
                    } else {
                        p.map_offset = this.max_context_size_block[j] + 1L;
                        int n = j;
                        this.max_context_size_block[n] = this.max_context_size_block[n] + this.max_context_size_block[i];
                    }
                    int n = j;
                    this.indeg_cg[n] = this.indeg_cg[n] - 1;
                    if (this.indeg_cg[n] == 0) {
                        this.queue_cg.addLast(j);
                    }
                } else {
                    p.map_offset = 1L;
                }
                p = p.next;
            }
            if (this.max_context_size_block[i] <= max_contexts) continue;
            max_contexts = this.max_context_size_block[i];
        }
        for (i = this.n_func - 1; i > -1; --i) {
            if (this.vis_cg[i] == 0) continue;
            if (this.rep_cg[i] != i) {
                this.max_context_size_block[i] = this.max_context_size_block[this.rep_cg[i]];
                CgEdge p = this.call_graph[i];
                while (p.next.s == i) {
                    p = p.next;
                }
                this.call_graph[this.rep_cg[i]] = p.next;
                p.next = null;
            }
            if (this.max_context_size_block[i] == 0x7FFFFFFFFFFFFFFEL) {
                ++n_full;
            }
            this.context_size[i] = this.max_context_size_block[i];
            this.block_num[i] = 1;
        }
        if (this.getOpts().geom_blocking()) {
            for (i = 0; i < this.n_func; ++i) {
                if (this.vis_cg[i] == 0) continue;
                CgEdge p = this.call_graph[i];
                while (p != null) {
                    j = p.t;
                    if (j != i && p.scc_edge) {
                        if (this.context_size[j] <= 0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i]) {
                            p.map_offset = this.context_size[j] + 1L;
                            int n = j;
                            this.context_size[n] = this.context_size[n] + this.max_context_size_block[i];
                            int n2 = j;
                            this.block_num[n2] = this.block_num[n2] + 1;
                        } else {
                            int iBlock = 0;
                            if (this.block_num[j] > 1) {
                                iBlock = rGen.nextInt(this.block_num[j] - 1) + 1;
                            }
                            p.map_offset = (long)iBlock * this.max_context_size_block[j] + 1L;
                        }
                    }
                    p = p.next;
                }
            }
        }
        this.ps.printf("Reachable Methods = %d, in which #Condensed Nodes = %d, #Full Context Nodes = %d \n", n_reachable - 1, n_scc_reachable - 1, n_full);
        this.ps.printf("Maximum SCC = %d \n", this.max_scc_size);
        this.ps.printf("The maximum context size = %e\n", max_contexts);
    }

    private void solveConstraints() {
        IWorklist ptaList = this.worklist;
        while (ptaList.has_job()) {
            IVarAbstraction pn = ptaList.next();
            pn.do_before_propagation();
            pn.propagate(this, ptaList);
            pn.do_after_propagation();
        }
    }

    private void getCallTargets(IVarAbstraction pn, SootMethod src, Stmt callsite, ChunkedQueue<SootMethod> targetsQueue) {
        InstanceInvokeExpr iie = (InstanceInvokeExpr)callsite.getInvokeExpr();
        Local receiver = (Local)iie.getBase();
        for (AllocNode an : pn.get_all_points_to_objects()) {
            Type type = an.getType();
            if (type == null) continue;
            VirtualCalls.v().resolve(type, receiver.getType(), iie.getMethodRef(), src, targetsQueue);
        }
    }

    private int updateCallGraph() {
        int all_virtual_edges = 0;
        int n_obsoleted = 0;
        CallGraph cg = Scene.v().getCallGraph();
        ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue<SootMethod>();
        QueueReader targets = targetsQueue.reader();
        HashSet<SootMethod> resolvedMethods = new HashSet<SootMethod>();
        Iterator<Stmt> csIt = this.multiCallsites.iterator();
        block0: while (csIt.hasNext()) {
            IVarAbstraction pn;
            Stmt callsite = csIt.next();
            Iterator<Edge> edges = cg.edgesOutOf(callsite);
            if (!edges.hasNext()) {
                csIt.remove();
                continue;
            }
            Edge anyEdge = edges.next();
            CgEdge p = this.edgeMapping.get(anyEdge);
            SootMethod src = anyEdge.src();
            if (!this.isReachableMethod(src)) {
                csIt.remove();
                continue;
            }
            if (!edges.hasNext() || (pn = this.consG.get(p.base_var)) == null) continue;
            pn = pn.getRepresentative();
            this.getCallTargets(pn, src, callsite, targetsQueue);
            resolvedMethods.clear();
            while (targets.hasNext()) {
                resolvedMethods.add((SootMethod)targets.next());
            }
            while (true) {
                SootMethod tgt;
                if (!resolvedMethods.contains(tgt = anyEdge.tgt()) && !anyEdge.kind().isFake()) {
                    p = this.edgeMapping.get(anyEdge);
                    p.is_obsoleted = true;
                }
                if (!edges.hasNext()) continue block0;
                anyEdge = edges.next();
            }
        }
        for (int i = 1; i < this.n_func; ++i) {
            CgEdge p = this.call_graph[i];
            CgEdge q = null;
            while (p != null) {
                if (this.vis_cg[i] == 0) {
                    p.is_obsoleted = true;
                }
                if (p.base_var != null) {
                    ++all_virtual_edges;
                }
                CgEdge temp = p.next;
                if (!p.is_obsoleted) {
                    p.next = q;
                    q = p;
                } else {
                    cg.removeEdge(p.sootEdge);
                    ++n_obsoleted;
                }
                p = temp;
            }
            this.call_graph[i] = q;
        }
        this.ps.printf("%d of %d virtual call edges are proved to be spurious.\n", n_obsoleted, all_virtual_edges);
        return n_obsoleted;
    }

    private void prepareNextRun() {
        for (IVarAbstraction pn : this.pointers) {
            if (!pn.willUpdate) continue;
            pn.reconstruct();
        }
        System.gc();
    }

    private void markReachableMethods() {
        int i;
        int ans = 0;
        for (i = 0; i < this.n_func; ++i) {
            this.vis_cg[i] = 0;
        }
        this.queue_cg.clear();
        this.queue_cg.add(0);
        this.vis_cg[0] = 1;
        while (this.queue_cg.size() > 0) {
            int s = this.queue_cg.removeFirst();
            CgEdge p = this.call_graph[s];
            while (p != null) {
                int t = p.t;
                if (this.vis_cg[t] == 0) {
                    this.queue_cg.add(t);
                    this.vis_cg[t] = 1;
                    ++ans;
                }
                p = p.next;
            }
        }
        this.n_reach_methods = ans;
        ans = 0;
        for (i = 1; i < this.n_func; ++i) {
            SootMethod sm = this.int2func.get(i);
            if (this.vis_cg[i] == 0) {
                this.func2int.remove(sm);
                this.int2func.remove(i);
                continue;
            }
            if (sm.isJavaLibraryMethod()) continue;
            ++ans;
        }
        this.n_reach_user_methods = ans;
    }

    private void buildRevCallGraph() {
        this.rev_call_graph = new HashMap<Integer, LinkedList<CgEdge>>();
        for (int i = 0; i < this.n_func; ++i) {
            CgEdge p = this.call_graph[i];
            while (p != null) {
                LinkedList<CgEdge> list = this.rev_call_graph.get(p.t);
                if (list == null) {
                    list = new LinkedList();
                    this.rev_call_graph.put(p.t, list);
                }
                list.add(p);
                p = p.next;
            }
        }
    }

    private void finalizeInternalData() {
        this.markReachableMethods();
        Iterator<IVarAbstraction> it = this.allocations.iterator();
        while (it.hasNext()) {
            IVarAbstraction po = it.next();
            AllocNode obj = (AllocNode)po.getWrappedNode();
            SootMethod sm = obj.getMethod();
            if (sm == null || this.func2int.containsKey(sm)) continue;
            it.remove();
        }
        final Vector<AllocNode> removeSet = new Vector<AllocNode>();
        Iterator<IVarAbstraction> it2 = this.pointers.iterator();
        while (it2.hasNext()) {
            IVarAbstraction pn = it2.next();
            Node vn = pn.getWrappedNode();
            SootMethod sm = null;
            if (vn instanceof LocalVarNode) {
                sm = ((LocalVarNode)vn).getMethod();
            } else if (vn instanceof AllocDotField) {
                sm = ((AllocDotField)vn).getBase().getMethod();
            }
            if (sm != null && !this.func2int.containsKey(sm)) {
                pn.deleteAll();
                vn.discardP2Set();
                it2.remove();
                continue;
            }
            if (pn.getRepresentative() != pn) continue;
            removeSet.clear();
            if (pn.hasPTResult()) {
                Set<AllocNode> objSet = pn.get_all_points_to_objects();
                for (AllocNode obj : objSet) {
                    IVarAbstraction po = this.consG.get(obj);
                    if (po.reachable() && !pn.isDeadObject(obj)) continue;
                    removeSet.add(obj);
                }
                for (AllocNode obj : removeSet) {
                    pn.remove_points_to(obj);
                }
                pn.drop_duplicates();
                continue;
            }
            PointsToSetInternal pts = vn.getP2Set();
            pts.forall(new P2SetVisitor(){

                @Override
                public void visit(Node n) {
                    IVarAbstraction pan = GeomPointsTo.this.findInternalNode(n);
                    if (pan.reachable()) {
                        removeSet.add((AllocNode)n);
                    }
                }
            });
            pts = vn.makeP2Set();
            for (AllocNode an : removeSet) {
                pts.add(an);
            }
        }
        Iterator<PlainConstraint> cIt = this.constraints.iterator();
        while (cIt.hasNext()) {
            PlainConstraint cons = cIt.next();
            IVarAbstraction lhs = cons.getLHS();
            IVarAbstraction rhs = cons.getRHS();
            if (lhs.reachable() && rhs.reachable() && this.getMethodIDFromPtr(lhs) != -1 && this.getMethodIDFromPtr(rhs) != -1) continue;
            cIt.remove();
        }
        this.pointers.reassign();
        this.allocations.reassign();
        this.constraints.reassign();
    }

    private void releaseUselessResources() {
        this.offlineProcessor.destroy();
        this.offlineProcessor = null;
        IFigureManager.cleanCache();
        System.gc();
    }

    private void finalizeSootData() {
        Scene.v().releaseReachableMethods();
        Scene.v().getReachableMethods();
        if (!this.opts.geom_trans()) {
            for (IVarAbstraction pn : this.pointers) {
                if (pn != pn.getRepresentative() || !pn.hasPTResult()) continue;
                pn.keepPointsToOnly();
                Node vn = pn.getWrappedNode();
                vn.discardP2Set();
            }
        } else {
            this.transformToCIResult();
        }
    }

    public void transformToCIResult() {
        for (IVarAbstraction pn : this.pointers) {
            if (pn.getRepresentative() != pn) continue;
            Node node = pn.getWrappedNode();
            node.discardP2Set();
            PointsToSetInternal ptSet = node.makeP2Set();
            for (AllocNode obj : pn.get_all_points_to_objects()) {
                ptSet.add(obj);
            }
            pn.deleteAll();
        }
        this.hasTransformed = true;
    }

    public void solve() {
        int rounds;
        long solve_time = 0L;
        long prepare_time = 0L;
        G.v().out.flush();
        this.preprocess();
        this.mergeLocalVariables();
        this.worklist.initialize(this.pointers.size());
        this.offlineProcessor = new OfflineProcessor(this);
        IFigureManager.cleanCache();
        int evalLevel = this.opts.geom_eval();
        GeomEvaluator ge = new GeomEvaluator(this, this.ps);
        if (evalLevel == 1) {
            ge.profileSparkBasicMetrics();
        }
        Date begin = new Date();
        int n_obs = 1000;
        for (rounds = 0; rounds < Parameters.cg_refine_times && n_obs > 0; ++rounds) {
            this.ps.println("\n[Geom] Propagation Round " + rounds + " ==> ");
            this.encodeContexts(rounds == 0);
            Date prepare_begin = new Date();
            this.offlineProcessor.init();
            this.offlineProcessor.defaultFeedPtsRoutines();
            this.offlineProcessor.runOptimizations();
            Date prepare_end = new Date();
            prepare_time += prepare_end.getTime() - prepare_begin.getTime();
            if (rounds == 0 && evalLevel <= 1) {
                this.offlineProcessor.releaseSparkMem();
            }
            this.prepareNextRun();
            this.nodeGenerator.initFlowGraph(this);
            this.solveConstraints();
            n_obs = this.updateCallGraph();
            this.finalizeInternalData();
        }
        if (rounds < Parameters.cg_refine_times) {
            this.ps.printf("\nThe points-to information has converged. We stop here.\n", new Object[0]);
        }
        Date end = new Date();
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.ps.println();
        this.ps.printf("[Geom] Preprocessing time: %.2f s\n", (double)prepare_time / 1000.0);
        this.ps.printf("[Geom] Total time: %.2f s\n", (double)(solve_time += end.getTime() - begin.getTime()) / 1000.0);
        this.ps.printf("[Geom] Memory: %.1f MB\n", (double)mem / 1024.0 / 1024.0);
        if (evalLevel != 0) {
            ge.profileGeomBasicMetrics(evalLevel > 1);
            if (evalLevel > 1) {
                ge.checkCallGraph();
                ge.checkCastsSafety();
                ge.checkAliasAnalysis();
            }
        }
        this.finalizeSootData();
        this.releaseUselessResources();
        this.hasExecuted = true;
    }

    public void ddSolve(Set<Node> qryNodes) {
        int init_size;
        long solve_time = 0L;
        long prepare_time = 0L;
        if (!this.hasExecuted) {
            this.solve();
        }
        if (!this.ddPrepared || this.offlineProcessor == null) {
            this.offlineProcessor = new OfflineProcessor(this);
            IFigureManager.cleanCache();
            this.ddPrepared = true;
            this.ps.println();
            this.ps.println("==> Entering demand-driven mode (experimental).");
        }
        if ((init_size = qryNodes.size()) == 0) {
            this.ps.println("Please provide at least one pointer.");
            return;
        }
        Date prepare_begin = new Date();
        this.offlineProcessor.init();
        this.offlineProcessor.addUserDefPts(qryNodes);
        this.offlineProcessor.runOptimizations();
        Date prepare_end = new Date();
        prepare_time += prepare_end.getTime() - prepare_begin.getTime();
        Date begin = new Date();
        this.prepareNextRun();
        this.nodeGenerator.initFlowGraph(this);
        this.solveConstraints();
        Date end = new Date();
        this.ps.println();
        this.ps.printf("[ddGeom] Preprocessing time: %.2f seconds\n", (double)prepare_time / 1000.0);
        this.ps.printf("[ddGeom] Main propagation time: %.2f seconds\n", (double)(solve_time += end.getTime() - begin.getTime()) / 1000.0);
    }

    public void cleanResult() {
        this.consG.clear();
        this.pointers.clear();
        this.allocations.clear();
        this.constraints.clear();
        this.func2int.clear();
        this.int2func.clear();
        this.edgeMapping.clear();
        this.hasTransformed = false;
        this.hasExecuted = false;
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    public void keepOnly(Set<IVarAbstraction> usefulPointers) {
        HashSet<IVarAbstraction> reps = new HashSet<IVarAbstraction>();
        for (IVarAbstraction pn : usefulPointers) {
            reps.add(pn.getRepresentative());
        }
        usefulPointers.addAll(reps);
        reps = null;
        for (IVarAbstraction pn : this.pointers) {
            if (usefulPointers.contains(pn)) continue;
            pn.deleteAll();
        }
        System.gc();
    }

    public int getIDFromSootMethod(SootMethod sm) {
        Integer ans = this.func2int.get(sm);
        return ans == null ? -1 : ans;
    }

    public SootMethod getSootMethodFromID(int fid) {
        return this.int2func.get(fid);
    }

    public boolean isReachableMethod(int fid) {
        return fid == -1 ? false : this.vis_cg[fid] != 0;
    }

    public boolean isReachableMethod(SootMethod sm) {
        int id = this.getIDFromSootMethod(sm);
        return this.isReachableMethod(id);
    }

    public boolean isValidMethod(SootMethod sm) {
        if (this.validMethods != null) {
            String sig = sm.toString();
            if (!this.validMethods.containsKey(sig)) {
                return false;
            }
            this.validMethods.put(sig, Boolean.TRUE);
        }
        return true;
    }

    public void outputNotEvaluatedMethods() {
        if (this.validMethods != null) {
            this.ps.println("\nThe following methods are not evaluated because they are unreachable:");
            for (Map.Entry<String, Boolean> entry : this.validMethods.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                this.ps.println(entry.getKey());
            }
            this.ps.println();
        }
    }

    public Set<SootMethod> getAllReachableMethods() {
        return this.func2int.keySet();
    }

    public CgEdge getCallEgesOutFrom(int fid) {
        return this.call_graph[fid];
    }

    public LinkedList<CgEdge> getCallEdgesInto(int fid) {
        if (this.rev_call_graph == null) {
            this.buildRevCallGraph();
        }
        return this.rev_call_graph.get(fid);
    }

    public int getMethodIDFromPtr(IVarAbstraction pn) {
        SootMethod sm = null;
        int ret = 0;
        Node node = pn.getWrappedNode();
        if (node instanceof AllocNode) {
            sm = ((AllocNode)node).getMethod();
        } else if (node instanceof LocalVarNode) {
            sm = ((LocalVarNode)node).getMethod();
        } else if (node instanceof AllocDotField) {
            sm = ((AllocDotField)node).getBase().getMethod();
        }
        if (sm != null && this.func2int.containsKey(sm)) {
            int id = this.func2int.get(sm);
            ret = this.vis_cg[id] == 0 ? -1 : id;
        }
        return ret;
    }

    public IVarAbstraction makeInternalNode(Node v) {
        IVarAbstraction ret = this.consG.get(v);
        if (ret == null) {
            ret = this.nodeGenerator.generateNode(v);
            this.consG.put(v, ret);
        }
        return ret;
    }

    public IVarAbstraction findInternalNode(Node v) {
        return this.consG.get(v);
    }

    public boolean castNeverFails(Type src, Type dst) {
        return this.typeManager.castNeverFails(src, dst);
    }

    public int getNumberOfPointers() {
        return this.pointers.size();
    }

    public int getNumberOfObjects() {
        return this.allocations.size();
    }

    public int getNumberOfSparkMethods() {
        return this.n_func;
    }

    public int getNumberOfMethods() {
        return this.n_reach_methods;
    }

    public IWorklist getWorklist() {
        return this.worklist;
    }

    public IVarAbstraction findInstanceField(AllocNode obj, SparkField field) {
        AllocDotField af = this.findAllocDotField(obj, field);
        return this.consG.get(af);
    }

    public IVarAbstraction findAndInsertInstanceField(AllocNode obj, SparkField field) {
        AllocDotField af = this.findAllocDotField(obj, field);
        IVarAbstraction pn = null;
        if (af == null) {
            RefType decType = ((SootField)field).getDeclaringClass().getType();
            Type baseType = obj.getType();
            if (this.typeManager.castNeverFails(baseType, decType)) {
                af = this.makeAllocDotField(obj, field);
                pn = this.makeInternalNode(af);
                this.pointers.add(pn);
            }
        } else {
            pn = this.consG.get(af);
        }
        return pn;
    }

    public CgEdge getInternalEdgeFromSootEdge(Edge e) {
        return this.edgeMapping.get(e);
    }

    public boolean isExceptionPointer(Node v) {
        SootClass sc;
        return v.getType() instanceof RefType && !(sc = ((RefType)v.getType()).getSootClass()).isInterface() && Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(sc, Constants.exeception_type.getSootClass());
    }

    public boolean isValidGeometricNode(Node sparkNode) {
        IVarAbstraction pNode = this.consG.get(sparkNode);
        return pNode != null && pNode.reachable();
    }

    public boolean hasGeomExecuted() {
        return this.hasExecuted;
    }

    public FileOutputStream createOutputFile(String file_name) throws FileNotFoundException {
        return new FileOutputStream(new File(this.dump_dir, file_name));
    }

    private PointsToSetInternal field_p2set(PointsToSet s, final SparkField f) {
        if (!(s instanceof PointsToSetInternal)) {
            throw new RuntimeException("Base pointers must be stored in *PointsToSetInternal*.");
        }
        PointsToSetInternal bases = (PointsToSetInternal)s;
        Object ret = this.getSetFactory().newSet(f.getType(), this);
        bases.forall(new P2SetVisitor((PointsToSetInternal)ret){
            final /* synthetic */ PointsToSetInternal val$ret;
            {
                this.val$ret = pointsToSetInternal;
            }

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF != null) {
                    IVarAbstraction pn = GeomPointsTo.this.consG.get(nDotF);
                    if (pn == null || GeomPointsTo.this.hasTransformed || nDotF.getP2Set() != EmptyPointsToSet.v()) {
                        this.val$ret.addAll(nDotF.getP2Set(), null);
                        return;
                    }
                    pn = pn.getRepresentative();
                    for (AllocNode obj : pn.get_all_points_to_objects()) {
                        this.val$ret.add(obj);
                    }
                }
            }
        });
        return ret;
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        if (!this.hasExecuted) {
            return super.reachingObjects(l);
        }
        LocalVarNode vn = this.findLocalVarNode(l);
        if (vn == null) {
            return EmptyPointsToSet.v();
        }
        IVarAbstraction pn = this.consG.get(vn);
        if (pn == null || this.hasTransformed || vn.getP2Set() != EmptyPointsToSet.v()) {
            return vn.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = vn.makeP2Set();
        for (AllocNode obj : pn.get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        if (!this.hasExecuted) {
            return super.reachingObjects(c, l);
        }
        if (this.hasTransformed || !(c instanceof Unit)) {
            return this.reachingObjects(l);
        }
        LocalVarNode vn = this.findLocalVarNode(l);
        if (vn == null) {
            return EmptyPointsToSet.v();
        }
        IVarAbstraction pn = this.consG.get(vn);
        if (pn == null) {
            return vn.getP2Set();
        }
        pn = pn.getRepresentative();
        SootMethod callee = vn.getMethod();
        Edge e = Scene.v().getCallGraph().findEdge((Unit)c, callee);
        if (e == null) {
            return vn.getP2Set();
        }
        CgEdge myEdge = this.getInternalEdgeFromSootEdge(e);
        if (myEdge == null) {
            return vn.getP2Set();
        }
        long low = myEdge.map_offset;
        long high = low + this.max_context_size_block[myEdge.s];
        ContextVarNode cvn = vn.context(c);
        if (cvn != null) {
            PointsToSetInternal ans = cvn.getP2Set();
            if (ans != EmptyPointsToSet.v()) {
                return ans;
            }
        } else {
            cvn = this.makeContextVarNode(vn, c);
        }
        PointsToSetInternal ptset = cvn.makeP2Set();
        for (AllocNode an : pn.get_all_points_to_objects()) {
            if (!pn.pointer_interval_points_to(low, high, an)) continue;
            ptset.add(an);
        }
        return ptset;
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(f);
        }
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode vn = this.findGlobalVarNode(f);
        if (vn == null) {
            return EmptyPointsToSet.v();
        }
        IVarAbstraction pn = this.consG.get(vn);
        if (pn == null || this.hasTransformed || vn.getP2Set() != EmptyPointsToSet.v()) {
            return vn.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = vn.makeP2Set();
        for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(s, f);
        }
        return this.field_p2set(s, f);
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(l, f);
        }
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(c, l, f);
        }
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        if (!this.hasExecuted) {
            return super.reachingObjectsOfArrayElement(s);
        }
        return this.field_p2set(s, ArrayElement.v());
    }

    public PointsToSet reachingObjects(AllocNode an, SootField f) {
        AllocDotField adf = an.dot(f);
        IVarAbstraction pn = this.consG.get(adf);
        if (adf == null) {
            return EmptyPointsToSet.v();
        }
        if (pn == null || this.hasTransformed || adf.getP2Set() != EmptyPointsToSet.v()) {
            return adf.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = adf.makeP2Set();
        for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }
}

