/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JNewMultiArrayExpr;
import soot.jimple.toolkits.annotation.arraycheck.ArrayReferenceNode;
import soot.jimple.toolkits.annotation.arraycheck.BoolValue;
import soot.jimple.toolkits.annotation.arraycheck.ExtendedHashMutableDirectedGraph;
import soot.jimple.toolkits.annotation.arraycheck.MethodLocal;
import soot.jimple.toolkits.annotation.arraycheck.MethodParameter;
import soot.jimple.toolkits.annotation.arraycheck.MethodReturn;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;
import soot.options.Options;
import soot.util.Chain;

public class RectangularArrayFinder
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(RectangularArrayFinder.class);
    private final ExtendedHashMutableDirectedGraph<Object> agraph = new ExtendedHashMutableDirectedGraph();
    private final Set<Object> falseSet = new HashSet<Object>();
    private final Set<Object> trueSet = new HashSet<Object>();
    private CallGraph cg;

    public RectangularArrayFinder(Singletons.Global g) {
    }

    public static RectangularArrayFinder v() {
        return G.v().soot_jimple_toolkits_annotation_arraycheck_RectangularArrayFinder();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> opts) {
        Scene sc = Scene.v();
        this.cg = sc.getCallGraph();
        Date start = new Date();
        if (Options.v().verbose()) {
            logger.debug("[ra] Finding rectangular arrays, start on " + start);
        }
        for (SootClass sootClass : sc.getApplicationClasses()) {
            Iterator<SootMethod> iterator = sootClass.methodIterator();
            while (iterator.hasNext()) {
                SootMethod method = iterator.next();
                if (!method.isConcrete() || !sc.getReachableMethods().contains(method)) continue;
                this.recoverRectArray(method);
                this.addInfoFromMethod(method);
            }
        }
        if (this.agraph.containsNode(BoolValue.v(false))) {
            List<Object> startNodes = this.agraph.getSuccsOf(BoolValue.v(false));
            this.falseSet.addAll(startNodes);
            ArrayList<Object> arrayList = new ArrayList<Object>(startNodes);
            while (!arrayList.isEmpty()) {
                Object e = arrayList.remove(0);
                for (Object succ : this.agraph.getSuccsOf(e)) {
                    if (this.falseSet.contains(succ)) continue;
                    this.falseSet.add(succ);
                    arrayList.add(succ);
                }
            }
        }
        if (this.agraph.containsNode(BoolValue.v(true))) {
            Iterator<Object> changedNodeList = new ArrayList();
            for (Object object : this.agraph.getSuccsOf(BoolValue.v(true))) {
                if (this.falseSet.contains(object)) continue;
                changedNodeList.add(object);
                this.trueSet.add(object);
            }
            while (!changedNodeList.isEmpty()) {
                Object e = changedNodeList.remove(0);
                for (Object succ : this.agraph.getSuccsOf(e)) {
                    if (this.falseSet.contains(succ) || this.trueSet.contains(succ)) continue;
                    this.trueSet.add(succ);
                    changedNodeList.add(succ);
                }
            }
        }
        if (Options.v().debug()) {
            logger.debug("Rectangular Array :");
            for (Object e : this.trueSet) {
                logger.debug("" + e);
            }
            logger.debug("\nNon-rectangular Array :");
            for (Object object : this.falseSet) {
                logger.debug("" + object);
            }
        }
        if (Options.v().verbose()) {
            Date finish = new Date();
            long l = finish.getTime() - start.getTime();
            long mins = l / 60000L;
            long secs = l % 60000L / 1000L;
            logger.debug("[ra] Rectangular array finder finishes. It took " + mins + " mins and " + secs + " secs.");
        }
    }

    private void addInfoFromMethod(SootMethod method) {
        if (Options.v().verbose()) {
            logger.debug("[ra] Operating " + method.getSignature());
        }
        boolean needTransfer = true;
        boolean trackReturn = false;
        Type rtnType = method.getReturnType();
        if (rtnType instanceof ArrayType && ((ArrayType)rtnType).numDimensions > 1) {
            trackReturn = true;
            needTransfer = true;
        }
        Body body = method.getActiveBody();
        HashSet<Object> tmpNode = new HashSet<Object>();
        HashSet<Local> arrayLocal = new HashSet<Local>();
        for (Local local : body.getLocals()) {
            Type type = local.getType();
            if (!(type instanceof ArrayType)) continue;
            if (((ArrayType)type).numDimensions > 1) {
                arrayLocal.add(local);
                continue;
            }
            tmpNode.add(new MethodLocal(method, local));
        }
        ExtendedHashMutableDirectedGraph<Object> ehmdg = new ExtendedHashMutableDirectedGraph<Object>();
        Iterator unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            Type ltype;
            Type ftype;
            Object from;
            Object from2;
            Object to;
            Value op;
            Stmt stmt = (Stmt)unitIt.next();
            if (stmt.containsInvokeExpr()) {
                InvokeExpr iexpr = stmt.getInvokeExpr();
                int argnum = iexpr.getArgCount();
                for (int i = 0; i < argnum; ++i) {
                    Value arg = iexpr.getArg(i);
                    if (!arrayLocal.contains(arg)) continue;
                    needTransfer = true;
                    MethodLocal ml = new MethodLocal(method, (Local)arg);
                    Targets targetIt = new Targets(this.cg.edgesOutOf(stmt));
                    while (targetIt.hasNext()) {
                        SootMethod target = (SootMethod)targetIt.next();
                        MethodParameter mp = new MethodParameter(target, i);
                        ehmdg.addMutualEdge(ml, mp);
                    }
                }
            }
            if (trackReturn && stmt instanceof ReturnStmt && (op = ((ReturnStmt)stmt).getOp()) instanceof Local) {
                ehmdg.addMutualEdge(new MethodLocal(method, (Local)op), new MethodReturn(method));
            }
            if (!(stmt instanceof DefinitionStmt)) continue;
            Value leftOp = ((DefinitionStmt)stmt).getLeftOp();
            Value rightOp = ((DefinitionStmt)stmt).getRightOp();
            if (!(leftOp.getType() instanceof ArrayType) && !(rightOp.getType() instanceof ArrayType)) continue;
            if (leftOp instanceof Local && rightOp instanceof Local) {
                if (arrayLocal.contains(leftOp) && arrayLocal.contains(rightOp)) {
                    int leftDims = ((ArrayType)((Local)leftOp).getType()).numDimensions;
                    int rightDims = ((ArrayType)((Local)rightOp).getType()).numDimensions;
                    MethodLocal to2 = new MethodLocal(method, (Local)leftOp);
                    MethodLocal from3 = new MethodLocal(method, (Local)rightOp);
                    ehmdg.addMutualEdge(from3, to2);
                    if (leftDims == rightDims) continue;
                    ehmdg.addEdge(BoolValue.v(false), from3);
                    continue;
                }
                if (arrayLocal.contains(leftOp)) continue;
                ehmdg.addEdge(BoolValue.v(false), new MethodLocal(method, (Local)rightOp));
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof ParameterRef) {
                if (!arrayLocal.contains(leftOp)) continue;
                MethodLocal to3 = new MethodLocal(method, (Local)leftOp);
                int index = ((ParameterRef)rightOp).getIndex();
                MethodParameter from22 = new MethodParameter(method, index);
                ehmdg.addMutualEdge(from22, to3);
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof ArrayRef) {
                Local base = (Local)((ArrayRef)rightOp).getBase();
                if (!arrayLocal.contains(base)) continue;
                to = new ArrayReferenceNode(method, base);
                from2 = new MethodLocal(method, base);
                ehmdg.addMutualEdge(from2, to);
                tmpNode.add(to);
                from2 = to;
                to = new MethodLocal(method, (Local)leftOp);
                ehmdg.addMutualEdge(from2, to);
                continue;
            }
            if (leftOp instanceof ArrayRef && rightOp instanceof Local) {
                Local base = (Local)((ArrayRef)leftOp).getBase();
                if (!arrayLocal.contains(base)) continue;
                MethodLocal suspect = new MethodLocal(method, (Local)rightOp);
                boolean addEdge = true;
                if (ehmdg.containsNode(suspect)) {
                    ArrayReferenceNode arrRef;
                    HashSet<MethodLocal> neighbor = new HashSet<MethodLocal>();
                    neighbor.addAll(ehmdg.getSuccsOf(suspect));
                    neighbor.addAll(ehmdg.getSuccsOf(suspect));
                    if (neighbor.size() == 1 && ((Object)(arrRef = new ArrayReferenceNode(method, base))).equals(neighbor.iterator().next())) {
                        addEdge = false;
                    }
                }
                if (!addEdge) continue;
                ehmdg.addEdge(BoolValue.v(false), new MethodLocal(method, base));
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof InvokeExpr) {
                if (!arrayLocal.contains(leftOp)) continue;
                MethodLocal to4 = new MethodLocal(method, (Local)leftOp);
                Targets targetIt = new Targets(this.cg.edgesOutOf(stmt));
                while (targetIt.hasNext()) {
                    SootMethod target = (SootMethod)targetIt.next();
                    ehmdg.addMutualEdge(new MethodReturn(target), to4);
                }
                continue;
            }
            if (leftOp instanceof FieldRef && rightOp instanceof Local) {
                if (!arrayLocal.contains(rightOp)) continue;
                SootField to5 = ((FieldRef)leftOp).getField();
                from = new MethodLocal(method, (Local)rightOp);
                ehmdg.addMutualEdge(from, to5);
                ftype = ((FieldRef)leftOp).getType();
                ltype = ((Local)rightOp).getType();
                if (!ftype.equals(ltype)) {
                    ehmdg.addEdge(BoolValue.v(false), to5);
                }
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && rightOp instanceof FieldRef) {
                if (!arrayLocal.contains(leftOp)) continue;
                MethodLocal to6 = new MethodLocal(method, (Local)leftOp);
                from = ((FieldRef)rightOp).getField();
                ehmdg.addMutualEdge(from, to6);
                ftype = ((FieldRef)rightOp).getType();
                ltype = ((Local)leftOp).getType();
                if (!ftype.equals(ltype)) {
                    ehmdg.addEdge(BoolValue.v(false), to6);
                }
                needTransfer = true;
                continue;
            }
            if (leftOp instanceof Local && (rightOp instanceof NewArrayExpr || rightOp instanceof NewMultiArrayExpr)) {
                if (!arrayLocal.contains(leftOp)) continue;
                ehmdg.addEdge(BoolValue.v(true), new MethodLocal(method, (Local)leftOp));
                continue;
            }
            if (!(leftOp instanceof Local) || !(rightOp instanceof CastExpr)) continue;
            Local rOp = (Local)((CastExpr)rightOp).getOp();
            to = new MethodLocal(method, (Local)leftOp);
            from2 = new MethodLocal(method, rOp);
            if (arrayLocal.contains(leftOp) && arrayLocal.contains(rOp)) {
                ArrayType lat = (ArrayType)leftOp.getType();
                ArrayType rat = (ArrayType)rOp.getType();
                if (lat.numDimensions == rat.numDimensions) {
                    ehmdg.addMutualEdge(from2, to);
                    continue;
                }
                ehmdg.addEdge(BoolValue.v(false), from2);
                ehmdg.addEdge(BoolValue.v(false), to);
                continue;
            }
            if (arrayLocal.contains(leftOp)) {
                ehmdg.addEdge(BoolValue.v(false), to);
                continue;
            }
            if (!arrayLocal.contains(rOp)) continue;
            ehmdg.addEdge(BoolValue.v(false), from2);
        }
        if (needTransfer) {
            for (Object e : tmpNode) {
                ehmdg.skipNode(e);
            }
            this.agraph.mergeWith(ehmdg);
        }
    }

    private void recoverRectArray(SootMethod method) {
        Body body = method.getActiveBody();
        HashSet<Local> malocal = new HashSet<Local>();
        for (Local local : body.getLocals()) {
            Type type = local.getType();
            if (!(type instanceof ArrayType) || ((ArrayType)type).numDimensions != 2) continue;
            malocal.add(local);
        }
        if (malocal.isEmpty()) {
            return;
        }
        UnitPatchingChain units = body.getUnits();
        Stmt stmt = (Stmt)units.getFirst();
        while (stmt != null && stmt.fallsThrough()) {
            if (stmt instanceof AssignStmt) {
                Value leftOp = ((AssignStmt)stmt).getLeftOp();
                Value rightOp = ((AssignStmt)stmt).getRightOp();
                if (malocal.contains(leftOp) && rightOp instanceof NewArrayExpr) {
                    int firstdim;
                    Local local = (Local)leftOp;
                    NewArrayExpr naexpr = (NewArrayExpr)rightOp;
                    Value size = naexpr.getSize();
                    if (size instanceof IntConstant && (firstdim = ((IntConstant)size).value) <= 100) {
                        ArrayType localtype = (ArrayType)local.getType();
                        Type basetype = localtype.baseType;
                        Local[] tmplocals = new Local[firstdim];
                        int seconddim = this.lookforPattern(units, stmt, firstdim, local, basetype, tmplocals);
                        if (seconddim >= 0) {
                            this.transferPattern(units, stmt, firstdim, seconddim, local, basetype, tmplocals);
                        }
                    }
                }
            }
            stmt = units.getSuccOf(stmt);
        }
    }

    private int lookforPattern(Chain<Unit> units, Stmt startpoint, int firstdim, Local local, Type baseTy, Local[] tmplocals) {
        int seconddim = -1;
        int curdim = 0;
        Value curtmp = local;
        Stmt curstmt = startpoint;
        int fault = 99;
        int state = 1;
        block6: while ((curstmt = (Stmt)units.getSuccOf(curstmt)) != null && curstmt instanceof AssignStmt) {
            Value leftOp = ((AssignStmt)curstmt).getLeftOp();
            Value rightOp = ((AssignStmt)curstmt).getRightOp();
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    state = fault;
                    if (!(rightOp instanceof NewArrayExpr)) continue block6;
                    NewArrayExpr naexpr = (NewArrayExpr)rightOp;
                    Type type = naexpr.getBaseType();
                    Value size = naexpr.getSize();
                    if (!type.equals(baseTy)) continue block6;
                    if (!(size instanceof IntConstant)) continue block6;
                    if (curdim == 0) {
                        seconddim = ((IntConstant)size).value;
                    } else if (((IntConstant)size).value != seconddim) continue block6;
                    curtmp = leftOp;
                    state = 2;
                    break;
                }
                case 2: {
                    state = fault;
                    if (!(leftOp instanceof ArrayRef)) continue block6;
                    Value base = ((ArrayRef)leftOp).getBase();
                    Value idx = ((ArrayRef)leftOp).getIndex();
                    if (base.equals(curtmp)) {
                        state = 2;
                        break;
                    }
                    if (!base.equals(local) || !(idx instanceof IntConstant) || curdim != ((IntConstant)idx).value) continue block6;
                    if (!rightOp.equals(curtmp)) continue block6;
                    tmplocals[curdim] = curtmp;
                    if (++curdim >= firstdim) {
                        state = 3;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    return seconddim;
                }
                default: {
                    return -1;
                }
            }
        }
        return -1;
    }

    private void transferPattern(Chain<Unit> units, Stmt startpoint, int firstdim, int seconddim, Local local, Type baseTy, Local[] tmplocals) {
        ArrayList<IntConstant> sizes = new ArrayList<IntConstant>(2);
        sizes.add(IntConstant.v(firstdim));
        sizes.add(IntConstant.v(seconddim));
        JNewMultiArrayExpr nmexpr = new JNewMultiArrayExpr((ArrayType)local.getType(), sizes);
        ((AssignStmt)startpoint).setRightOp(nmexpr);
        int curdim = 0;
        Local tmpcur = local;
        Stmt curstmt = (Stmt)units.getSuccOf(startpoint);
        while (curdim < firstdim) {
            Value leftOp = ((AssignStmt)curstmt).getLeftOp();
            Value rightOp = ((AssignStmt)curstmt).getRightOp();
            if (tmplocals[curdim].equals(leftOp) && rightOp instanceof NewArrayExpr) {
                JArrayRef arexpr = new JArrayRef(local, IntConstant.v(curdim));
                ((AssignStmt)curstmt).setRightOp(arexpr);
                tmpcur = (Local)leftOp;
                continue;
            }
            if (leftOp instanceof ArrayRef && rightOp.equals(tmpcur)) {
                Stmt tmpstmt = curstmt;
                curstmt = (Stmt)units.getSuccOf(curstmt);
                units.remove(tmpstmt);
                ++curdim;
                continue;
            }
            curstmt = (Stmt)units.getSuccOf(curstmt);
        }
    }

    public boolean isRectangular(Object obj) {
        return this.trueSet.contains(obj);
    }
}

