/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.Expr;
import soot.jimple.GotoStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.jimple.toolkits.annotation.logic.LoopFinder;
import soot.tagkit.ColorTag;
import soot.tagkit.LoopInvariantTag;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.SmartLocalDefsPool;

public class LoopInvariantFinder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LoopInvariantFinder.class);
    private ArrayList constants;

    public LoopInvariantFinder(Singletons.Global g) {
    }

    public static LoopInvariantFinder v() {
        return G.v().soot_jimple_toolkits_annotation_logic_LoopInvariantFinder();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        SmartLocalDefs sld = SmartLocalDefsPool.v().getSmartLocalDefsFor(b);
        UnitGraph g = sld.getGraph();
        NaiveSideEffectTester nset = new NaiveSideEffectTester();
        Set<Loop> loops = new LoopFinder().getLoops(b);
        this.constants = new ArrayList();
        if (loops.isEmpty()) {
            return;
        }
        for (Loop loop : loops) {
            Stmt header = loop.getHead();
            List<Stmt> loopStmts = loop.getLoopStatements();
            for (Stmt tStmt : loopStmts) {
                this.handleLoopBodyStmt(tStmt, nset, loopStmts);
            }
        }
    }

    private void handleLoopBodyStmt(Stmt s, NaiveSideEffectTester nset, Collection<Stmt> loopStmts) {
        DefinitionStmt ds;
        if (s instanceof DefinitionStmt && (ds = (DefinitionStmt)s).getLeftOp() instanceof Local && ds.getRightOp() instanceof Constant) {
            if (!this.constants.contains(ds.getLeftOp())) {
                this.constants.add(ds.getLeftOp());
            } else {
                this.constants.remove(ds.getLeftOp());
            }
        }
        if (s instanceof GotoStmt || s instanceof InvokeStmt) {
            return;
        }
        logger.debug("s : " + s + " use boxes: " + s.getUseBoxes() + " def boxes: " + s.getDefBoxes());
        Iterator<ValueBox> useBoxesIt = s.getUseBoxes().iterator();
        boolean result = true;
        block0: while (useBoxesIt.hasNext()) {
            ValueBox vb = useBoxesIt.next();
            Value v = vb.getValue();
            if (v instanceof NewExpr) {
                result = false;
                logger.debug("break uses: due to new expr");
                break;
            }
            if (v instanceof InvokeExpr) {
                result = false;
                logger.debug("break uses: due to invoke expr");
                break;
            }
            if (v instanceof Expr) continue;
            logger.debug("test: " + v + " of kind: " + v.getClass());
            for (Stmt next : loopStmts) {
                if (!nset.unitCanWriteTo(next, v) || this.isConstant(next)) continue;
                logger.debug("result = false unit can be written to by: " + next);
                result = false;
                break block0;
            }
        }
        block2: for (ValueBox vb : s.getDefBoxes()) {
            Value v = vb.getValue();
            if (v instanceof NewExpr) {
                result = false;
                logger.debug("break defs due to new");
                break;
            }
            if (v instanceof InvokeExpr) {
                result = false;
                logger.debug("break defs due to invoke");
                break;
            }
            if (v instanceof Expr) continue;
            logger.debug("test: " + v + " of kind: " + v.getClass());
            for (Stmt next : loopStmts) {
                if (next.equals(s) || !nset.unitCanWriteTo(next, v) || this.isConstant(next)) continue;
                logger.debug("result false: unit can be written to by: " + next);
                result = false;
                break block2;
            }
        }
        logger.debug("stmt: " + s + " result: " + result);
        if (result) {
            s.addTag(new LoopInvariantTag("is loop invariant"));
            s.addTag(new ColorTag(0, "Loop Invariant Analysis"));
        }
    }

    private boolean isConstant(Stmt s) {
        DefinitionStmt ds;
        return s instanceof DefinitionStmt && this.constants.contains((ds = (DefinitionStmt)s).getLeftOp());
    }
}

