/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.RefLikeType;
import soot.Singletons;
import soot.SootClass;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.jimple.toolkits.annotation.nullcheck.RefIntPair;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.FlowSet;

public class NullPointerColorer
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(NullPointerColorer.class);

    public NullPointerColorer(Singletons.Global g) {
    }

    public static NullPointerColorer v() {
        return G.v().soot_jimple_toolkits_annotation_nullcheck_NullPointerColorer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        BranchedRefVarsAnalysis analysis = new BranchedRefVarsAnalysis(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b));
        for (Unit s : b.getUnits()) {
            FlowSet beforeSet = (FlowSet)analysis.getFlowBefore(s);
            for (ValueBox vBox : s.getUseBoxes()) {
                this.addColorTags(vBox, beforeSet, s, analysis);
            }
            FlowSet afterSet = (FlowSet)analysis.getFallFlowAfter(s);
            for (ValueBox vBox : s.getDefBoxes()) {
                this.addColorTags(vBox, afterSet, s, analysis);
            }
        }
        boolean keysAdded = false;
        SootClass declaringClass = b.getMethod().getDeclaringClass();
        for (Tag next : declaringClass.getTags()) {
            if (!(next instanceof KeyTag) || !"NullCheckTag".equals(((KeyTag)next).analysisType())) continue;
            keysAdded = true;
        }
        if (!keysAdded) {
            declaringClass.addTag(new KeyTag(0, "Nullness: Null", "NullCheckTag"));
            declaringClass.addTag(new KeyTag(1, "Nullness: Not Null", "NullCheckTag"));
            declaringClass.addTag(new KeyTag(3, "Nullness: Nullness Unknown", "NullCheckTag"));
        }
    }

    private void addColorTags(ValueBox vBox, FlowSet<RefIntPair> set, Unit u, BranchedRefVarsAnalysis analysis) {
        Value val = vBox.getValue();
        if (val.getType() instanceof RefLikeType) {
            switch (analysis.anyRefInfo(val, set)) {
                case 1: {
                    u.addTag(new StringTag(val + ": Null", "NullCheckTag"));
                    vBox.addTag(new ColorTag(0, "NullCheckTag"));
                    break;
                }
                case 2: {
                    u.addTag(new StringTag(val + ": NonNull", "NullCheckTag"));
                    vBox.addTag(new ColorTag(1, "NullCheckTag"));
                    break;
                }
                case 99: {
                    u.addTag(new StringTag(val + ": Nullness Unknown", "NullCheckTag"));
                    vBox.addTag(new ColorTag(3, "NullCheckTag"));
                    break;
                }
                case 0: {
                    u.addTag(new StringTag(val + ": Nullness Unknown", "NullCheckTag"));
                    vBox.addTag(new ColorTag(3, "NullCheckTag"));
                }
            }
        }
    }
}

