/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.G;
import soot.NullType;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.options.CGOptions;
import soot.toolkits.scalar.Pair;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.queue.ChunkedQueue;

public class VirtualCalls {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualCalls.class);
    private final CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
    protected MultiMap<Pair<Type, SootMethodRef>, Pair<Type, SootMethodRef>> baseToPossibleSubTypes = new HashMultiMap<Pair<Type, SootMethodRef>, Pair<Type, SootMethodRef>>();

    public VirtualCalls(Singletons.Global g) {
    }

    public static VirtualCalls v() {
        return G.v().soot_jimple_toolkits_callgraph_VirtualCalls();
    }

    public SootMethod resolveSpecial(SootMethodRef calleeRef, SootMethod container2) {
        return this.resolveSpecial(calleeRef, container2, false);
    }

    public SootMethod resolveSpecial(SootMethodRef calleeRef, SootMethod container2, boolean appOnly) {
        SootMethod callee = calleeRef.resolve();
        SootClass containerCls = container2.getDeclaringClass();
        SootClass calleeCls = callee.getDeclaringClass();
        if (containerCls.getType() != calleeCls.getType() && Scene.v().getOrMakeFastHierarchy().canStoreType(containerCls.getType(), calleeCls.getType()) && !"<init>".equals(callee.getName()) && !"<clinit>".equals(callee.getName()) && !calleeCls.isInterface()) {
            return this.resolveNonSpecial(containerCls.getSuperclass().getType(), calleeRef, appOnly);
        }
        return callee;
    }

    public SootMethod resolveNonSpecial(RefType t, SootMethodRef callee) {
        return this.resolveNonSpecial(t, callee, false);
    }

    public SootMethod resolveNonSpecial(RefType t, SootMethodRef callee, boolean appOnly) {
        SootClass cls = t.getSootClass();
        if (appOnly && cls.isLibraryClass()) {
            return null;
        }
        if (!cls.isInterface()) {
            return Scene.v().getOrMakeFastHierarchy().resolveConcreteDispatch(cls, callee);
        }
        return null;
    }

    public void resolve(Type t, Type declaredType, SootMethodRef callee, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, null, callee, container2, targets);
    }

    public void resolve(Type t, Type declaredType, SootMethodRef callee, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        this.resolve(t, declaredType, null, callee, container2, targets, appOnly);
    }

    public void resolve(Type t, Type declaredType, Type sigType, SootMethodRef callee, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, sigType, callee, container2, targets, false);
    }

    public void resolve(Type t, Type declaredType, Type sigType, SootMethodRef callee, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType instanceof ArrayType) {
            declaredType = Scene.v().getObjectType();
        }
        if (sigType instanceof ArrayType) {
            sigType = Scene.v().getObjectType();
        }
        if (t instanceof ArrayType) {
            t = Scene.v().getObjectType();
        }
        FastHierarchy fastHierachy = Scene.v().getOrMakeFastHierarchy();
        if (declaredType != null && !fastHierachy.canStoreType(t, declaredType)) {
            return;
        }
        if (sigType != null && !fastHierachy.canStoreType(t, sigType)) {
            return;
        }
        if (t instanceof RefType) {
            SootMethod target = this.resolveNonSpecial((RefType)t, callee, appOnly);
            if (target != null) {
                targets.add(target);
            }
        } else if (t instanceof AnySubType) {
            RefType base = ((AnySubType)t).getBase();
            if (this.options.library() == 3 && base.getSootClass().isInterface()) {
                LOGGER.warn("Deprecated library dispatch is conducted. The results might be unsound...");
                this.resolveLibrarySignature(declaredType, sigType, callee, container2, targets, appOnly, base);
            } else {
                for (SootMethod dispatch : Scene.v().getOrMakeFastHierarchy().resolveAbstractDispatch(base.getSootClass(), callee)) {
                    targets.add(dispatch);
                }
            }
        } else {
            if (t instanceof NullType) {
                return;
            }
            if (t instanceof PrimType) {
                return;
            }
            throw new RuntimeException("oops " + t);
        }
    }

    public void resolveSuperType(Type t, Type declaredType, SootMethodRef callee, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType == null || t == null) {
            return;
        }
        if (declaredType instanceof ArrayType) {
            declaredType = Scene.v().getObjectType();
        }
        if (t instanceof ArrayType) {
            t = Scene.v().getObjectType();
        }
        if (declaredType instanceof RefType) {
            SootMethod target;
            RefType child;
            if (t instanceof AnySubType) {
                child = ((AnySubType)t).getBase();
            } else if (t instanceof RefType) {
                child = (RefType)t;
            } else {
                return;
            }
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            if (fh.canStoreClass(child.getSootClass(), ((RefType)declaredType).getSootClass()) && (target = this.resolveNonSpecial(child, callee, appOnly)) != null) {
                targets.add(target);
            }
        }
    }

    @Deprecated
    protected void resolveLibrarySignature(Type declaredType, Type sigType, SootMethodRef callee, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly, RefType base) {
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        assert (declaredType instanceof RefType);
        Pair<RefType, SootMethodRef> pair = new Pair<RefType, SootMethodRef>(base, callee);
        Set<Pair<Type, SootMethodRef>> types = this.baseToPossibleSubTypes.get(pair);
        if (types != null) {
            for (Pair<Type, SootMethodRef> tuple : types) {
                Type st = tuple.getO1();
                if (!fh.canStoreType(st, declaredType)) {
                    this.resolve(st, st, sigType, callee, container2, targets, appOnly);
                    continue;
                }
                this.resolve(st, declaredType, sigType, callee, container2, targets, appOnly);
            }
            return;
        }
        types = new HashSet<Pair<Type, SootMethodRef>>();
        Type declaredReturnType = callee.getReturnType();
        List<Type> declaredParamTypes = callee.getParameterTypes();
        String declaredName = callee.getName();
        for (SootClass sc : Scene.v().getClasses()) {
            for (SootMethod sm : sc.getMethods()) {
                if (sm.isAbstract() || !sm.getName().equals(declaredName) || !fh.canStoreType(sm.getReturnType(), declaredReturnType)) continue;
                List<Type> paramTypes = sm.getParameterTypes();
                if (declaredParamTypes.size() != paramTypes.size()) continue;
                boolean check = true;
                for (int i = 0; i < paramTypes.size(); ++i) {
                    if (fh.canStoreType(declaredParamTypes.get(i), paramTypes.get(i))) continue;
                    check = false;
                    break;
                }
                if (!check) continue;
                RefType st = sc.getType();
                if (!fh.canStoreType(st, declaredType)) {
                    if (sc.isFinal()) continue;
                    this.resolve(st, st, sigType, sm.makeRef(), container2, targets, appOnly);
                    types.add(new Pair<RefType, SootMethodRef>(st, sm.makeRef()));
                    continue;
                }
                this.resolve(st, declaredType, sigType, callee, container2, targets, appOnly);
                types.add(new Pair<RefType, SootMethodRef>(st, callee));
            }
        }
        this.baseToPossibleSubTypes.putAll(pair, types);
    }
}

