/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Hierarchy;
import soot.Local;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.InstanceInvokeEdgesPred;
import soot.jimple.toolkits.callgraph.Targets;
import soot.jimple.toolkits.invoke.AccessManager;
import soot.jimple.toolkits.invoke.SynchronizerManager;
import soot.jimple.toolkits.invoke.ThrowManager;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.options.SMBOptions;

public class StaticMethodBinder
extends SceneTransformer {
    public StaticMethodBinder(Singletons.Global g) {
    }

    public static StaticMethodBinder v() {
        return G.v().soot_jimple_toolkits_invoke_StaticMethodBinder();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> opts) {
        Filter instanceInvokesFilter = new Filter(new InstanceInvokeEdgesPred());
        SMBOptions options = new SMBOptions(opts);
        String modifierOptions = PhaseOptions.getString(opts, "allowed-modifier-changes");
        HashMap<SootMethod, SootMethod> instanceToStaticMap = new HashMap<SootMethod, SootMethod>();
        Scene scene = Scene.v();
        CallGraph cg = scene.getCallGraph();
        Hierarchy hierarchy = scene.getActiveHierarchy();
        for (SootClass c : scene.getApplicationClasses()) {
            LinkedList<SootMethod> methodsList = new LinkedList<SootMethod>();
            Iterator<SootMethod> it = c.methodIterator();
            while (it.hasNext()) {
                SootMethod next = it.next();
                methodsList.add(next);
            }
            while (!methodsList.isEmpty()) {
                SootMethod container2 = (SootMethod)methodsList.removeFirst();
                if (!container2.isConcrete() || !instanceInvokesFilter.wrap(cg.edgesOutOf(container2)).hasNext()) continue;
                Body b = container2.getActiveBody();
                UnitPatchingChain bUnits = b.getUnits();
                for (Unit u : new ArrayList<Unit>(bUnits)) {
                    Jimple jimp;
                    SootClass localType;
                    Value invokeBase;
                    SootClass targetDeclClass;
                    Targets targets;
                    InvokeExpr ie;
                    Stmt s = (Stmt)u;
                    if (!s.containsInvokeExpr() || (ie = s.getInvokeExpr()) instanceof StaticInvokeExpr || ie instanceof SpecialInvokeExpr || !(targets = new Targets(instanceInvokesFilter.wrap(cg.edgesOutOf(s)))).hasNext()) continue;
                    SootMethod target = (SootMethod)targets.next();
                    if (targets.hasNext() || !AccessManager.ensureAccess(container2, target, modifierOptions) || !(targetDeclClass = target.getDeclaringClass()).isApplicationClass() || !target.isConcrete() || targetDeclClass == scene.getSootClass(Scene.v().getObjectType().toString())) continue;
                    if (!instanceToStaticMap.containsKey(target)) {
                        ArrayList<Type> newParameterTypes = new ArrayList<Type>();
                        newParameterTypes.add(RefType.v(targetDeclClass.getName()));
                        newParameterTypes.addAll(target.getParameterTypes());
                        String newName = target.getName();
                        while (targetDeclClass.declaresMethod(newName = newName + "_static", newParameterTypes, target.getReturnType())) {
                        }
                        SootMethod ct = scene.makeSootMethod(newName, newParameterTypes, target.getReturnType(), target.getModifiers() | 8, target.getExceptions());
                        targetDeclClass.addMethod(ct);
                        methodsList.addLast(ct);
                        Body ctBody = (Body)target.getActiveBody().clone();
                        ct.setActiveBody(ctBody);
                        Iterator oldUnits = target.getActiveBody().getUnits().iterator();
                        for (Unit newStmt : ctBody.getUnits()) {
                            Unit oldStmt = (Unit)oldUnits.next();
                            Iterator<Edge> edges = cg.edgesOutOf(oldStmt);
                            while (edges.hasNext()) {
                                Edge e = edges.next();
                                cg.addEdge(new Edge(ct, newStmt, e.tgt(), e.kind()));
                                cg.removeEdge(e);
                            }
                        }
                        UnitPatchingChain ctBodyUnits = ctBody.getUnits();
                        Iterator unitsIt = ctBodyUnits.snapshotIterator();
                        while (unitsIt.hasNext()) {
                            Stmt st = (Stmt)unitsIt.next();
                            if (!(st instanceof IdentityStmt)) continue;
                            IdentityStmt is = (IdentityStmt)st;
                            Value rightOp = is.getRightOp();
                            if (rightOp instanceof ThisRef) {
                                Jimple jimp2 = Jimple.v();
                                ctBodyUnits.swapWith(st, jimp2.newIdentityStmt(is.getLeftOp(), jimp2.newParameterRef(rightOp.getType(), 0)));
                                continue;
                            }
                            if (!(rightOp instanceof ParameterRef)) continue;
                            ParameterRef ro = (ParameterRef)rightOp;
                            ro.setIndex(ro.getIndex() + 1);
                        }
                        instanceToStaticMap.put(target, ct);
                    }
                    Value thisToAdd = invokeBase = ((InstanceInvokeExpr)ie).getBase();
                    if (options.insert_redundant_casts() && ((localType = ((RefType)invokeBase.getType()).getSootClass()).isInterface() || hierarchy.isClassSuperclassOf(localType, targetDeclClass))) {
                        jimp = Jimple.v();
                        RefType targetDeclClassType = targetDeclClass.getType();
                        Local castee = jimp.newLocal("__castee", targetDeclClassType);
                        b.getLocals().add(castee);
                        bUnits.insertBefore(jimp.newAssignStmt(castee, jimp.newCastExpr(invokeBase, targetDeclClassType)), s);
                        thisToAdd = castee;
                    }
                    SootMethod clonedTarget = (SootMethod)instanceToStaticMap.get(target);
                    ArrayList<Value> newArgs = new ArrayList<Value>();
                    newArgs.add(thisToAdd);
                    newArgs.addAll(ie.getArgs());
                    s.getInvokeExprBox().setValue(Jimple.v().newStaticInvokeExpr(clonedTarget.makeRef(), newArgs));
                    cg.addEdge(new Edge(container2, s, clonedTarget));
                    if (options.insert_null_checks()) {
                        jimp = Jimple.v();
                        if (TrapManager.isExceptionCaughtAt(scene.getSootClass("java.lang.NullPointerException"), s, b)) {
                            IfStmt insertee = jimp.newIfStmt((Value)jimp.newNeExpr(invokeBase, NullConstant.v()), s);
                            bUnits.insertBefore(insertee, s);
                            insertee.setTarget(s);
                            ThrowManager.addThrowAfter(b.getLocals(), bUnits, insertee);
                        } else {
                            bUnits.insertBefore(jimp.newIfStmt((Value)jimp.newEqExpr(invokeBase, NullConstant.v()), ThrowManager.getNullPointerExceptionThrower(b)), s);
                        }
                    }
                    if (target.isSynchronized()) {
                        clonedTarget.setModifiers(clonedTarget.getModifiers() & 0xFFFFFFDF);
                        SynchronizerManager.v().synchronizeStmtOn(s, b, (Local)invokeBase);
                    }
                    LocalNameStandardizer.v().transform(b, phaseName + ".lns");
                }
            }
        }
    }
}

