/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.ArrayList;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.NeExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.toolkits.pointer.CastCheckTag;
import soot.jimple.toolkits.pointer.LocalTypeSet;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;

public class CastCheckEliminator
extends ForwardBranchedFlowAnalysis<LocalTypeSet> {
    protected LocalTypeSet emptySet;

    public CastCheckEliminator(BriefUnitGraph cfg) {
        super(cfg);
        this.makeInitialSet();
        this.doAnalysis();
        this.tagCasts();
    }

    protected void tagCasts() {
        for (Unit u : ((UnitGraph)this.graph).getBody().getUnits()) {
            CastExpr cast;
            Type t;
            Value rhs;
            if (!(u instanceof AssignStmt) || !((rhs = ((AssignStmt)u).getRightOp()) instanceof CastExpr) || !((t = (cast = (CastExpr)rhs).getCastType()) instanceof RefType)) continue;
            Value op = cast.getOp();
            if (op instanceof Local) {
                LocalTypeSet set = (LocalTypeSet)this.getFlowBefore(u);
                u.addTag(new CastCheckTag(set.get(set.indexOf((Local)op, (RefType)t))));
                continue;
            }
            assert (op instanceof NullConstant);
            u.addTag(new CastCheckTag(true));
        }
    }

    protected void makeInitialSet() {
        Body body = ((UnitGraph)this.graph).getBody();
        ArrayList<Local> refLocals = new ArrayList<Local>();
        for (Local l : body.getLocals()) {
            if (!(l.getType() instanceof RefType)) continue;
            refLocals.add(l);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Unit u : body.getUnits()) {
            Type t;
            Value rhs;
            if (!(u instanceof AssignStmt) || !((rhs = ((AssignStmt)u).getRightOp()) instanceof CastExpr) || !((t = ((CastExpr)rhs).getCastType()) instanceof RefType) || types.contains(t)) continue;
            types.add(t);
        }
        this.emptySet = new LocalTypeSet(refLocals, types);
    }

    @Override
    protected LocalTypeSet newInitialFlow() {
        LocalTypeSet ret = (LocalTypeSet)this.emptySet.clone();
        ret.setAllBits();
        return ret;
    }

    @Override
    protected void flowThrough(LocalTypeSet in, Unit unit, List<LocalTypeSet> outFallVals, List<LocalTypeSet> outBranchVals) {
        LocalTypeSet out;
        LocalTypeSet outBranch = out = (LocalTypeSet)in.clone();
        for (ValueBox b : unit.getDefBoxes()) {
            Value v = b.getValue();
            if (!(v instanceof Local) || !(v.getType() instanceof RefType)) continue;
            out.killLocal((Local)v);
        }
        if (unit instanceof AssignStmt) {
            AssignStmt astmt = (AssignStmt)unit;
            Value rhs = astmt.getRightOp();
            Value lhs = astmt.getLeftOp();
            if (lhs instanceof Local && rhs.getType() instanceof RefType) {
                Local l = (Local)lhs;
                if (rhs instanceof NewExpr) {
                    out.localMustBeSubtypeOf(l, (RefType)rhs.getType());
                } else if (rhs instanceof CastExpr) {
                    CastExpr cast = (CastExpr)rhs;
                    Type castType = cast.getCastType();
                    if (castType instanceof RefType && cast.getOp() instanceof Local) {
                        RefType refType = (RefType)castType;
                        Local opLocal = (Local)cast.getOp();
                        out.localCopy(l, opLocal);
                        out.localMustBeSubtypeOf(l, refType);
                        out.localMustBeSubtypeOf(opLocal, refType);
                    }
                } else if (rhs instanceof Local) {
                    out.localCopy(l, (Local)rhs);
                }
            }
        } else if (unit instanceof IfStmt) {
            Value conditionOp2;
            ConditionExpr c;
            Value iofOp;
            InstanceOfExpr iofexpr;
            Type iofCheckType;
            AssignStmt pred;
            Value predRHS;
            Unit predecessor;
            IfStmt ifstmt = (IfStmt)unit;
            List<Unit> unitPreds = this.graph.getPredsOf(unit);
            if (unitPreds.size() == 1 && (predecessor = unitPreds.get(0)) instanceof AssignStmt && (predRHS = (pred = (AssignStmt)predecessor).getRightOp()) instanceof InstanceOfExpr && (iofCheckType = (iofexpr = (InstanceOfExpr)predRHS).getCheckType()) instanceof RefType && (iofOp = iofexpr.getOp()) instanceof Local && (c = (ConditionExpr)ifstmt.getCondition()).getOp1().equals(pred.getLeftOp()) && (conditionOp2 = c.getOp2()) instanceof IntConstant && ((IntConstant)conditionOp2).value == 0) {
                if (c instanceof NeExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    outBranch.localMustBeSubtypeOf((Local)iofOp, (RefType)iofCheckType);
                } else if (c instanceof EqExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    out.localMustBeSubtypeOf((Local)iofOp, (RefType)iofCheckType);
                }
            }
        }
        for (LocalTypeSet ts : outFallVals) {
            this.copy(out, ts);
        }
        for (LocalTypeSet ts : outBranchVals) {
            this.copy(outBranch, ts);
        }
    }

    @Override
    protected void copy(LocalTypeSet s, LocalTypeSet d) {
        d.and(s);
        d.or(s);
    }

    @Override
    protected void merge(LocalTypeSet in1, LocalTypeSet in2, LocalTypeSet o) {
        o.setAllBits();
        o.and(in1);
        o.and(in2);
    }

    @Override
    protected LocalTypeSet entryInitialFlow() {
        return (LocalTypeSet)this.emptySet.clone();
    }
}

