/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.reflection;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.tagkit.Host;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.Tag;

public class ReflectionTraceInfo {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionTraceInfo.class);
    protected final Map<SootMethod, Set<String>> classForNameReceivers = new LinkedHashMap<SootMethod, Set<String>>();
    protected final Map<SootMethod, Set<String>> classNewInstanceReceivers = new LinkedHashMap<SootMethod, Set<String>>();
    protected final Map<SootMethod, Set<String>> constructorNewInstanceReceivers = new LinkedHashMap<SootMethod, Set<String>>();
    protected final Map<SootMethod, Set<String>> methodInvokeReceivers = new LinkedHashMap<SootMethod, Set<String>>();
    protected final Map<SootMethod, Set<String>> fieldSetReceivers = new LinkedHashMap<SootMethod, Set<String>>();
    protected final Map<SootMethod, Set<String>> fieldGetReceivers = new LinkedHashMap<SootMethod, Set<String>>();

    public ReflectionTraceInfo(String logFile) {
        if (logFile == null) {
            throw new InternalError("Trace based refection model enabled but no trace file given!?");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));){
            String line;
            Scene sc = Scene.v();
            HashSet<String> ignoredKinds = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] portions = line.split(";", -1);
                String kind = portions[0];
                String target = portions[1];
                String source = portions[2];
                int lineNumber = portions[3].length() == 0 ? -1 : Integer.parseInt(portions[3]);
                block25: for (SootMethod sourceMethod : this.inferSource(source, lineNumber)) {
                    switch (kind) {
                        case "Class.forName": {
                            Set<String> receiverNames = this.classForNameReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.classForNameReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                        case "Class.newInstance": {
                            Set<String> receiverNames = this.classNewInstanceReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.classNewInstanceReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                        case "Method.invoke": {
                            if (!sc.containsMethod(target)) {
                                throw new RuntimeException("Unknown method for signature: " + target);
                            }
                            Set<String> receiverNames = this.methodInvokeReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.methodInvokeReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                        case "Constructor.newInstance": {
                            if (!sc.containsMethod(target)) {
                                throw new RuntimeException("Unknown method for signature: " + target);
                            }
                            Set<String> receiverNames = this.constructorNewInstanceReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.constructorNewInstanceReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                        case "Field.set*": {
                            if (!sc.containsField(target)) {
                                throw new RuntimeException("Unknown method for signature: " + target);
                            }
                            Set<String> receiverNames = this.fieldSetReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.fieldSetReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                        case "Field.get*": {
                            if (!sc.containsField(target)) {
                                throw new RuntimeException("Unknown method for signature: " + target);
                            }
                            Set<String> receiverNames = this.fieldGetReceivers.get(sourceMethod);
                            if (receiverNames == null) {
                                receiverNames = new LinkedHashSet<String>();
                                this.fieldGetReceivers.put(sourceMethod, receiverNames);
                            }
                            receiverNames.add(target);
                            continue block25;
                        }
                    }
                    ignoredKinds.add(kind);
                }
            }
            if (!ignoredKinds.isEmpty()) {
                logger.debug("Encountered reflective calls entries of the following kinds that\ncannot currently be handled:");
                for (String kind : ignoredKinds) {
                    logger.debug(kind);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Trace file not found.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<SootMethod> inferSource(String source, int lineNumber) {
        int dotIndex = source.lastIndexOf(46);
        String className = source.substring(0, dotIndex);
        String methodName = source.substring(dotIndex + 1);
        Scene scene = Scene.v();
        if (!scene.containsClass(className)) {
            scene.addBasicClass(className, 3);
            scene.loadBasicClasses();
            if (!scene.containsClass(className)) {
                throw new RuntimeException("Trace file refers to unknown class: " + className);
            }
        }
        LinkedHashSet<SootMethod> methodsWithRightName = new LinkedHashSet<SootMethod>();
        for (SootMethod m : scene.getSootClass(className).getMethods()) {
            if (!m.isConcrete() || !m.getName().equals(methodName)) continue;
            methodsWithRightName.add(m);
        }
        if (methodsWithRightName.isEmpty()) {
            throw new RuntimeException("Trace file refers to unknown method with name " + methodName + " in Class " + className);
        }
        if (methodsWithRightName.size() == 1) {
            return Collections.singleton((SootMethod)methodsWithRightName.iterator().next());
        }
        for (SootMethod sootMethod : methodsWithRightName) {
            Body body;
            if (this.coversLineNumber(lineNumber, sootMethod)) {
                return Collections.singleton(sootMethod);
            }
            if (!sootMethod.isConcrete()) continue;
            if (!sootMethod.hasActiveBody()) {
                sootMethod.retrieveActiveBody();
            }
            if (this.coversLineNumber(lineNumber, body = sootMethod.getActiveBody())) {
                return Collections.singleton(sootMethod);
            }
            for (Unit u : body.getUnits()) {
                if (!this.coversLineNumber(lineNumber, u)) continue;
                return Collections.singleton(sootMethod);
            }
        }
        return methodsWithRightName;
    }

    private boolean coversLineNumber(int lineNumber, Host host) {
        Tag tag = (SourceLnPosTag)host.getTag("SourceLnPosTag");
        if (tag != null && ((SourceLnPosTag)tag).startLn() <= lineNumber && ((SourceLnPosTag)tag).endLn() >= lineNumber) {
            return true;
        }
        tag = (LineNumberTag)host.getTag("LineNumberTag");
        return tag != null && ((LineNumberTag)tag).getLineNumber() == lineNumber;
    }

    public Set<String> classForNameClassNames(SootMethod container2) {
        Set<String> ret = this.classForNameReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public Set<SootClass> classForNameClasses(SootMethod container2) {
        LinkedHashSet<SootClass> result = new LinkedHashSet<SootClass>();
        for (String className : this.classForNameClassNames(container2)) {
            result.add(Scene.v().getSootClass(className));
        }
        return result;
    }

    public Set<String> classNewInstanceClassNames(SootMethod container2) {
        Set<String> ret = this.classNewInstanceReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public Set<SootClass> classNewInstanceClasses(SootMethod container2) {
        LinkedHashSet<SootClass> result = new LinkedHashSet<SootClass>();
        for (String className : this.classNewInstanceClassNames(container2)) {
            result.add(Scene.v().getSootClass(className));
        }
        return result;
    }

    public Set<String> constructorNewInstanceSignatures(SootMethod container2) {
        Set<String> ret = this.constructorNewInstanceReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public Set<SootMethod> constructorNewInstanceConstructors(SootMethod container2) {
        LinkedHashSet<SootMethod> result = new LinkedHashSet<SootMethod>();
        for (String signature : this.constructorNewInstanceSignatures(container2)) {
            result.add(Scene.v().getMethod(signature));
        }
        return result;
    }

    public Set<String> methodInvokeSignatures(SootMethod container2) {
        Set<String> ret = this.methodInvokeReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public Set<SootMethod> methodInvokeMethods(SootMethod container2) {
        LinkedHashSet<SootMethod> result = new LinkedHashSet<SootMethod>();
        for (String signature : this.methodInvokeSignatures(container2)) {
            result.add(Scene.v().getMethod(signature));
        }
        return result;
    }

    public Set<SootMethod> methodsContainingReflectiveCalls() {
        LinkedHashSet<SootMethod> res = new LinkedHashSet<SootMethod>();
        res.addAll(this.classForNameReceivers.keySet());
        res.addAll(this.classNewInstanceReceivers.keySet());
        res.addAll(this.constructorNewInstanceReceivers.keySet());
        res.addAll(this.methodInvokeReceivers.keySet());
        return res;
    }

    public Set<String> fieldSetSignatures(SootMethod container2) {
        Set<String> ret = this.fieldSetReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public Set<String> fieldGetSignatures(SootMethod container2) {
        Set<String> ret = this.fieldGetReceivers.get(container2);
        return ret != null ? ret : Collections.emptySet();
    }

    public static enum Kind {
        ClassForName,
        ClassNewInstance,
        ConstructorNewInstance,
        MethodInvoke,
        FieldSet,
        FieldGet;

    }
}

