/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.NopUnit;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.util.Chain;

public class NopEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(NopEliminator.class);

    public NopEliminator(Singletons.Global g) {
    }

    public static NopEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_NopEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "] Removing nops...");
        }
        Chain<Trap> traps = b.getTraps();
        UnitPatchingChain units = b.getUnits();
        Iterator stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            Unit u = (Unit)stmtIt.next();
            if (!(u instanceof NopUnit)) continue;
            boolean keepNop = false;
            if (units.getLast() == u) {
                for (Trap t : traps) {
                    if (t.getEndUnit() != u) continue;
                    keepNop = true;
                }
            }
            if (keepNop) continue;
            units.remove(u);
        }
    }
}

