/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.PegChain;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.SCC;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class CompactStronglyConnectedComponents {
    long compactNodes = 0L;
    long add = 0L;

    public CompactStronglyConnectedComponents(PegGraph pg) {
        PegChain mainPegChain = pg.getMainPegChain();
        this.compactGraph(mainPegChain, pg);
        this.compactStartChain(pg);
        System.err.println("compact SCC nodes: " + this.compactNodes);
        System.err.println(" number of compacting scc nodes: " + this.add);
    }

    private void compactGraph(Chain chain, PegGraph peg) {
        Set canNotBeCompacted = peg.getCanNotBeCompacted();
        SCC scc = new SCC(chain.iterator(), peg);
        List sccList = scc.getSccList();
        for (List s : sccList) {
            if (s.size() <= 1 || this.checkIfContainsElemsCanNotBeCompacted(s, canNotBeCompacted)) continue;
            ++this.add;
            this.compact(s, chain, peg);
        }
    }

    private void compactStartChain(PegGraph graph) {
        Set<Map.Entry<JPegStmt, List>> maps = graph.getStartToThread().entrySet();
        for (Map.Entry<JPegStmt, List> entry : maps) {
            List runMethodChainList = entry.getValue();
            for (Chain chain : runMethodChainList) {
                this.compactGraph(chain, graph);
            }
        }
    }

    private boolean checkIfContainsElemsCanNotBeCompacted(List list, Set canNotBeCompacted) {
        for (JPegStmt node : list) {
            if (!canNotBeCompacted.contains(node)) continue;
            return true;
        }
        return false;
    }

    private void compact(List list, Chain chain, PegGraph peg) {
        Iterator it = list.iterator();
        FlowSet allNodes = peg.getAllNodes();
        HashMap unitToSuccs = peg.getUnitToSuccs();
        HashMap unitToPreds = peg.getUnitToPreds();
        ArrayList newPreds = new ArrayList();
        ArrayList newSuccs = new ArrayList();
        while (it.hasNext()) {
            JPegStmt s = (JPegStmt)it.next();
            for (Object pred : peg.getPredsOf(s)) {
                List succsOfPred = peg.getSuccsOf(pred);
                succsOfPred.remove(s);
                if (list.contains(pred)) continue;
                newPreds.add(pred);
                succsOfPred.add(list);
            }
            for (Object succ : peg.getSuccsOf(s)) {
                List predsOfSucc = peg.getPredsOf(succ);
                predsOfSucc.remove(s);
                if (list.contains(succ)) continue;
                newSuccs.add(succ);
                predsOfSucc.add(list);
            }
        }
        unitToSuccs.put(list, newSuccs);
        unitToPreds.put(list, newPreds);
        allNodes.add(list);
        chain.add(list);
        this.updateMonitor(peg, list);
        for (JPegStmt s : list) {
            chain.remove(s);
            allNodes.remove(s);
            unitToSuccs.remove(s);
            unitToPreds.remove(s);
        }
        this.compactNodes += (long)list.size();
    }

    private void updateMonitor(PegGraph pg, List list) {
        Set<Map.Entry<String, FlowSet>> maps = pg.getMonitor().entrySet();
        block0: for (Map.Entry<String, FlowSet> entry : maps) {
            FlowSet fs = entry.getValue();
            for (Object obj : list) {
                if (!fs.contains(obj)) continue;
                fs.add(list);
                continue block0;
            }
        }
    }
}

