/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import soot.tagkit.AnnotationElem;
import soot.tagkit.IAnnotationElemTypeSwitch;
import soot.util.Switch;

public class AnnotationIntElem
extends AnnotationElem {
    private final int value;

    public AnnotationIntElem(int v, char kind, String name) {
        super(kind, name);
        this.value = v;
    }

    public AnnotationIntElem(int v, String name) {
        this(v, 'I', name);
    }

    public AnnotationIntElem(Byte v, String name) {
        this(v.byteValue(), 'B', name);
    }

    public AnnotationIntElem(Character v, String name) {
        this(v.charValue(), 'C', name);
    }

    public AnnotationIntElem(Short v, String name) {
        this(v.shortValue(), 'S', name);
    }

    @Override
    public String toString() {
        return super.toString() + " value: " + this.value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void apply(Switch sw) {
        ((IAnnotationElemTypeSwitch)sw).caseAnnotationIntElem(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationIntElem other = (AnnotationIntElem)obj;
        return this.value == other.value;
    }
}

