/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderOffsetInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.MethodImplementationBuilder;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.ImmutableAnnotation;
import org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import org.jf.dexlib2.immutable.ImmutableClassDef;
import org.jf.dexlib2.immutable.ImmutableExceptionHandler;
import org.jf.dexlib2.immutable.ImmutableField;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableStringReference;
import org.jf.dexlib2.immutable.reference.ImmutableTypeReference;
import org.jf.dexlib2.immutable.value.ImmutableAnnotationEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableArrayEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableBooleanEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEnumEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFieldEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableMethodEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableNullEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableStringEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableTypeEncodedValue;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.CompilationDeathException;
import soot.IntType;
import soot.Local;
import soot.PackManager;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SourceLocator;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.dexpler.DexInnerClassParser;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.jimple.ClassConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.MonitorStmt;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.EmptySwitchEliminator;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toDex.DexArrayInitDetector;
import soot.toDex.DexPrinterException;
import soot.toDex.FastDexTrapTightener;
import soot.toDex.LabelAssigner;
import soot.toDex.LocalRegisterAssignmentInformation;
import soot.toDex.MultiDexBuilder;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.SynchronizedMethodTransformer;
import soot.toDex.TrapSplitter;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn10t;
import soot.toDex.instructions.Insn30t;
import soot.toDex.instructions.InsnWithOffset;
import soot.util.Chain;

public class DexPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DexPrinter.class);
    public static final Pattern SIGNATURE_FILE_PATTERN = Pattern.compile("META-INF/[^/]+(\\.SF|\\.DSA|\\.RSA|\\.EC)$");
    protected MultiDexBuilder dexBuilder = this.createDexBuilder();
    protected File originalApk;

    protected MultiDexBuilder createDexBuilder() {
        Scene.AndroidVersionInfo androidSDKVersionInfo = Scene.v().getAndroidSDKVersionInfo();
        int apiLevel = androidSDKVersionInfo == null ? Scene.v().getAndroidAPIVersion() : Math.min(androidSDKVersionInfo.minSdkVersion, androidSDKVersionInfo.sdkTargetVersion);
        return new MultiDexBuilder(Opcodes.forApi((int)apiLevel));
    }

    private static boolean isSignatureFile(String fileName) {
        return SIGNATURE_FILE_PATTERN.matcher(fileName).matches();
    }

    private static int getVisibility(int visibility) {
        if (visibility == 0) {
            return 1;
        }
        if (visibility == 1) {
            return 2;
        }
        if (visibility == 2) {
            return 0;
        }
        throw new DexPrinterException("Unknown annotation visibility: '" + visibility + "'");
    }

    protected static FieldReference toFieldReference(SootField f) {
        ImmutableFieldReference fieldRef = new ImmutableFieldReference(SootToDexUtils.getDexClassName(f.getDeclaringClass().getName()), f.getName(), SootToDexUtils.getDexTypeDescriptor(f.getType()));
        return fieldRef;
    }

    protected static FieldReference toFieldReference(SootFieldRef ref) {
        ImmutableFieldReference fieldRef = new ImmutableFieldReference(SootToDexUtils.getDexClassName(ref.declaringClass().getName()), ref.name(), SootToDexUtils.getDexTypeDescriptor(ref.type()));
        return fieldRef;
    }

    protected static MethodReference toMethodReference(SootMethodRef m) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Type t : m.getParameterTypes()) {
            parameters.add(SootToDexUtils.getDexTypeDescriptor(t));
        }
        return new ImmutableMethodReference(SootToDexUtils.getDexClassName(m.getDeclaringClass().getName()), m.getName(), parameters, SootToDexUtils.getDexTypeDescriptor(m.getReturnType()));
    }

    public static TypeReference toTypeReference(Type t) {
        return new ImmutableTypeReference(SootToDexUtils.getDexTypeDescriptor(t));
    }

    private void printZip() throws IOException {
        try (ZipOutputStream outputZip = this.getZipOutputStream();){
            Path tempPath;
            List<File> files;
            LOGGER.info("Do not forget to sign the .apk file with jarsigner and to align it with zipalign");
            if (this.originalApk != null) {
                try (ZipFile original = new ZipFile(this.originalApk);){
                    this.copyAllButClassesDexAndSigFiles(original, outputZip);
                }
            }
            if (!(files = this.dexBuilder.writeTo((tempPath = Files.createTempDirectory(Long.toString(System.nanoTime()), new FileAttribute[0])).toString())).isEmpty()) {
                byte[] buffer = new byte[16384];
                for (File file : files) {
                    try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                        int read;
                        outputZip.putNextEntry(new ZipEntry(file.getName()));
                        while ((read = is.read(buffer)) > 0) {
                            outputZip.write(buffer, 0, read);
                        }
                        outputZip.closeEntry();
                    }
                }
            }
            if (Options.v().output_jar()) {
                this.addManifest(outputZip, files);
            }
            Files.walkFileTree(tempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private ZipOutputStream getZipOutputStream() throws IOException {
        Path outputFile;
        String name;
        if (Options.v().output_jar()) {
            LOGGER.info("Writing JAR to \"{}\"", (Object)Options.v().output_dir());
            return PackManager.v().getJarFile();
        }
        String string = name = this.originalApk == null ? "out.apk" : this.originalApk.getName();
        if (this.originalApk == null) {
            LOGGER.warn("Setting output file name to \"{}\" as original APK has not been found.", (Object)name);
        }
        if (Files.exists(outputFile = Paths.get(SourceLocator.v().getOutputDir(), name), LinkOption.NOFOLLOW_LINKS)) {
            if (!Options.v().force_overwrite()) {
                throw new CompilationDeathException("Output file \"" + outputFile + "\" exists. Not overwriting.");
            }
            try {
                Files.delete(outputFile);
            }
            catch (IOException exception) {
                throw new IllegalStateException("Removing \"" + outputFile + "\" failed. Not writing out anything.", exception);
            }
        }
        LOGGER.info("Writing APK to \"{}\".", (Object)outputFile);
        return new ZipOutputStream(Files.newOutputStream(outputFile, StandardOpenOption.CREATE_NEW));
    }

    private void copyAllButClassesDexAndSigFiles(ZipFile source, ZipOutputStream destination) throws IOException {
        Enumeration<? extends ZipEntry> sourceEntries = source.entries();
        while (sourceEntries.hasMoreElements()) {
            ZipEntry sourceEntry = sourceEntries.nextElement();
            String sourceEntryName = sourceEntry.getName();
            if (sourceEntryName.endsWith(".dex") || DexPrinter.isSignatureFile(sourceEntryName)) continue;
            ZipEntry destinationEntry = new ZipEntry(sourceEntryName);
            destinationEntry.setMethod(sourceEntry.getMethod());
            destinationEntry.setSize(sourceEntry.getSize());
            destinationEntry.setCrc(sourceEntry.getCrc());
            destination.putNextEntry(destinationEntry);
            InputStream zipEntryInput = source.getInputStream(sourceEntry);
            try {
                int bytesRead;
                byte[] buffer = new byte[2048];
                while ((bytesRead = zipEntryInput.read(buffer)) > 0) {
                    destination.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (zipEntryInput == null) continue;
                zipEntryInput.close();
            }
        }
    }

    private void addManifest(ZipOutputStream destination, Collection<File> dexFiles) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(new Attributes.Name("Created-By"), "Soot Dex Printer");
        if (dexFiles != null && !dexFiles.isEmpty()) {
            manifest.getMainAttributes().put(new Attributes.Name("Dex-Location"), dexFiles.stream().map(File::getName).collect(Collectors.joining(" ")));
        }
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        destination.putNextEntry(manifestEntry);
        try (BufferedOutputStream bufOut = new BufferedOutputStream(destination);){
            manifest.write(bufOut);
            bufOut.flush();
        }
        destination.closeEntry();
    }

    private EncodedValue buildEncodedValueForAnnotation(AnnotationElem elem) {
        switch (elem.getKind()) {
            case 'Z': {
                if (elem instanceof AnnotationIntElem) {
                    AnnotationIntElem e = (AnnotationIntElem)elem;
                    switch (e.getValue()) {
                        case 0: {
                            return ImmutableBooleanEncodedValue.FALSE_VALUE;
                        }
                        case 1: {
                            return ImmutableBooleanEncodedValue.TRUE_VALUE;
                        }
                    }
                    throw new DexPrinterException("error: boolean value from int with value != 0 or 1.");
                }
                if (elem instanceof AnnotationBooleanElem) {
                    AnnotationBooleanElem e = (AnnotationBooleanElem)elem;
                    if (e.getValue()) {
                        return ImmutableBooleanEncodedValue.TRUE_VALUE;
                    }
                    return ImmutableBooleanEncodedValue.FALSE_VALUE;
                }
                throw new DexPrinterException("Annotation type incompatible with target type boolean");
            }
            case 'S': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableShortEncodedValue((short)e.getValue());
            }
            case 'B': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableByteEncodedValue((byte)e.getValue());
            }
            case 'C': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableCharEncodedValue((char)e.getValue());
            }
            case 'I': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableIntEncodedValue(e.getValue());
            }
            case 'J': {
                AnnotationLongElem e = (AnnotationLongElem)elem;
                return new ImmutableLongEncodedValue(e.getValue());
            }
            case 'F': {
                AnnotationFloatElem e = (AnnotationFloatElem)elem;
                return new ImmutableFloatEncodedValue(e.getValue());
            }
            case 'D': {
                AnnotationDoubleElem e = (AnnotationDoubleElem)elem;
                return new ImmutableDoubleEncodedValue(e.getValue());
            }
            case 's': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                return new ImmutableStringEncodedValue(e.getValue());
            }
            case 'e': {
                String classT;
                AnnotationEnumElem e = (AnnotationEnumElem)elem;
                String fieldT = classT = SootToDexUtils.getDexClassName(e.getTypeName());
                return new ImmutableEnumEncodedValue(new ImmutableFieldReference(classT, e.getConstantName(), fieldT));
            }
            case 'c': {
                AnnotationClassElem e = (AnnotationClassElem)elem;
                return new ImmutableTypeEncodedValue(e.getDesc());
            }
            case '[': {
                AnnotationArrayElem e = (AnnotationArrayElem)elem;
                ArrayList<EncodedValue> values = new ArrayList<EncodedValue>();
                for (int i = 0; i < e.getNumValues(); ++i) {
                    values.add(this.buildEncodedValueForAnnotation(e.getValueAt(i)));
                }
                return new ImmutableArrayEncodedValue(values);
            }
            case '@': {
                AnnotationAnnotationElem e = (AnnotationAnnotationElem)elem;
                ArrayList<ImmutableAnnotationElement> elements = null;
                Collection<AnnotationElem> elems = e.getValue().getElems();
                if (!elems.isEmpty()) {
                    elements = new ArrayList<ImmutableAnnotationElement>();
                    HashSet<String> alreadyWritten = new HashSet<String>();
                    for (AnnotationElem ae : elems) {
                        if (!alreadyWritten.add(ae.getName())) {
                            throw new DexPrinterException("Duplicate annotation attribute: " + ae.getName());
                        }
                        elements.add(new ImmutableAnnotationElement(ae.getName(), this.buildEncodedValueForAnnotation(ae)));
                    }
                }
                return new ImmutableAnnotationEncodedValue(SootToDexUtils.getDexClassName(e.getValue().getType()), elements);
            }
            case 'f': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                String fSig = e.getValue();
                String[] sp = fSig.split(" ");
                String classString = SootToDexUtils.getDexClassName(sp[0].split(":")[0]);
                if (classString.isEmpty()) {
                    throw new DexPrinterException("Empty class name in annotation");
                }
                String typeString = sp[1];
                if (typeString.isEmpty()) {
                    throw new DexPrinterException("Empty type string in annotation");
                }
                String fieldName = sp[2];
                return new ImmutableFieldEncodedValue(new ImmutableFieldReference(classString, fieldName, typeString));
            }
            case 'M': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                String[] sp = e.getValue().split(" ");
                String classString = SootToDexUtils.getDexClassName(sp[0].split(":")[0]);
                if (classString.isEmpty()) {
                    throw new DexPrinterException("Empty class name in annotation");
                }
                String returnType = sp[1];
                String[] sp2 = sp[2].split("\\(");
                String methodNameString = sp2[0];
                String parameters = sp2[1].replaceAll("\\)", "");
                List<String> paramTypeList = parameters.isEmpty() ? null : Arrays.asList(parameters.split(","));
                return new ImmutableMethodEncodedValue(new ImmutableMethodReference(classString, methodNameString, paramTypeList, returnType));
            }
            case 'N': {
                return ImmutableNullEncodedValue.INSTANCE;
            }
        }
        throw new DexPrinterException("Unknown Elem Attr Kind: " + elem.getKind());
    }

    protected EncodedValue makeConstantItem(SootField sf, Tag t) {
        if (!(t instanceof ConstantValueTag)) {
            throw new DexPrinterException("error: t not ConstantValueTag.");
        }
        if (t instanceof IntegerConstantValueTag) {
            IntegerConstantValueTag i = (IntegerConstantValueTag)t;
            Type sft = sf.getType();
            if (sft instanceof BooleanType) {
                int v = i.getIntValue();
                switch (v) {
                    case 0: {
                        return ImmutableBooleanEncodedValue.FALSE_VALUE;
                    }
                    case 1: {
                        return ImmutableBooleanEncodedValue.TRUE_VALUE;
                    }
                }
                throw new DexPrinterException("error: boolean value from int with value != 0 or 1.");
            }
            if (sft instanceof CharType) {
                return new ImmutableCharEncodedValue((char)i.getIntValue());
            }
            if (sft instanceof ByteType) {
                return new ImmutableByteEncodedValue((byte)i.getIntValue());
            }
            if (sft instanceof IntType) {
                return new ImmutableIntEncodedValue(i.getIntValue());
            }
            if (sft instanceof ShortType) {
                return new ImmutableShortEncodedValue((short)i.getIntValue());
            }
            throw new DexPrinterException("error: unexpected constant tag type: " + t + " for field " + sf);
        }
        if (t instanceof LongConstantValueTag) {
            LongConstantValueTag l = (LongConstantValueTag)t;
            return new ImmutableLongEncodedValue(l.getLongValue());
        }
        if (t instanceof DoubleConstantValueTag) {
            DoubleConstantValueTag d = (DoubleConstantValueTag)t;
            return new ImmutableDoubleEncodedValue(d.getDoubleValue());
        }
        if (t instanceof FloatConstantValueTag) {
            FloatConstantValueTag f = (FloatConstantValueTag)t;
            return new ImmutableFloatEncodedValue(f.getFloatValue());
        }
        if (t instanceof StringConstantValueTag) {
            StringConstantValueTag s = (StringConstantValueTag)t;
            if (sf.getType().equals(RefType.v("java.lang.String"))) {
                return new ImmutableStringEncodedValue(s.getStringValue());
            }
            return null;
        }
        throw new DexPrinterException("Unexpected constant type");
    }

    private void addAsClassDefItem(SootClass c) {
        SourceFileTag sft = (SourceFileTag)c.getTag("SourceFileTag");
        String sourceFile = sft == null ? null : sft.getSourceFile();
        String classType = SootToDexUtils.getDexTypeDescriptor(c.getType());
        int accessFlags = c.getModifiers();
        String superClass = c.hasSuperclass() ? SootToDexUtils.getDexTypeDescriptor(c.getSuperclass().getType()) : null;
        ArrayList<String> interfaces = null;
        if (!c.getInterfaces().isEmpty()) {
            interfaces = new ArrayList<String>();
            for (SootClass sootClass : c.getInterfaces()) {
                interfaces.add(SootToDexUtils.getDexTypeDescriptor(sootClass.getType()));
            }
        }
        ArrayList<ImmutableField> fields = null;
        if (!c.getFields().isEmpty()) {
            fields = new ArrayList<ImmutableField>();
            for (SootField f : c.getFields()) {
                if (this.isIgnored(f)) continue;
                BuilderEncodedValues.BuilderEncodedValue staticInit = null;
                for (Tag t : f.getTags()) {
                    if (!(t instanceof ConstantValueTag)) continue;
                    if (staticInit != null) {
                        LOGGER.warn("More than one constant tag for field \"{}\": \"{}\"", (Object)f, (Object)t);
                        continue;
                    }
                    staticInit = this.makeConstantItem(f, t);
                }
                if (staticInit == null) {
                    staticInit = BuilderEncodedValues.defaultValueForType((String)SootToDexUtils.getDexTypeDescriptor(f.getType()));
                }
                Set<Annotation> fieldAnnotations = this.buildFieldAnnotations(f);
                ImmutableField field = new ImmutableField(classType, f.getName(), SootToDexUtils.getDexTypeDescriptor(f.getType()), f.getModifiers(), (EncodedValue)staticInit, fieldAnnotations, null);
                fields.add(field);
            }
        }
        Collection<Method> collection = this.toMethods(c);
        ImmutableClassDef classDef = new ImmutableClassDef(classType, accessFlags, superClass, interfaces, sourceFile, this.buildClassAnnotations(c), fields, collection);
        this.dexBuilder.internClass((ClassDef)classDef);
    }

    private Set<Annotation> buildClassAnnotations(SootClass c) {
        List<Annotation> list;
        Object icTag;
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(c, skipList);
        EnclosingMethodTag eMethTag = (EnclosingMethodTag)c.getTag("EnclosingMethodTag");
        if (eMethTag != null) {
            Annotation enclosingMethodItem = this.buildEnclosingMethodTag(eMethTag, skipList);
            if (enclosingMethodItem != null) {
                annotations.add(enclosingMethodItem);
            }
        } else if (c.hasOuterClass() && skipList.add("Ldalvik/annotation/EnclosingClass;")) {
            ImmutableAnnotationElement enclosingElement = new ImmutableAnnotationElement("value", (ImmutableEncodedValue)new ImmutableTypeEncodedValue(SootToDexUtils.getDexClassName(c.getOuterClass().getName())));
            annotations.add((Annotation)new ImmutableAnnotation(2, "Ldalvik/annotation/EnclosingClass;", Collections.singleton(enclosingElement)));
        }
        if (c.hasOuterClass() && (icTag = (InnerClassAttribute)c.getOuterClass().getTag("InnerClassAttribute")) != null && (list = this.buildInnerClassAttribute(c, (InnerClassAttribute)icTag, skipList)) != null) {
            annotations.addAll(list);
        }
        this.writeMemberClasses(c, skipList, annotations);
        for (Tag tag : c.getTags()) {
            if (!"VisibilityAnnotationTag".equals(tag.getName())) continue;
            annotations.addAll(this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)tag, skipList));
        }
        ArrayList<AnnotationElem> defaults = new ArrayList<AnnotationElem>();
        for (SootMethod method : c.getMethods()) {
            AnnotationDefaultTag tag = (AnnotationDefaultTag)method.getTag("AnnotationDefaultTag");
            if (tag == null) continue;
            tag.getDefaultVal().setName(method.getName());
            defaults.add(tag.getDefaultVal());
        }
        if (!defaults.isEmpty()) {
            VisibilityAnnotationTag visibilityAnnotationTag = new VisibilityAnnotationTag(1);
            AnnotationTag a = new AnnotationTag("Ldalvik/annotation/AnnotationDefault;");
            visibilityAnnotationTag.addAnnotation(a);
            AnnotationTag at = new AnnotationTag(SootToDexUtils.getDexClassName(c.getName()));
            AnnotationAnnotationElem ae = new AnnotationAnnotationElem(at, '@', "value");
            a.addElem(ae);
            for (AnnotationElem aelem : defaults) {
                at.addElem(aelem);
            }
            annotations.addAll(this.buildVisibilityAnnotationTag(visibilityAnnotationTag, skipList));
        }
        return annotations;
    }

    protected void writeMemberClasses(SootClass c, Set<String> skipList, Set<Annotation> annotations) {
        List<Annotation> memberClassesItem;
        InnerClassAttribute icTag = (InnerClassAttribute)c.getTag("InnerClassAttribute");
        if (icTag != null && (memberClassesItem = this.buildMemberClassesAttribute(c, icTag, skipList)) != null) {
            annotations.addAll(memberClassesItem);
        }
    }

    private Set<Annotation> buildFieldAnnotations(SootField f) {
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(f, skipList);
        for (Tag t : f.getTags()) {
            if (!"VisibilityAnnotationTag".equals(t.getName())) continue;
            annotations.addAll(this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)t, skipList));
        }
        return annotations;
    }

    private Set<Annotation> buildMethodAnnotations(SootMethod m) {
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(m, skipList);
        for (Tag t : m.getTags()) {
            if (!"VisibilityAnnotationTag".equals(t.getName())) continue;
            annotations.addAll(this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)t, skipList));
        }
        List<SootClass> exceptionList = m.getExceptionsUnsafe();
        if (exceptionList != null && !exceptionList.isEmpty()) {
            ArrayList<ImmutableTypeEncodedValue> valueList = new ArrayList<ImmutableTypeEncodedValue>(exceptionList.size());
            for (SootClass exceptionClass : exceptionList) {
                valueList.add(new ImmutableTypeEncodedValue(DexType.toDalvikICAT(exceptionClass.getName()).replace(".", "/")));
            }
            ImmutableArrayEncodedValue valueValue = new ImmutableArrayEncodedValue(valueList);
            ImmutableAnnotationElement valueElement = new ImmutableAnnotationElement("value", (ImmutableEncodedValue)valueValue);
            Set<ImmutableAnnotationElement> elements = Collections.singleton(valueElement);
            ImmutableAnnotation ann = new ImmutableAnnotation(2, "Ldalvik/annotation/Throws;", elements);
            annotations.add((Annotation)ann);
        }
        return annotations;
    }

    private Set<Annotation> buildMethodParameterAnnotations(SootMethod m, int paramIdx) {
        HashSet<String> skipList = null;
        HashSet<ImmutableAnnotation> annotations = null;
        for (Tag t : m.getTags()) {
            if (!"VisibilityParameterAnnotationTag".equals(t.getName())) continue;
            VisibilityParameterAnnotationTag vat = (VisibilityParameterAnnotationTag)t;
            if (skipList == null) {
                skipList = new HashSet<String>();
                annotations = new HashSet<ImmutableAnnotation>();
            }
            annotations.addAll(this.buildVisibilityParameterAnnotationTag(vat, skipList, paramIdx));
        }
        return annotations;
    }

    private Set<Annotation> buildCommonAnnotations(AbstractHost host, Set<String> skipList) {
        SignatureTag tag;
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        if (host.hasTag("DeprecatedTag") && !skipList.contains("Ljava/lang/Deprecated;")) {
            ImmutableAnnotation ann = new ImmutableAnnotation(1, "Ljava/lang/Deprecated;", Collections.emptySet());
            annotations.add((Annotation)ann);
            skipList.add("Ljava/lang/Deprecated;");
        }
        if (!skipList.contains("Ldalvik/annotation/Signature;") && (tag = (SignatureTag)host.getTag("SignatureTag")) != null) {
            List<String> splitSignature = SootToDexUtils.splitSignature(tag.getSignature());
            Set<ImmutableAnnotationElement> elements = null;
            if (splitSignature != null && splitSignature.size() > 0) {
                ArrayList<ImmutableStringEncodedValue> valueList = new ArrayList<ImmutableStringEncodedValue>();
                for (String s : splitSignature) {
                    valueList.add(new ImmutableStringEncodedValue(s));
                }
                ImmutableArrayEncodedValue valueValue = new ImmutableArrayEncodedValue(valueList);
                ImmutableAnnotationElement valueElement = new ImmutableAnnotationElement("value", (ImmutableEncodedValue)valueValue);
                elements = Collections.singleton(valueElement);
            } else {
                LOGGER.info("Signature annotation without value detected");
            }
            annotations.add((Annotation)new ImmutableAnnotation(2, "Ldalvik/annotation/Signature;", elements));
            skipList.add("Ldalvik/annotation/Signature;");
        }
        return annotations;
    }

    private List<ImmutableAnnotation> buildVisibilityAnnotationTag(VisibilityAnnotationTag t, Set<String> skipList) {
        if (t.getAnnotations() == null) {
            return Collections.emptyList();
        }
        ArrayList<ImmutableAnnotation> annotations = new ArrayList<ImmutableAnnotation>();
        for (AnnotationTag at : t.getAnnotations()) {
            String type = at.getType();
            if (!skipList.add(type)) continue;
            ArrayList<ImmutableAnnotationElement> elements = null;
            Collection<AnnotationElem> elems = at.getElems();
            if (!elems.isEmpty()) {
                elements = new ArrayList<ImmutableAnnotationElement>();
                HashSet<String> alreadyWritten = new HashSet<String>();
                for (AnnotationElem ae : elems) {
                    if (ae.getName() == null || ae.getName().isEmpty()) {
                        throw new DexPrinterException("Null or empty annotation name encountered");
                    }
                    if (!alreadyWritten.add(ae.getName())) {
                        throw new DexPrinterException("Duplicate annotation attribute: " + ae.getName());
                    }
                    EncodedValue value = this.buildEncodedValueForAnnotation(ae);
                    ImmutableAnnotationElement element = new ImmutableAnnotationElement(ae.getName(), value);
                    elements.add(element);
                }
            }
            String typeName = SootToDexUtils.getDexClassName(at.getType());
            annotations.add(new ImmutableAnnotation(DexPrinter.getVisibility(t.getVisibility()), typeName, elements));
        }
        return annotations;
    }

    private List<ImmutableAnnotation> buildVisibilityParameterAnnotationTag(VisibilityParameterAnnotationTag t, Set<String> skipList, int paramIdx) {
        if (t.getVisibilityAnnotations() == null) {
            return Collections.emptyList();
        }
        int paramTagIdx = 0;
        ArrayList<ImmutableAnnotation> annotations = new ArrayList<ImmutableAnnotation>();
        for (VisibilityAnnotationTag vat : t.getVisibilityAnnotations()) {
            if (paramTagIdx == paramIdx && vat != null && vat.getAnnotations() != null) {
                for (AnnotationTag at : vat.getAnnotations()) {
                    String type = at.getType();
                    if (!skipList.add(type)) continue;
                    ArrayList<ImmutableAnnotationElement> elements = null;
                    Collection<AnnotationElem> elems = at.getElems();
                    if (!elems.isEmpty()) {
                        elements = new ArrayList<ImmutableAnnotationElement>();
                        HashSet<String> alreadyWritten = new HashSet<String>();
                        for (AnnotationElem ae : elems) {
                            if (ae.getName() == null || ae.getName().isEmpty()) {
                                throw new DexPrinterException("Null or empty annotation name encountered");
                            }
                            if (!alreadyWritten.add(ae.getName())) {
                                throw new DexPrinterException("Duplicate annotation attribute: " + ae.getName());
                            }
                            EncodedValue value = this.buildEncodedValueForAnnotation(ae);
                            elements.add(new ImmutableAnnotationElement(ae.getName(), value));
                        }
                    }
                    ImmutableAnnotation ann = new ImmutableAnnotation(DexPrinter.getVisibility(vat.getVisibility()), SootToDexUtils.getDexClassName(at.getType()), elements);
                    annotations.add(ann);
                }
            }
            ++paramTagIdx;
        }
        return annotations;
    }

    private Annotation buildEnclosingMethodTag(EnclosingMethodTag t, Set<String> skipList) {
        if (!skipList.add("Ldalvik/annotation/EnclosingMethod;") || t.getEnclosingMethod() == null) {
            return null;
        }
        String[] split1 = t.getEnclosingMethodSig().split("\\)");
        String parametersS = split1[0].replaceAll("\\(", "");
        String returnTypeS = split1[1];
        ArrayList<String> typeList = new ArrayList<String>();
        if (!parametersS.isEmpty()) {
            for (String p : Util.splitParameters(parametersS)) {
                if (p.isEmpty()) continue;
                typeList.add(p);
            }
        }
        ImmutableMethodReference mRef = new ImmutableMethodReference(SootToDexUtils.getDexClassName(t.getEnclosingClass()), t.getEnclosingMethod(), typeList, returnTypeS);
        ImmutableMethodEncodedValue methodRef = new ImmutableMethodEncodedValue(mRef);
        ImmutableAnnotationElement methodElement = new ImmutableAnnotationElement("value", (ImmutableEncodedValue)methodRef);
        return new ImmutableAnnotation(2, "Ldalvik/annotation/EnclosingMethod;", Collections.singleton(methodElement));
    }

    private List<Annotation> buildInnerClassAttribute(SootClass parentClass, InnerClassAttribute t, Set<String> skipList) {
        if (t.getSpecs() == null) {
            return null;
        }
        ArrayList<ImmutableAnnotation> anns = null;
        for (Tag tag : t.getSpecs()) {
            InnerClassTag icTag = (InnerClassTag)tag;
            String outerClass = DexInnerClassParser.getOuterClassNameFromTag(icTag);
            String innerClass = icTag.getInnerClass().replace('/', '.');
            if (!parentClass.hasOuterClass() || !innerClass.equals(parentClass.getName())) continue;
            if (parentClass.getName().equals(outerClass) && icTag.getOuterClass() == null) {
                outerClass = null;
            }
            if (parentClass.getName().equals(outerClass) || !skipList.add("Ldalvik/annotation/InnerClass;")) continue;
            ArrayList<ImmutableAnnotationElement> elements = new ArrayList<ImmutableAnnotationElement>();
            ImmutableAnnotationElement flagsElement = new ImmutableAnnotationElement("accessFlags", (ImmutableEncodedValue)new ImmutableIntEncodedValue(icTag.getAccessFlags()));
            elements.add(flagsElement);
            Object nameValue = icTag.getShortName() != null && !icTag.getShortName().isEmpty() ? new ImmutableStringEncodedValue(icTag.getShortName()) : ImmutableNullEncodedValue.INSTANCE;
            elements.add(new ImmutableAnnotationElement("name", (ImmutableEncodedValue)nameValue));
            if (anns == null) {
                anns = new ArrayList<ImmutableAnnotation>();
            }
            anns.add(new ImmutableAnnotation(2, "Ldalvik/annotation/InnerClass;", elements));
        }
        return anns;
    }

    private List<Annotation> buildMemberClassesAttribute(SootClass parentClass, InnerClassAttribute t, Set<String> skipList) {
        ArrayList<ImmutableAnnotation> anns = null;
        HashSet<String> memberClasses = null;
        for (Tag tag : t.getSpecs()) {
            InnerClassTag icTag = (InnerClassTag)tag;
            String outerClass = DexInnerClassParser.getOuterClassNameFromTag(icTag);
            if (icTag.getOuterClass() == null || !parentClass.getName().equals(outerClass)) continue;
            if (memberClasses == null) {
                memberClasses = new HashSet<String>();
            }
            memberClasses.add(SootToDexUtils.getDexClassName(icTag.getInnerClass()));
        }
        if (memberClasses != null && !memberClasses.isEmpty() && skipList.add("Ldalvik/annotation/MemberClasses;")) {
            ArrayList<ImmutableTypeEncodedValue> classes = new ArrayList<ImmutableTypeEncodedValue>();
            for (String memberClass : memberClasses) {
                classes.add(new ImmutableTypeEncodedValue(memberClass));
            }
            ImmutableArrayEncodedValue immutableArrayEncodedValue = new ImmutableArrayEncodedValue(classes);
            ImmutableAnnotationElement element = new ImmutableAnnotationElement("value", (ImmutableEncodedValue)immutableArrayEncodedValue);
            ImmutableAnnotation memberAnnotation = new ImmutableAnnotation(2, "Ldalvik/annotation/MemberClasses;", Collections.singletonList(element));
            if (anns == null) {
                anns = new ArrayList<ImmutableAnnotation>();
            }
            anns.add(memberAnnotation);
        }
        return anns;
    }

    protected Collection<Method> toMethods(SootClass clazz) {
        if (clazz.getMethods().isEmpty()) {
            return null;
        }
        String classType = SootToDexUtils.getDexTypeDescriptor(clazz.getType());
        ArrayList<Method> methods = new ArrayList<Method>();
        for (SootMethod sm : clazz.getMethods()) {
            MethodImplementation impl;
            if (this.isIgnored(sm)) continue;
            try {
                impl = this.toMethodImplementation(sm);
            }
            catch (Exception e) {
                throw new DexPrinterException("Error while processing method " + sm, e);
            }
            ParamNamesTag pnt = (ParamNamesTag)sm.getTag("ParamNamesTag");
            List<String> parameterNames = pnt == null ? null : pnt.getNames();
            int paramIdx = 0;
            ArrayList<ImmutableMethodParameter> parameters = null;
            if (sm.getParameterCount() > 0) {
                parameters = new ArrayList<ImmutableMethodParameter>();
                for (Type tp : sm.getParameterTypes()) {
                    String paramType = SootToDexUtils.getDexTypeDescriptor(tp);
                    parameters.add(new ImmutableMethodParameter(paramType, this.buildMethodParameterAnnotations(sm, paramIdx), sm.isConcrete() && parameterNames != null ? parameterNames.get(paramIdx) : null));
                    ++paramIdx;
                }
            }
            String returnType = SootToDexUtils.getDexTypeDescriptor(sm.getReturnType());
            ImmutableMethod meth = new ImmutableMethod(classType, sm.getName(), parameters, returnType, SootToDexUtils.getDexAccessFlags(sm), this.buildMethodAnnotations(sm), null, impl);
            methods.add((Method)meth);
        }
        return methods;
    }

    protected boolean isIgnored(SootMethod sm) {
        return sm.isPhantom();
    }

    protected boolean isIgnored(SootField sf) {
        return sf.isPhantom();
    }

    protected MethodImplementation toMethodImplementation(SootMethod m) {
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        Body activeBody = m.retrieveActiveBody();
        String mName = m.getName();
        if (mName.isEmpty()) {
            throw new DexPrinterException("Invalid empty method name: " + m.getSignature());
        }
        if (!(mName.indexOf(60) < 0 && mName.indexOf(62) < 0 || "<init>".equals(mName) || "<clinit>".equals(mName))) {
            throw new DexPrinterException("Invalid method name: " + m.getSignature());
        }
        EmptySwitchEliminator.v().transform(activeBody);
        SynchronizedMethodTransformer.v().transform(activeBody);
        FastDexTrapTightener.v().transform(activeBody);
        DexArrayInitDetector initDetector = new DexArrayInitDetector();
        initDetector.constructArrayInitializations(activeBody);
        initDetector.fixTraps(activeBody);
        TrapSplitter.v().transform(activeBody);
        int inWords = SootToDexUtils.getDexWords(m.getParameterTypes());
        if (!m.isStatic()) {
            ++inWords;
        }
        UnitPatchingChain units = activeBody.getUnits();
        StmtVisitor stmtV = this.buildStmtVisitor(m, initDetector);
        Chain<Trap> traps = activeBody.getTraps();
        HashSet<Unit> trapReferences = new HashSet<Unit>(traps.size() * 3);
        for (Trap t : traps) {
            trapReferences.add(t.getBeginUnit());
            trapReferences.add(t.getEndUnit());
            trapReferences.add(t.getHandlerUnit());
        }
        this.toInstructions(units, stmtV, trapReferences);
        int registerCount = stmtV.getRegisterCount();
        if (inWords > registerCount) {
            registerCount = inWords;
        }
        MethodImplementationBuilder builder = new MethodImplementationBuilder(registerCount);
        LabelAssigner labelAssigner = new LabelAssigner(builder);
        List<BuilderInstruction> instructions = stmtV.getRealInsns(labelAssigner);
        HashMap<Local, Integer> seenRegisters = new HashMap<Local, Integer>();
        Map<Instruction, LocalRegisterAssignmentInformation> instructionRegisterMap = stmtV.getInstructionRegisterMap();
        if (Options.v().write_local_annotations()) {
            for (LocalRegisterAssignmentInformation assignment : stmtV.getParameterInstructionsList()) {
                if ("this".equals(assignment.getLocal().getName())) continue;
                this.addRegisterAssignmentDebugInfo(assignment, seenRegisters, builder);
            }
        }
        this.fixLongJumps(instructions, labelAssigner, stmtV);
        for (BuilderInstruction ins : instructions) {
            Stmt origStmt = stmtV.getStmtForInstruction((Instruction)ins);
            if (stmtV.getInstructionPayloadMap().containsKey(ins)) {
                builder.addLabel(labelAssigner.getLabelName(stmtV.getInstructionPayloadMap().get(ins)));
            }
            if (origStmt != null) {
                String labelName;
                if (trapReferences.contains(origStmt)) {
                    labelAssigner.getOrCreateLabel(origStmt);
                }
                if ((labelName = labelAssigner.getLabelName(origStmt)) != null && !builder.getLabel(labelName).isPlaced()) {
                    builder.addLabel(labelName);
                }
                if (stmtV.getStmtForInstruction((Instruction)ins) != null) {
                    this.writeTagsForStatement(builder, origStmt);
                }
            }
            builder.addInstruction(ins);
            LocalRegisterAssignmentInformation registerAssignmentTag = instructionRegisterMap.get(ins);
            if (registerAssignmentTag == null) continue;
            this.addRegisterAssignmentDebugInfo(registerAssignmentTag, seenRegisters, builder);
        }
        Iterator<LocalRegisterAssignmentInformation> iterator = seenRegisters.values().iterator();
        while (iterator.hasNext()) {
            int registersLeft = (Integer)((Object)iterator.next());
            builder.addEndLocal(registersLeft);
        }
        this.toTries(activeBody.getTraps(), builder, labelAssigner);
        for (Label lbl : labelAssigner.getAllLabels()) {
            if (lbl.isPlaced()) continue;
            throw new DexPrinterException("Label not placed: " + lbl);
        }
        return builder.getMethodImplementation();
    }

    protected StmtVisitor buildStmtVisitor(SootMethod belongingMethod, DexArrayInitDetector arrayInitDetector) {
        return new StmtVisitor(belongingMethod, arrayInitDetector);
    }

    protected void writeTagsForStatement(MethodImplementationBuilder builder, Stmt stmt) {
        for (Tag t : stmt.getTags()) {
            if (t instanceof LineNumberTag) {
                LineNumberTag lnt = (LineNumberTag)t;
                builder.addLineNumber(lnt.getLineNumber());
                continue;
            }
            if (!(t instanceof SourceFileTag)) continue;
            SourceFileTag sft = (SourceFileTag)t;
            builder.addSetSourceFile((StringReference)new ImmutableStringReference(sft.getSourceFile()));
        }
    }

    private void fixLongJumps(List<BuilderInstruction> instructions, LabelAssigner labelAssigner, StmtVisitor stmtV) {
        boolean hasChanged;
        HashMap<BuilderInstruction, Integer> instructionsToIndex = new HashMap<BuilderInstruction, Integer>();
        ArrayList<Integer> instructionsToOffsets = new ArrayList<Integer>();
        HashMap<Label, Integer> labelsToOffsets = new HashMap<Label, Integer>();
        HashMap<Label, Integer> labelsToIndex = new HashMap<Label, Integer>();
        block0: do {
            hasChanged = false;
            instructionsToOffsets.clear();
            int offset = 0;
            int idx = 0;
            for (BuilderInstruction bi : instructions) {
                Label lbl;
                instructionsToIndex.put(bi, idx);
                instructionsToOffsets.add(offset);
                Stmt origStmt = stmtV.getStmtForInstruction((Instruction)bi);
                if (origStmt != null && (lbl = labelAssigner.getLabelUnsafe(origStmt)) != null) {
                    labelsToOffsets.put(lbl, offset);
                    labelsToIndex.put(lbl, idx);
                }
                offset += bi.getFormat().size / 2;
                ++idx;
            }
            for (int j = 0; j < instructions.size(); ++j) {
                Integer targetIndex;
                BuilderOffsetInstruction boj;
                Insn jumpInsn;
                BuilderInstruction bj = instructions.get(j);
                if (!(bj instanceof BuilderOffsetInstruction) || !((jumpInsn = stmtV.getInsnForInstruction((Instruction)(boj = (BuilderOffsetInstruction)bj))) instanceof InsnWithOffset)) continue;
                InsnWithOffset offsetInsn = (InsnWithOffset)jumpInsn;
                Integer targetOffset = (Integer)labelsToOffsets.get(boj.getTarget());
                if (targetOffset == null) continue;
                int distance = Math.abs(targetOffset - (Integer)instructionsToOffsets.get(j));
                if (distance <= offsetInsn.getMaxJumpOffset() && (targetIndex = (Integer)labelsToIndex.get(boj.getTarget())) != null) {
                    int start = Math.min(targetIndex, j);
                    int end = Math.max(targetIndex, j);
                    int theoreticalMaximumIncrease = (end - start) * 2;
                    if (distance + theoreticalMaximumIncrease > offsetInsn.getMaxJumpOffset()) {
                        int countConstString = 0;
                        for (int z = start; z <= end; ++z) {
                            if (instructions.get(z).getOpcode() != Opcode.CONST_STRING) continue;
                            ++countConstString;
                        }
                        int maxOffsetChange = countConstString * 2;
                        distance += maxOffsetChange;
                    }
                }
                if (distance <= offsetInsn.getMaxJumpOffset()) continue;
                this.insertIntermediateJump((Integer)labelsToIndex.get(boj.getTarget()), j, stmtV, instructions, labelAssigner);
                hasChanged = true;
                continue block0;
            }
        } while (hasChanged);
    }

    private void insertIntermediateJump(int targetInsPos, int jumpInsPos, StmtVisitor stmtV, List<BuilderInstruction> instructions, LabelAssigner labelAssigner) {
        int newJumpIdx;
        InsnWithOffset offsetInsn;
        Insn originalJumpInsn;
        BuilderInstruction originalJumpInstruction;
        block8: {
            originalJumpInstruction = instructions.get(jumpInsPos);
            originalJumpInsn = stmtV.getInsnForInstruction((Instruction)originalJumpInstruction);
            if (originalJumpInsn == null) {
                return;
            }
            if (!(originalJumpInsn instanceof InsnWithOffset)) {
                throw new DexPrinterException("Unexpected jump instruction target");
            }
            offsetInsn = (InsnWithOffset)originalJumpInsn;
            if (originalJumpInsn instanceof Insn10t && originalJumpInsn.getOpcode() == Opcode.GOTO) {
                Insn30t newJump = new Insn30t(Opcode.GOTO_32);
                newJump.setTarget(((Insn10t)originalJumpInsn).getTarget());
                BuilderInstruction newJumpInstruction = newJump.getRealInsn(labelAssigner);
                instructions.remove(jumpInsPos);
                instructions.add(jumpInsPos, newJumpInstruction);
                stmtV.fakeNewInsn(stmtV.getStmtForInstruction((Instruction)originalJumpInstruction), newJump, (Instruction)newJumpInstruction);
                return;
            }
            int distance = Math.max(targetInsPos, jumpInsPos) - Math.min(targetInsPos, jumpInsPos);
            if (distance == 0) {
                return;
            }
            newJumpIdx = Math.min(targetInsPos, jumpInsPos) + distance / 2;
            int sign = (int)Math.signum(targetInsPos - jumpInsPos);
            do {
                Stmt prevStmt;
                Stmt newStmt = stmtV.getStmtForInstruction((Instruction)instructions.get(newJumpIdx));
                Stmt stmt = prevStmt = newJumpIdx > 0 ? stmtV.getStmtForInstruction((Instruction)instructions.get(newJumpIdx - 1)) : null;
                if (newStmt != null && newStmt != prevStmt) break block8;
            } while ((newJumpIdx -= sign) >= 0 && newJumpIdx < instructions.size());
            throw new DexPrinterException("No position for inserting intermediate jump instruction found");
        }
        NopStmt nop = Jimple.v().newNopStmt();
        Insn30t newJump = new Insn30t(Opcode.GOTO_32);
        newJump.setTarget(stmtV.getStmtForInstruction((Instruction)instructions.get(targetInsPos)));
        BuilderInstruction newJumpInstruction = newJump.getRealInsn(labelAssigner);
        instructions.add(newJumpIdx, newJumpInstruction);
        stmtV.fakeNewInsn(nop, newJump, (Instruction)newJumpInstruction);
        if (newJumpIdx <= jumpInsPos) {
            ++jumpInsPos;
        }
        if (newJumpIdx <= targetInsPos) {
            ++targetInsPos;
        }
        offsetInsn.setTarget(nop);
        BuilderInstruction replacementJumpInstruction = offsetInsn.getRealInsn(labelAssigner);
        assert (instructions.get(jumpInsPos) == originalJumpInstruction);
        instructions.remove(jumpInsPos);
        instructions.add(jumpInsPos, replacementJumpInstruction);
        stmtV.fakeNewInsn(stmtV.getStmtForInstruction((Instruction)originalJumpInstruction), originalJumpInsn, (Instruction)replacementJumpInstruction);
        Stmt afterNewJump = stmtV.getStmtForInstruction((Instruction)instructions.get(newJumpIdx + 1));
        Insn10t jumpAround = new Insn10t(Opcode.GOTO);
        jumpAround.setTarget(afterNewJump);
        BuilderInstruction jumpAroundInstruction = jumpAround.getRealInsn(labelAssigner);
        instructions.add(newJumpIdx, jumpAroundInstruction);
        stmtV.fakeNewInsn(Jimple.v().newNopStmt(), jumpAround, (Instruction)jumpAroundInstruction);
    }

    private void addRegisterAssignmentDebugInfo(LocalRegisterAssignmentInformation registerAssignment, Map<Local, Integer> seenRegisters, MethodImplementationBuilder builder) {
        Local local = registerAssignment.getLocal();
        String dexLocalType = SootToDexUtils.getDexTypeDescriptor(local.getType());
        ImmutableStringReference localName = new ImmutableStringReference(local.getName());
        Register reg = registerAssignment.getRegister();
        int register = reg.getNumber();
        Integer beforeRegister = seenRegisters.get(local);
        if (beforeRegister != null) {
            if (beforeRegister == register) {
                return;
            }
            builder.addEndLocal(beforeRegister.intValue());
        }
        builder.addStartLocal(register, (StringReference)localName, (TypeReference)new ImmutableTypeReference(dexLocalType), (StringReference)new ImmutableStringReference(""));
        seenRegisters.put(local, register);
    }

    protected void toInstructions(Collection<Unit> units, StmtVisitor stmtV, Set<Unit> trapReferences) {
        HashSet<ClassConstant> monitorConsts = new HashSet<ClassConstant>();
        for (Unit u : units) {
            MonitorStmt monitorStmt;
            if (!(u instanceof MonitorStmt) || !((monitorStmt = (MonitorStmt)u).getOp() instanceof ClassConstant)) continue;
            monitorConsts.add((ClassConstant)monitorStmt.getOp());
        }
        boolean monitorAllocsMade = false;
        for (Unit u : units) {
            if (!(monitorAllocsMade || monitorConsts.isEmpty() || u instanceof IdentityStmt)) {
                stmtV.preAllocateMonitorConsts(monitorConsts);
                monitorAllocsMade = true;
            }
            stmtV.beginNewStmt((Stmt)u);
            u.apply(stmtV);
        }
        stmtV.finalizeInstructions(trapReferences);
    }

    protected void toTries(Collection<Trap> traps, MethodImplementationBuilder builder, LabelAssigner labelAssigner) {
        LinkedHashMap codeRangesToTryItem = new LinkedHashMap();
        for (Trap t : traps) {
            Stmt beginStmt = (Stmt)t.getBeginUnit();
            Stmt endStmt = (Stmt)t.getEndUnit();
            int startCodeAddress = labelAssigner.getLabel(beginStmt).getCodeAddress();
            int endCodeAddress = labelAssigner.getLabel(endStmt).getCodeAddress();
            CodeRange range = new CodeRange(startCodeAddress, endCodeAddress);
            String exceptionType = SootToDexUtils.getDexTypeDescriptor(t.getException().getType());
            int codeAddress = labelAssigner.getLabel((Stmt)t.getHandlerUnit()).getCodeAddress();
            ImmutableExceptionHandler exceptionHandler = new ImmutableExceptionHandler(exceptionType, codeAddress);
            ArrayList<ImmutableExceptionHandler> newHandlers = new ArrayList<ImmutableExceptionHandler>();
            for (CodeRange r : codeRangesToTryItem.keySet()) {
                List oldHandlers;
                if (r.containsRange(range)) {
                    range.startAddress = r.startAddress;
                    range.endAddress = r.endAddress;
                    oldHandlers = (List)codeRangesToTryItem.get(r);
                    if (oldHandlers == null) break;
                    newHandlers.addAll(oldHandlers);
                    break;
                }
                if (!range.containsRange(r)) continue;
                range.startAddress = r.startAddress;
                range.endAddress = r.endAddress;
                oldHandlers = (List)codeRangesToTryItem.get(range);
                if (oldHandlers != null) {
                    newHandlers.addAll(oldHandlers);
                }
                codeRangesToTryItem.remove(r);
                break;
            }
            if (!newHandlers.contains(exceptionHandler)) {
                newHandlers.add(exceptionHandler);
            }
            codeRangesToTryItem.put(range, newHandlers);
        }
        for (CodeRange r1 : codeRangesToTryItem.keySet()) {
            for (CodeRange r2 : codeRangesToTryItem.keySet()) {
                if (r1 == r2 || !r1.overlaps(r2)) continue;
                LOGGER.warn("Trap region overlaps detected");
            }
        }
        for (CodeRange range : codeRangesToTryItem.keySet()) {
            boolean allCaughtForRange = false;
            for (ExceptionHandler handler : (List)codeRangesToTryItem.get(range)) {
                if (allCaughtForRange) continue;
                if ("Ljava/lang/Throwable;".equals(handler.getExceptionType())) {
                    allCaughtForRange = true;
                }
                builder.addCatch((TypeReference)new ImmutableTypeReference(handler.getExceptionType()), labelAssigner.getLabelAtAddress(range.startAddress), labelAssigner.getLabelAtAddress(range.endAddress), labelAssigner.getLabelAtAddress(handler.getHandlerCodeAddress()));
            }
        }
    }

    public void add(SootClass c) {
        if (c.isPhantom()) {
            return;
        }
        this.addAsClassDefItem(c);
        Map<String, File> dexClassIndex = SourceLocator.v().dexClassIndex();
        if (dexClassIndex == null) {
            return;
        }
        File sourceForClass = dexClassIndex.get(c.getName());
        if (sourceForClass == null || sourceForClass.getName().endsWith(".dex")) {
            return;
        }
        if (this.originalApk != null && !this.originalApk.equals(sourceForClass)) {
            throw new CompilationDeathException("multiple APKs as source of an application are not supported");
        }
        this.originalApk = sourceForClass;
    }

    public void print() {
        try {
            if (Options.v().output_jar() || this.originalApk != null && Options.v().output_format() != 11) {
                this.printZip();
            } else {
                String outputDir = SourceLocator.v().getOutputDir();
                LOGGER.info("Writing dex files to \"{}\" folder.", (Object)outputDir);
                this.dexBuilder.writeTo(outputDir);
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("I/O exception while printing dex", e);
        }
    }

    private static class CodeRange {
        int startAddress;
        int endAddress;

        public CodeRange(int startAddress, int endAddress) {
            this.startAddress = startAddress;
            this.endAddress = endAddress;
        }

        public boolean containsRange(CodeRange r) {
            return r.startAddress >= this.startAddress && r.endAddress <= this.endAddress;
        }

        public boolean overlaps(CodeRange r) {
            return r.startAddress >= this.startAddress && r.startAddress < this.endAddress || r.startAddress <= this.startAddress && r.endAddress > this.startAddress;
        }

        public String toString() {
            return this.startAddress + "-" + this.endAddress;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || !(other instanceof CodeRange)) {
                return false;
            }
            CodeRange cr = (CodeRange)other;
            return this.startAddress == cr.startAddress && this.endAddress == cr.endAddress;
        }

        public int hashCode() {
            return 17 * this.startAddress + 13 * this.endAddress;
        }
    }
}

