/*
 * Decompiled with CFR 0.152.
 */
package soot.util.annotations;

import java.lang.reflect.Array;

public class ClassLoaderUtils {
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(className, true);
    }

    public static Class<?> loadClass(String className, boolean allowPrimitives) throws ClassNotFoundException {
        if (allowPrimitives) {
            switch (className) {
                case "B": 
                case "byte": {
                    return Byte.TYPE;
                }
                case "C": 
                case "char": {
                    return Character.TYPE;
                }
                case "D": 
                case "double": {
                    return Double.TYPE;
                }
                case "F": 
                case "float": {
                    return Float.TYPE;
                }
                case "I": 
                case "int": {
                    return Integer.TYPE;
                }
                case "J": 
                case "long": {
                    return Long.TYPE;
                }
                case "S": 
                case "short": {
                    return Short.TYPE;
                }
                case "Z": 
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "V": 
                case "void": {
                    return Void.TYPE;
                }
            }
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            return ClassLoaderUtils.loadClass(className.substring(1, className.length() - 1), false);
        }
        int arrayDimension = 0;
        while (className.charAt(arrayDimension) == '[') {
            ++arrayDimension;
        }
        if (arrayDimension == 0) {
            return Class.forName(className);
        }
        Class<?> baseClass = ClassLoaderUtils.loadClass(className.substring(arrayDimension));
        return Array.newInstance(baseClass, new int[arrayDimension]).getClass();
    }
}

