/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.io.PrintStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.ValueBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum ValueBoxesValidator implements BodyValidator
{
    INSTANCE;


    public static ValueBoxesValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        boolean foundProblem = false;
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (ValueBox vb : body.getUseAndDefBoxes()) {
            if (set.add(vb)) continue;
            foundProblem = true;
            exception.add(new ValidationException(vb, "Aliased value box : " + vb + " in " + body.getMethod()));
        }
        if (foundProblem) {
            PrintStream err = System.err;
            err.println("Found a ValueBox used more than once in body of " + body.getMethod() + ":");
            for (Unit u : body.getUnits()) {
                err.println("\t" + u);
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

