/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.baf.PushInst;
import soot.baf.StoreInst;
import soot.toolkits.scalar.Pair;

public class StoreChainOptimizer
extends BodyTransformer {
    public StoreChainOptimizer(Singletons.Global g) {
    }

    public static StoreChainOptimizer v() {
        return G.v().soot_baf_toolkits_base_StoreChainOptimizer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        HashMap<Local, Pair<Unit, Unit>> stores = new HashMap<Local, Pair<Unit, Unit>>();
        HashSet<Unit> toRemove = new HashSet<Unit>();
        Unit lastPush = null;
        for (Unit u : b.getUnits()) {
            if (!u.getBoxesPointingToThis().isEmpty()) {
                stores.clear();
                lastPush = null;
                continue;
            }
            if (u instanceof PushInst) {
                lastPush = u;
                continue;
            }
            if (u instanceof StoreInst && lastPush != null) {
                StoreInst si = (StoreInst)u;
                Pair pushStorePair = (Pair)stores.get(si.getLocal());
                if (pushStorePair != null) {
                    toRemove.add((Unit)pushStorePair.getO1());
                    toRemove.add((Unit)pushStorePair.getO2());
                }
                stores.put(si.getLocal(), new Pair<Unit, Unit>(lastPush, u));
                continue;
            }
            stores.clear();
            lastPush = null;
        }
        b.getUnits().removeAll(toRemove);
    }
}

