/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import soot.Body;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.members.method.BlockEntryPointsManager;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;

public class CilBlockContainer
implements CilInstruction {
    private final ProtoIlInstructions.IlBlockContainerMsg blockContainer;
    private final DotnetBody dotnetBody;
    public final BlockEntryPointsManager blockEntryPointsManager;
    private final Stmt skipBlockContainerStmt;
    private final BlockContainerKind blockContainerKind;

    public CilBlockContainer(ProtoIlInstructions.IlBlockContainerMsg blockContainer, DotnetBody dotnetBody) {
        this(blockContainer, dotnetBody, BlockContainerKind.NORMAL);
    }

    public CilBlockContainer(ProtoIlInstructions.IlBlockContainerMsg blockContainer, DotnetBody dotnetBody, BlockContainerKind blockContainerKind) {
        this.blockContainer = blockContainer;
        this.dotnetBody = dotnetBody;
        this.blockContainerKind = blockContainerKind;
        this.blockEntryPointsManager = new BlockEntryPointsManager();
        this.skipBlockContainerStmt = Jimple.v().newNopStmt();
    }

    @Override
    public void jimplify(Body jb) {
        if (this.blockContainer == null || this.blockContainer.getBlocksList().size() == 0 || this.blockContainer.getBlocksList().get(0).getListOfIlInstructionsCount() == 0) {
            return;
        }
        for (ProtoIlInstructions.IlBlock block : this.blockContainer.getBlocksList()) {
            CilBlock cilBlock = new CilBlock(block, this.dotnetBody, this);
            cilBlock.jimplify(jb);
        }
        if (this.isChildBlockContainer()) {
            jb.getUnits().add(this.skipBlockContainerStmt);
        }
        this.blockEntryPointsManager.swapGotoEntriesInJBody(jb);
    }

    public Body jimplify() {
        JimpleBody jbTmp = Jimple.v().newBody();
        jbTmp.setMethod(new SootMethod("", new ArrayList<Type>(), RefType.v("")));
        this.jimplify(jbTmp);
        return jbTmp;
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new RuntimeException(this.getClass().getName() + " does not have expressions, but statements!");
    }

    public static boolean LastStmtIsNotReturn(Body jb) {
        if (jb.getUnits().size() == 0) {
            return true;
        }
        return !CilBlockContainer.isExitStmt((Unit)jb.getUnits().getLast());
    }

    static boolean isExitStmt(Unit unit) {
        return unit instanceof ReturnStmt || unit instanceof ReturnVoidStmt || unit instanceof ThrowStmt;
    }

    public DotnetBody getDeclaringDotnetBody() {
        return this.dotnetBody;
    }

    public boolean isChildBlockContainer() {
        return !this.getBlockContainerKind().equals((Object)BlockContainerKind.NORMAL);
    }

    public BlockContainerKind getBlockContainerKind() {
        return this.blockContainerKind;
    }

    public Stmt getSkipBlockContainerStmt() {
        return this.skipBlockContainerStmt;
    }

    public static enum BlockContainerKind {
        NORMAL,
        TRY,
        CATCH_HANDLER,
        CATCH_FILTER,
        FAULT,
        FINALLY,
        CHILD;

    }
}

