/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.List;
import soot.Body;
import soot.Immediate;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.members.method.DotnetBodyVariableManager;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;

public class CilLdElemaInstruction
extends AbstractCilnstruction {
    private boolean isMultiArrayRef = false;
    private final List<Value> indices = new ArrayList<Value>();
    private Value baseArrayLocal;

    public CilLdElemaInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
        if (instruction.getIndicesCount() > 1) {
            this.isMultiArrayRef = true;
        }
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArray(), this.dotnetBody, this.cilBlock);
        this.baseArrayLocal = cilExpr.jimplifyExpr(jb);
        if (this.instruction.getIndicesCount() == 1) {
            Value ind = CilInstructionFactory.fromInstructionMsg(this.instruction.getIndices(0), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
            Value index = ind instanceof Immediate ? ind : DotnetBodyVariableManager.inlineLocals(ind, jb);
            return Jimple.v().newArrayRef(this.baseArrayLocal, index);
        }
        for (ProtoIlInstructions.IlInstructionMsg ind : this.instruction.getIndicesList()) {
            Value indExpr = CilInstructionFactory.fromInstructionMsg(ind, this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
            Value index = indExpr instanceof Immediate ? indExpr : DotnetBodyVariableManager.inlineLocals(indExpr, jb);
            this.indices.add(index);
        }
        return Jimple.v().newArrayRef(this.baseArrayLocal, this.indices.get(0));
    }

    public boolean isMultiArrayRef() {
        return this.isMultiArrayRef;
    }

    public Value getBaseArrayLocal() {
        return this.baseArrayLocal;
    }

    public List<Value> getIndices() {
        return this.indices;
    }

    public Value resolveRewriteMultiArrAccess(Body jb) {
        int size = this.getIndices().size();
        Local rLocalVar = null;
        for (int z = 0; z < size; ++z) {
            ArrayRef arrayRef = z == 0 ? Jimple.v().newArrayRef(this.getBaseArrayLocal(), this.getIndices().get(z)) : Jimple.v().newArrayRef(rLocalVar, this.getIndices().get(z));
            Type arrayType = arrayRef.getType();
            Local lLocalVar = this.dotnetBody.variableManager.localGenerator.generateLocal(arrayType);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(lLocalVar, arrayRef);
            jb.getUnits().add(assignStmt);
            rLocalVar = lLocalVar;
        }
        return rLocalVar;
    }
}

