/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.MethodHandle;
import soot.jimple.StringConstant;

public class CilLdMemberTokenInstruction
extends AbstractCilnstruction {
    public CilLdMemberTokenInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        if (this.instruction.hasField()) {
            ProtoAssemblyAllTypes.FieldDefinition field = this.instruction.getField();
            SootClass declaringClass = SootResolver.v().makeClassRef(field.getDeclaringType().getFullname());
            SootFieldRef sootFieldRef = Scene.v().makeFieldRef(declaringClass, field.getName(), DotnetTypeFactory.toSootType(field.getType()), field.getIsStatic());
            int kind = field.getIsStatic() ? MethodHandle.Kind.REF_GET_FIELD_STATIC.getValue() : MethodHandle.Kind.REF_GET_FIELD.getValue();
            return MethodHandle.v(sootFieldRef, kind);
        }
        if (this.instruction.hasMethod()) {
            DotnetMethod method = new DotnetMethod(this.instruction.getMethod());
            SootClass declaringClass = method.getDeclaringClass();
            if (method.getName().trim().isEmpty()) {
                throw new RuntimeException("Opcode: " + (Object)((Object)this.instruction.getOpCode()) + ": Given method " + method.getName() + " of declared type " + method.getDeclaringClass().getName() + " has no method name!");
            }
            String methodName = method.getUniqueName();
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            for (ProtoAssemblyAllTypes.ParameterDefinition parameterDefinition : method.getParameterDefinitions()) {
                paramTypes.add(DotnetTypeFactory.toSootType(parameterDefinition.getType()));
            }
            SootMethodRef methodRef = Scene.v().makeMethodRef(declaringClass, DotnetMethod.convertCtorName(methodName), paramTypes, DotnetTypeFactory.toSootType(method.getReturnType()), method.isStatic());
            int kind = method.isConstructor() ? MethodHandle.Kind.REF_INVOKE_CONSTRUCTOR.getValue() : (method.isStatic() ? MethodHandle.Kind.REF_INVOKE_STATIC.getValue() : (declaringClass.isInterface() ? MethodHandle.Kind.REF_INVOKE_INTERFACE.getValue() : MethodHandle.Kind.REF_INVOKE_VIRTUAL.getValue()));
            return MethodHandle.v(methodRef, kind);
        }
        return StringConstant.v(this.instruction.getValueConstantString());
    }
}

