/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import soot.Kind;
import soot.MethodSubSignature;
import soot.ModuleUtil;
import soot.Scene;
import soot.jimple.Stmt;
import soot.util.StringNumberer;

public class VirtualEdgesSummaries {
    public static final int BASE_INDEX = -1;
    private static final String SUMMARIESFILE = "virtualedges.xml";
    protected final HashMap<MethodSubSignature, VirtualEdge> instanceinvokeEdges = new LinkedHashMap<MethodSubSignature, VirtualEdge>();
    protected final HashMap<String, VirtualEdge> staticinvokeEdges = new LinkedHashMap<String, VirtualEdge>();
    private static final Logger logger = LoggerFactory.getLogger(VirtualEdgesSummaries.class);

    public VirtualEdgesSummaries() {
        Path summariesFile = Paths.get(SUMMARIESFILE, new String[0]);
        try (InputStream in = Files.exists(summariesFile, new LinkOption[0]) ? Files.newInputStream(summariesFile, new OpenOption[0]) : ModuleUtil.class.getResourceAsStream("/virtualedges.xml");){
            if (in == null) {
                logger.error("Virtual edge summaries file not found");
            } else {
                this.loadSummaries(in);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            logger.error("An error occurred while reading in virtual edge summaries", (Throwable)e1);
        }
    }

    public VirtualEdgesSummaries(File summariesFile) {
        try (FileInputStream in = new FileInputStream(summariesFile);){
            this.loadSummaries(in);
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            logger.error("An error occurred while reading in virtual edge summaries", (Throwable)e1);
        }
    }

    protected void loadSummaries(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        doc.getDocumentElement().normalize();
        NodeList edges = doc.getElementsByTagName("edge");
        int e = edges.getLength();
        for (int i = 0; i < e; ++i) {
            if (edges.item(i).getNodeType() != 1) continue;
            Element edge = (Element)edges.item(i);
            VirtualEdge edg = new VirtualEdge();
            switch (edge.getAttribute("type")) {
                case "THREAD": {
                    edg.edgeType = Kind.THREAD;
                    break;
                }
                case "EXECUTOR": {
                    edg.edgeType = Kind.EXECUTOR;
                    break;
                }
                case "HANDLER": {
                    edg.edgeType = Kind.HANDLER;
                    break;
                }
                case "ASYNCTASK": {
                    edg.edgeType = Kind.ASYNCTASK;
                    break;
                }
                case "PRIVILEGED": {
                    edg.edgeType = Kind.PRIVILEGED;
                    break;
                }
                default: {
                    edg.edgeType = Kind.GENERIC_FAKE;
                }
            }
            edg.source = VirtualEdgesSummaries.parseEdgeSource((Element)edge.getElementsByTagName("source").item(0));
            edg.targets = new HashSet<VirtualEdgeTarget>();
            Element targetsElement = (Element)edge.getElementsByTagName("targets").item(0);
            edg.targets.addAll(VirtualEdgesSummaries.parseEdgeTargets(targetsElement));
            if (edg.source instanceof InstanceinvokeSource) {
                InstanceinvokeSource inst = (InstanceinvokeSource)edg.source;
                MethodSubSignature subsig = inst.subSignature;
                this.addInstanceInvoke(edg, subsig);
            }
            if (!(edg.source instanceof StaticinvokeSource)) continue;
            StaticinvokeSource stat = (StaticinvokeSource)edg.source;
            this.staticinvokeEdges.put(stat.signature, edg);
        }
        logger.debug("Found {} instanceinvoke, {} staticinvoke edge descriptions", (Object)this.instanceinvokeEdges.size(), (Object)this.staticinvokeEdges.size());
    }

    protected void addInstanceInvoke(VirtualEdge edg, MethodSubSignature subsig) {
        VirtualEdge existing = this.instanceinvokeEdges.get(subsig);
        if (existing != null) {
            existing.targets.addAll(edg.targets);
        } else {
            this.instanceinvokeEdges.put(subsig, edg);
        }
    }

    public VirtualEdgesSummaries(Collection<VirtualEdge> edges) {
        for (VirtualEdge vi : edges) {
            if (vi.source instanceof InstanceinvokeSource) {
                InstanceinvokeSource inst = (InstanceinvokeSource)vi.source;
                this.addInstanceInvoke(vi, inst.subSignature);
                continue;
            }
            if (!(vi.source instanceof StaticinvokeSource)) continue;
            StaticinvokeSource stat = (StaticinvokeSource)vi.source;
            this.staticinvokeEdges.put(stat.signature, vi);
        }
    }

    public Document toXMLDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element root = document.createElement("virtualedges");
        document.appendChild(root);
        for (VirtualEdge edge : Iterables.concat(this.instanceinvokeEdges.values(), this.staticinvokeEdges.values())) {
            Element e = VirtualEdgesSummaries.edgeToXML(document, edge);
            root.appendChild(e);
        }
        return document;
    }

    private static Element edgeToXML(Document doc, VirtualEdge edge) {
        VirtualEdgeSource inv;
        Element node = doc.createElement("edge");
        node.setAttribute("type", edge.edgeType.name());
        Element source = doc.createElement("source");
        node.appendChild(source);
        if (edge.source instanceof StaticinvokeSource) {
            inv = (StaticinvokeSource)edge.source;
            source.setAttribute("invoketype", "static");
            source.setAttribute("signature", inv.signature);
        } else if (edge.source instanceof InstanceinvokeSource) {
            inv = (InstanceinvokeSource)edge.source;
            source.setAttribute("invoketype", "instance");
            source.setAttribute("subsignature", ((InstanceinvokeSource)inv).subSignature.toString());
        } else {
            if (edge.source == null) {
                throw new IllegalArgumentException("Unsupported null source type");
            }
            throw new IllegalArgumentException("Unsupported source type " + edge.source.getClass());
        }
        Element targets = doc.createElement("targets");
        node.appendChild(targets);
        for (VirtualEdgeTarget e : edge.targets) {
            Element target = VirtualEdgesSummaries.edgeTargetToXML(doc, e);
            targets.appendChild(target);
        }
        return node;
    }

    private static Element edgeTargetToXML(Document doc, VirtualEdgeTarget e) {
        Element target;
        if (e instanceof DirectTarget) {
            target = doc.createElement("direct");
        } else if (e instanceof IndirectTarget) {
            target = doc.createElement("indirect");
            IndirectTarget id = (IndirectTarget)e;
            for (VirtualEdgeTarget i : id.targets) {
                target.appendChild(VirtualEdgesSummaries.edgeTargetToXML(doc, i));
            }
        } else {
            if (e == null) {
                throw new IllegalArgumentException("Unsupported null edge type");
            }
            throw new IllegalArgumentException("Unsupported source type " + e.getClass());
        }
        target.setAttribute("subsignature", e.targetMethod.toString());
        if (e.isBase()) {
            target.setAttribute("target-position", "base");
        } else {
            target.setAttribute("index", String.valueOf(e.argIndex));
            target.setAttribute("target-position", "argument");
        }
        return target;
    }

    public VirtualEdge getVirtualEdgesMatchingSubSig(MethodSubSignature subsig) {
        return this.instanceinvokeEdges.get(subsig);
    }

    public VirtualEdge getVirtualEdgesMatchingFunction(String signature) {
        return this.staticinvokeEdges.get(signature);
    }

    private static VirtualEdgeSource parseEdgeSource(Element source) {
        switch (source.getAttribute("invoketype")) {
            case "instance": {
                return new InstanceinvokeSource(source.getAttribute("subsignature"));
            }
            case "static": {
                return new StaticinvokeSource(source.getAttribute("signature"));
            }
        }
        return null;
    }

    private static List<VirtualEdgeTarget> parseEdgeTargets(Element targetsElement) {
        ArrayList<VirtualEdgeTarget> targets = new ArrayList<VirtualEdgeTarget>();
        StringNumberer nmbr = Scene.v().getSubSigNumberer();
        NodeList children = targetsElement.getChildNodes();
        int e = children.getLength();
        block24: for (int i = 0; i < e; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element targetElement = (Element)children.item(i);
            switch (targetElement.getTagName()) {
                case "direct": {
                    String tpos;
                    MethodSubSignature subsignature = new MethodSubSignature(nmbr.findOrAdd(targetElement.getAttribute("subsignature")));
                    switch (tpos = targetElement.getAttribute("target-position")) {
                        case "argument": {
                            int argIdx = Integer.valueOf(targetElement.getAttribute("index"));
                            targets.add(new DirectTarget(subsignature, argIdx));
                            continue block24;
                        }
                        case "base": {
                            targets.add(new DirectTarget(subsignature));
                            continue block24;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported target position " + tpos);
                }
                case "indirect": {
                    IndirectTarget target;
                    String tpos;
                    MethodSubSignature subsignature = new MethodSubSignature(nmbr.findOrAdd(targetElement.getAttribute("subsignature")));
                    switch (tpos = targetElement.getAttribute("target-position")) {
                        case "argument": {
                            int argIdx = Integer.valueOf(targetElement.getAttribute("index"));
                            target = new IndirectTarget(subsignature, argIdx);
                            break;
                        }
                        case "base": {
                            target = new IndirectTarget(subsignature);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported target position " + tpos);
                        }
                    }
                    targets.add(target);
                    target.addTargets(VirtualEdgesSummaries.parseEdgeTargets(targetElement));
                    targets.add(target);
                    continue block24;
                }
            }
        }
        return targets;
    }

    public boolean isEmpty() {
        return this.instanceinvokeEdges.isEmpty() && this.staticinvokeEdges.isEmpty();
    }

    public Set<VirtualEdge> getAllVirtualEdges() {
        HashSet<VirtualEdge> allEdges = new HashSet<VirtualEdge>(this.instanceinvokeEdges.size() + this.staticinvokeEdges.size());
        allEdges.addAll(this.instanceinvokeEdges.values());
        allEdges.addAll(this.staticinvokeEdges.values());
        return allEdges;
    }

    public static class VirtualEdge {
        Kind edgeType;
        VirtualEdgeSource source;
        Set<VirtualEdgeTarget> targets;

        VirtualEdge() {
        }

        public VirtualEdge(Kind edgeType, VirtualEdgeSource source, VirtualEdgeTarget target) {
            this(edgeType, source, new ArrayList<VirtualEdgeTarget>(Collections.singletonList(target)));
        }

        public VirtualEdge(Kind edgeType, VirtualEdgeSource source, Collection<VirtualEdgeTarget> targets) {
            this.edgeType = edgeType;
            this.source = source;
            this.targets = new HashSet<VirtualEdgeTarget>(targets);
        }

        public Kind getEdgeType() {
            return this.edgeType;
        }

        public VirtualEdgeSource getSource() {
            return this.source;
        }

        public Set<VirtualEdgeTarget> getTargets() {
            return this.targets;
        }

        public void addTargets(Collection<VirtualEdgeTarget> newTargets) {
            this.targets.addAll(newTargets);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VirtualEdgeTarget t : this.targets) {
                sb.append(t.toString()).append(' ');
            }
            return String.format("%s %s => %s", this.edgeType, this.source.toString(), sb.toString());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edgeType == null ? 0 : this.edgeType.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualEdge other = (VirtualEdge)obj;
            if (this.edgeType == null ? other.edgeType != null : !this.edgeType.equals(other.edgeType)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
        }
    }

    public static class IndirectTarget
    extends VirtualEdgeTarget {
        List<VirtualEdgeTarget> targets = new ArrayList<VirtualEdgeTarget>();

        IndirectTarget() {
        }

        public IndirectTarget(MethodSubSignature targetMethod, int argIndex) {
            super(targetMethod, argIndex);
        }

        public IndirectTarget(InstanceinvokeSource source) {
            super(source.subSignature);
        }

        public IndirectTarget(MethodSubSignature targetMethod) {
            super(targetMethod);
        }

        public void addTarget(VirtualEdgeTarget target) {
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
        }

        public void addTargets(Collection<? extends VirtualEdgeTarget> targets) {
            for (VirtualEdgeTarget virtualEdgeTarget : targets) {
                this.addTarget(virtualEdgeTarget);
            }
        }

        public List<VirtualEdgeTarget> getTargets() {
            return this.targets;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VirtualEdgeTarget t : this.targets) {
                sb.append('(').append(t.toString()).append(") ");
            }
            return String.format("(Instances passed to <?: %s> on %s => %s)", this.targetMethod.toString(), super.toString(), sb.toString());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            IndirectTarget other = (IndirectTarget)obj;
            return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
        }
    }

    public static class DirectTarget
    extends VirtualEdgeTarget {
        DirectTarget() {
        }

        public DirectTarget(MethodSubSignature targetMethod, int argIndex) {
            super(targetMethod, argIndex);
        }

        public DirectTarget(MethodSubSignature targetMethod) {
            super(targetMethod);
        }

        @Override
        public String toString() {
            return String.format("Direct to %s on %s", this.targetMethod.toString(), super.toString());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return super.equals(obj) && this.getClass() == obj.getClass();
        }
    }

    public static abstract class VirtualEdgeTarget {
        protected int argIndex;
        protected MethodSubSignature targetMethod;

        VirtualEdgeTarget() {
        }

        public VirtualEdgeTarget(MethodSubSignature targetMethod) {
            this.argIndex = -1;
            this.targetMethod = targetMethod;
        }

        public VirtualEdgeTarget(MethodSubSignature targetMethod, int argIndex) {
            this.argIndex = argIndex;
            this.targetMethod = targetMethod;
        }

        public String toString() {
            return this.isBase() ? "base" : String.format("argument %d", this.argIndex);
        }

        public boolean isBase() {
            return this.argIndex == -1;
        }

        public int getArgIndex() {
            return this.argIndex;
        }

        public MethodSubSignature getTargetMethod() {
            return this.targetMethod;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.argIndex;
            result = 31 * result + (this.targetMethod == null ? 0 : this.targetMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualEdgeTarget other = (VirtualEdgeTarget)obj;
            if (this.argIndex != other.argIndex) {
                return false;
            }
            return !(this.targetMethod == null ? other.targetMethod != null : !this.targetMethod.equals(other.targetMethod));
        }
    }

    public static class InstanceinvokeSource
    extends VirtualEdgeSource {
        MethodSubSignature subSignature;

        public InstanceinvokeSource(String subSignature) {
            this.subSignature = new MethodSubSignature(Scene.v().getSubSigNumberer().findOrAdd(subSignature));
        }

        public InstanceinvokeSource(Stmt invokeStmt) {
            this(invokeStmt.getInvokeExpr().getMethodRef().getSubSignature().getString());
        }

        public String toString() {
            return this.subSignature.toString();
        }

        public MethodSubSignature getSubSignature() {
            return this.subSignature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.subSignature == null ? 0 : this.subSignature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceinvokeSource other = (InstanceinvokeSource)obj;
            return !(this.subSignature == null ? other.subSignature != null : !this.subSignature.equals(other.subSignature));
        }
    }

    public static class StaticinvokeSource
    extends VirtualEdgeSource {
        String signature;

        public StaticinvokeSource(String signature) {
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return this.signature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StaticinvokeSource other = (StaticinvokeSource)obj;
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }
    }

    public static abstract class VirtualEdgeSource {
    }
}

