/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import soot.Hierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.invoke.AccessManager;

public class InlinerSafetyManager {
    private static final boolean PRINT_FAILURE_REASONS = true;

    public static boolean checkSpecialInlineRestrictions(SootMethod container2, SootMethod target, String options) {
        boolean accessors = "accessors".equals(options);
        for (Unit u : target.getActiveBody().getUnits()) {
            InvokeExpr ie1;
            Stmt st = (Stmt)u;
            if (!st.containsInvokeExpr() || !((ie1 = st.getInvokeExpr()) instanceof SpecialInvokeExpr)) continue;
            SootClass containerDeclaringClass = container2.getDeclaringClass();
            if (InlinerSafetyManager.specialInvokePerformsLookupIn(ie1, containerDeclaringClass) || InlinerSafetyManager.specialInvokePerformsLookupIn(ie1, target.getDeclaringClass())) {
                return false;
            }
            SootMethod specialTarget = ie1.getMethod();
            if (!specialTarget.isPrivate() || specialTarget.getDeclaringClass() == containerDeclaringClass || accessors) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAccessRestrictions(SootMethod container2, SootMethod target, String modifierOptions) {
        for (Unit u : target.getActiveBody().getUnits()) {
            Stmt st = (Stmt)u;
            if (st.containsInvokeExpr() && !AccessManager.ensureAccess(container2, st.getInvokeExpr().getMethod(), modifierOptions)) {
                return false;
            }
            if (!(st instanceof AssignStmt)) continue;
            Value lhs = ((AssignStmt)st).getLeftOp();
            Value rhs = ((AssignStmt)st).getRightOp();
            if ((!(lhs instanceof FieldRef) || AccessManager.ensureAccess(container2, ((FieldRef)lhs).getField(), modifierOptions)) && (!(rhs instanceof FieldRef) || AccessManager.ensureAccess(container2, ((FieldRef)rhs).getField(), modifierOptions))) continue;
            return false;
        }
        return true;
    }

    public static boolean ensureInlinability(SootMethod target, Stmt toInline, SootMethod container2, String modifierOptions) {
        if (!InlinerSafetyManager.canSafelyInlineInto(target, toInline, container2)) {
            System.out.println("[InlinerSafetyManager] failed canSafelyInlineInto checks");
            return false;
        }
        if (!AccessManager.ensureAccess(container2, target, modifierOptions)) {
            System.out.println("[InlinerSafetyManager] failed AccessManager.ensureAccess checks");
            return false;
        }
        if (!InlinerSafetyManager.checkSpecialInlineRestrictions(container2, target, modifierOptions)) {
            System.out.println("[InlinerSafetyManager] failed checkSpecialInlineRestrictions checks");
            return false;
        }
        if (!InlinerSafetyManager.checkAccessRestrictions(container2, target, modifierOptions)) {
            System.out.println("[InlinerSafetyManager] failed checkAccessRestrictions checks");
            return false;
        }
        return true;
    }

    private static boolean canSafelyInlineInto(SootMethod inlinee, Stmt toInline, SootMethod container2) {
        Type baseTy;
        if ("<init>".equals(inlinee.getName())) {
            System.out.println("[InlinerSafetyManager] cannot inline constructors");
            return false;
        }
        if (inlinee.getSignature().equals(container2.getSignature())) {
            System.out.println("[InlinerSafetyManager] cannot inline method into itself");
            return false;
        }
        if (inlinee.isNative() || inlinee.isAbstract()) {
            System.out.println("[InlinerSafetyManager] cannot inline native or abstract methods");
            return false;
        }
        InvokeExpr ie = toInline.getInvokeExpr();
        if (ie instanceof InstanceInvokeExpr && (baseTy = ((InstanceInvokeExpr)ie).getBase().getType()) instanceof RefType && InlinerSafetyManager.invokeThrowsAccessErrorIn(((RefType)baseTy).getSootClass(), inlinee, container2)) {
            System.out.println("[InlinerSafetyManager] cannot inline away IllegalAccessErrors");
            return false;
        }
        if (ie instanceof SpecialInvokeExpr && (InlinerSafetyManager.specialInvokePerformsLookupIn(ie, inlinee.getDeclaringClass()) || InlinerSafetyManager.specialInvokePerformsLookupIn(ie, container2.getDeclaringClass()))) {
            System.out.println("[InlinerSafetyManager] cannot inline if changes semantics of invokespecial");
            return false;
        }
        return true;
    }

    private static boolean invokeThrowsAccessErrorIn(SootClass base, SootMethod inlinee, SootMethod container2) {
        Hierarchy h;
        SootClass inlineeClass = inlinee.getDeclaringClass();
        SootClass containerClass = container2.getDeclaringClass();
        if (inlinee.isPrivate() && !inlineeClass.getName().equals(containerClass.getName())) {
            return true;
        }
        if (!(inlinee.isPrivate() || inlinee.isProtected() || inlinee.isPublic() || inlineeClass.getPackageName().equals(containerClass.getPackageName()))) {
            return true;
        }
        return inlinee.isProtected() && !(h = Scene.v().getActiveHierarchy()).isClassSuperclassOfIncluding(inlineeClass, containerClass) && (base == null || !h.isClassSuperclassOfIncluding(base, containerClass));
    }

    static boolean specialInvokePerformsLookupIn(InvokeExpr ie, SootClass containerClass) {
        assert (ie instanceof SpecialInvokeExpr);
        SootMethod m = ie.getMethod();
        if ("<init>".equals(m.getName()) || m.isPrivate()) {
            return false;
        }
        Hierarchy h = Scene.v().getActiveHierarchy();
        return h.isClassSuperclassOf(m.getDeclaringClass(), containerClass);
    }

    private InlinerSafetyManager() {
    }
}

