/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.List;
import soot.G;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SideEffectTester;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.Constant;
import soot.jimple.Expr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;

public class PASideEffectTester
implements SideEffectTester {
    private final PointsToAnalysis pa = Scene.v().getPointsToAnalysis();
    private final SideEffectAnalysis sea = Scene.v().getSideEffectAnalysis();
    private HashMap<Unit, RWSet> unitToRead;
    private HashMap<Unit, RWSet> unitToWrite;
    private HashMap<Local, PointsToSet> localToReachingObjects;
    private SootMethod currentMethod;

    public PASideEffectTester() {
        if (G.v().Union_factory == null) {
            G.v().Union_factory = new UnionFactory(){

                @Override
                public Union newUnion() {
                    return FullObjectSet.v();
                }
            };
        }
    }

    @Override
    public void newMethod(SootMethod m) {
        this.unitToRead = new HashMap();
        this.unitToWrite = new HashMap();
        this.localToReachingObjects = new HashMap();
        this.currentMethod = m;
        this.sea.findNTRWSets(m);
    }

    protected RWSet readSet(Unit u) {
        RWSet ret = this.unitToRead.get(u);
        if (ret == null) {
            ret = this.sea.readSet(this.currentMethod, (Stmt)u);
            this.unitToRead.put(u, ret);
        }
        return ret;
    }

    protected RWSet writeSet(Unit u) {
        RWSet ret = this.unitToWrite.get(u);
        if (ret == null) {
            ret = this.sea.writeSet(this.currentMethod, (Stmt)u);
            this.unitToWrite.put(u, ret);
        }
        return ret;
    }

    protected PointsToSet reachingObjects(Local l) {
        PointsToSet ret = this.localToReachingObjects.get(l);
        if (ret == null) {
            ret = this.pa.reachingObjects(l);
            this.localToReachingObjects.put(l, ret);
        }
        return ret;
    }

    @Override
    public boolean unitCanReadFrom(Unit u, Value v) {
        return this.valueTouchesRWSet(this.readSet(u), v, u.getUseBoxes());
    }

    @Override
    public boolean unitCanWriteTo(Unit u, Value v) {
        return this.valueTouchesRWSet(this.writeSet(u), v, u.getDefBoxes());
    }

    protected boolean valueTouchesRWSet(RWSet s, Value v, List<ValueBox> boxes) {
        for (ValueBox use : v.getUseBoxes()) {
            if (!this.valueTouchesRWSet(s, use.getValue(), boxes)) continue;
            return true;
        }
        if (v instanceof Constant) {
            return false;
        }
        if (v instanceof Expr) {
            throw new RuntimeException("can't deal with expr");
        }
        for (ValueBox box : boxes) {
            if (!box.getValue().equivTo(v)) continue;
            return true;
        }
        if (v instanceof Local) {
            return false;
        }
        if (v instanceof InstanceFieldRef) {
            if (s == null) {
                return false;
            }
            InstanceFieldRef ifr = (InstanceFieldRef)v;
            PointsToSet o1 = s.getBaseForField(ifr.getField());
            if (o1 == null) {
                return false;
            }
            PointsToSet o2 = this.reachingObjects((Local)ifr.getBase());
            if (o2 == null) {
                return false;
            }
            return o1.hasNonEmptyIntersection(o2);
        }
        if (v instanceof ArrayRef) {
            if (s == null) {
                return false;
            }
            PointsToSet o1 = s.getBaseForField("ARRAY_ELEMENTS_NODE");
            if (o1 == null) {
                return false;
            }
            ArrayRef ar = (ArrayRef)v;
            PointsToSet o2 = this.reachingObjects((Local)ar.getBase());
            if (o2 == null) {
                return false;
            }
            return o1.hasNonEmptyIntersection(o2);
        }
        if (v instanceof StaticFieldRef) {
            if (s == null) {
                return false;
            }
            StaticFieldRef sfr = (StaticFieldRef)v;
            return s.getGlobals().contains(sfr.getField());
        }
        throw new RuntimeException("Forgot to handle value " + v);
    }
}

