/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import soot.util.BitVector;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public final class NumberedSet<N extends Numberable> {
    private final IterableNumberer<N> universe;
    private Numberable[] array = new Numberable[8];
    private BitVector bits;
    private int size = 0;

    public NumberedSet(IterableNumberer<N> universe) {
        this.universe = universe;
    }

    public boolean add(Numberable o) {
        if (this.array != null) {
            int pos = this.findPosition(o);
            if (this.array[pos] == o) {
                return false;
            }
            ++this.size;
            if (this.size * 3 > this.array.length * 2) {
                this.doubleSize();
                if (this.array != null) {
                    pos = this.findPosition(o);
                } else {
                    int number = o.getNumber();
                    if (number == 0) {
                        throw new RuntimeException("unnumbered");
                    }
                    return this.bits.set(number);
                }
            }
            this.array[pos] = o;
            return true;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        if (this.bits.set(number)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean contains(Numberable o) {
        if (this.array != null) {
            return this.array[this.findPosition(o)] != null;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        return this.bits.get(number);
    }

    private int findPosition(Numberable o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        Numberable temp;
        while ((temp = this.array[number]) != o && temp != null) {
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private void doubleSize() {
        int uniSize = this.universe.size();
        if (this.array.length * 128 > uniSize) {
            this.bits = new BitVector(uniSize);
            Numberable[] oldArray = this.array;
            this.array = null;
            for (Numberable element : oldArray) {
                if (element == null) continue;
                this.bits.set(element.getNumber());
            }
        } else {
            Numberable[] oldArray = this.array;
            this.array = new Numberable[this.array.length * 2];
            for (Numberable element : oldArray) {
                if (element == null) continue;
                this.array[this.findPosition((Numberable)element)] = element;
            }
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator<N> iterator() {
        if (this.array == null) {
            return new BitSetIterator();
        }
        return new NumberedSetIterator();
    }

    private class NumberedSetIterator
    implements Iterator<N> {
        private int cur = 0;

        NumberedSetIterator() {
            this.seekNext();
        }

        protected final void seekNext() {
            Numberable[] temp = NumberedSet.this.array;
            try {
                while (temp[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.cur != -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final N next() {
            Numberable ret = NumberedSet.this.array[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    private class BitSetIterator
    implements Iterator<N> {
        private final soot.util.BitSetIterator iter;

        BitSetIterator() {
            this.iter = NumberedSet.this.bits.iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final N next() {
            return (Numberable)NumberedSet.this.universe.get(this.iter.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

