/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import java.util.DoubleSummaryStatistics;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.Point;

class BoundingBox {
    private final Point max;
    private final Point min;

    BoundingBox(Geometry[] geometries) {
        this(Stream.of(geometries).map(Geometry::boundingBox).flatMap(BoundingBox::points));
    }

    BoundingBox(Stream<Point> points) {
        DoubleSummaryStatistics lat = new DoubleSummaryStatistics();
        DoubleSummaryStatistics lon = new DoubleSummaryStatistics();
        points.forEach(point -> {
            lat.accept(point.latitude());
            lon.accept(point.longitude());
        });
        this.max = new Point((float)lat.getMax(), (float)lon.getMax());
        this.min = new Point((float)lat.getMin(), (float)lon.getMin());
    }

    boolean contains(float lat, float lon) {
        return lat <= this.max.latitude() && lon <= this.max.longitude() && lat >= this.min.latitude() && lon >= this.min.longitude();
    }

    float centroidLatitude() {
        return (this.max.latitude() + this.min.latitude()) / 2.0f;
    }

    float centroidLongitude() {
        return (this.max.longitude() + this.min.longitude()) / 2.0f;
    }

    private Stream<Point> points() {
        return Stream.of(this.max, this.min);
    }
}

