/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Country {
    private final String iso;
    private final String iso3;
    private final int isoNumeric;
    private final String name;
    private final float area;
    private final int population;
    private final String continent;
    private final List<Locale> locales;

    private Country(String[] row) {
        this.iso = row[0];
        this.iso3 = row[1];
        this.isoNumeric = Integer.parseInt(row[2]);
        this.name = row[4];
        this.area = Float.parseFloat(row[6]);
        this.population = Integer.parseInt(row[7]);
        this.continent = row[8];
        this.locales = Stream.of(row[15].split(",")).map(Locale::forLanguageTag).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    static Map<String, Country> load(Reader reader) {
        return new BufferedReader(reader).lines().filter(line -> !line.startsWith("#")).map(line -> line.split("\t")).collect(Collectors.toMap(row -> row[16], Country::new));
    }

    public String iso() {
        return this.iso;
    }

    public String iso3() {
        return this.iso3;
    }

    public int isoNumeric() {
        return this.isoNumeric;
    }

    public String name() {
        return this.name;
    }

    public float area() {
        return this.area;
    }

    public int population() {
        return this.population;
    }

    public String continent() {
        return this.continent;
    }

    public List<Locale> locales() {
        return this.locales;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country country = (Country)o;
        return Objects.equals(this.iso, country.iso);
    }

    public int hashCode() {
        return this.iso.hashCode();
    }

    public String toString() {
        return this.iso + " (" + this.name + ")";
    }
}

