/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.Geometry;

@JsonIgnoreProperties(ignoreUnknown=true)
class Feature {
    private final Country country;
    private final Geometry geometry;

    @JsonCreator
    Feature(@JacksonInject Map<String, Country> countries, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="geometry") Geometry geometry) {
        String id = properties.get("geoNameId");
        this.country = countries.get(id);
        this.geometry = geometry;
    }

    Country country() {
        return this.country;
    }

    Stream<Geometry> geometries() {
        return this.geometry.flatten(this.country);
    }
}

