/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.Feature;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.SortTileRecursive;

@JsonIgnoreProperties(ignoreUnknown=true)
class FeatureCollection {
    private final Geometry world;
    private final Country[] countries;

    @JsonCreator
    FeatureCollection(@JsonProperty(value="features") Feature[] features) {
        this.world = SortTileRecursive.pack(Stream.of(features).flatMap(Feature::geometries));
        this.countries = (Country[])Stream.of(features).map(Feature::country).toArray(Country[]::new);
    }

    Country getCountry(float lat, float lon) {
        return this.world.getCountry(lat, lon);
    }

    Stream<Country> countries() {
        return Stream.of(this.countries);
    }
}

