/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.BoundingBox;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.Polygon;
import uk.recurse.geocoding.reverse.Ring;

class MultiPolygon
implements Geometry {
    private final Geometry[] geometries;
    private final BoundingBox boundingBox;

    @JsonCreator
    MultiPolygon(@JsonProperty(value="coordinates") Ring[][] rings) {
        this((Geometry[])Stream.of(rings).map(Polygon::new).toArray(Geometry[]::new));
    }

    MultiPolygon(Geometry[] geometries) {
        this.geometries = geometries;
        this.boundingBox = new BoundingBox(geometries);
    }

    @Override
    public boolean contains(float lat, float lon) {
        if (this.boundingBox.contains(lat, lon)) {
            for (Geometry geometry : this.geometries) {
                if (!geometry.contains(lat, lon)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Country getCountry(float lat, float lon) {
        if (this.boundingBox.contains(lat, lon)) {
            for (Geometry geometry : this.geometries) {
                Country country = geometry.getCountry(lat, lon);
                if (country == null) continue;
                return country;
            }
        }
        return null;
    }

    @Override
    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    @Override
    public Stream<Geometry> flatten(Country country) {
        return Stream.of(this.geometries).flatMap(geometry -> geometry.flatten(country));
    }
}

