/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.BoundingBox;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.Ring;
import uk.recurse.geocoding.reverse.SortTileRecursive;

class Polygon
implements Geometry {
    private final Ring ring;
    private final Geometry holes;
    private final Country country;

    @JsonCreator
    Polygon(@JsonProperty(value="coordinates") Ring[] rings) {
        this(rings[0], SortTileRecursive.pack(Stream.of(rings).skip(1L)), null);
    }

    private Polygon(Ring ring, Geometry holes, Country country) {
        this.ring = ring;
        this.holes = holes;
        this.country = country;
    }

    @Override
    public boolean contains(float lat, float lon) {
        return this.ring.contains(lat, lon) && !this.holes.contains(lat, lon);
    }

    @Override
    public Country getCountry(float lat, float lon) {
        return this.contains(lat, lon) ? this.country : null;
    }

    @Override
    public BoundingBox boundingBox() {
        return this.ring.boundingBox();
    }

    @Override
    public Stream<Geometry> flatten(Country country) {
        return Stream.of(new Polygon(this.ring, this.holes, country));
    }
}

