/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.FeatureCollection;

public class ReverseGeocoder {
    private final FeatureCollection featureCollection;

    public ReverseGeocoder() {
        Class<ReverseGeocoder> cls = ReverseGeocoder.class;
        try (InputStream countryInfo = cls.getResourceAsStream("/countryInfo.txt");
             InputStream shapes = cls.getResourceAsStream("/shapes_simplified_low.json");){
            this.featureCollection = this.load(countryInfo, shapes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private FeatureCollection load(InputStream countryInfo, InputStream shapes) throws IOException {
        Map<String, Country> countries = Country.load(new InputStreamReader(countryInfo, StandardCharsets.UTF_8));
        InjectableValues.Std injectables = new InjectableValues.Std().addValue(Map.class, countries);
        return (FeatureCollection)new ObjectMapper().readerFor(FeatureCollection.class).with((InjectableValues)injectables).readValue(shapes);
    }

    public Optional<Country> getCountry(double lat, double lon) {
        return this.getCountry((float)lat, (float)lon);
    }

    public Optional<Country> getCountry(float lat, float lon) {
        return Optional.ofNullable(this.featureCollection.getCountry(lat, lon));
    }

    public Stream<Country> countries() {
        return this.featureCollection.countries();
    }
}

