/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.BoundingBox;
import uk.recurse.geocoding.reverse.Country;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.Point;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
class Ring
implements Geometry {
    private final float[] latitude;
    private final float[] longitude;
    private final BoundingBox boundingBox;

    @JsonCreator
    Ring(Point ... points) {
        this.latitude = new float[points.length];
        this.longitude = new float[points.length];
        for (int i = 0; i < points.length; ++i) {
            this.latitude[i] = points[i].latitude();
            this.longitude[i] = points[i].longitude();
        }
        this.boundingBox = new BoundingBox(Stream.of(points));
    }

    @Override
    public boolean contains(float lat, float lon) {
        return this.boundingBox.contains(lat, lon) && this.pnpoly(lat, lon);
    }

    @Override
    public Country getCountry(float lat, float lon) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    @Override
    public Stream<Geometry> flatten(Country country) {
        throw new UnsupportedOperationException();
    }

    private boolean pnpoly(float lat, float lon) {
        boolean contains = false;
        int i = 0;
        int j = this.latitude.length - 1;
        while (i < this.latitude.length) {
            if (this.latitude[i] > lat != this.latitude[j] > lat && lon < (this.longitude[j] - this.longitude[i]) * (lat - this.latitude[i]) / (this.latitude[j] - this.latitude[i]) + this.longitude[i]) {
                contains = !contains;
            }
            j = i++;
        }
        return contains;
    }
}

