/*
 * Decompiled with CFR 0.152.
 */
package uk.recurse.geocoding.reverse;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.recurse.geocoding.reverse.Geometry;
import uk.recurse.geocoding.reverse.MultiPolygon;

class SortTileRecursive {
    private static final int PAGE_SIZE = 16;
    private static final Comparator<Geometry> X_COORDINATE = Comparator.comparingDouble(geometry -> geometry.boundingBox().centroidLongitude());
    private static final Comparator<Geometry> Y_COORDINATE = Comparator.comparingDouble(geometry -> geometry.boundingBox().centroidLatitude());

    SortTileRecursive() {
    }

    static MultiPolygon pack(Stream<? extends Geometry> rectangles) {
        List<Geometry> packed = SortTileRecursive.pack(rectangles.collect(Collectors.toList()));
        return new MultiPolygon(packed.toArray(new Geometry[0]));
    }

    static List<Geometry> pack(List<Geometry> rectangles) {
        int leafPages = SortTileRecursive.ceilDiv(rectangles.size(), 16.0);
        if (leafPages <= 1) {
            return rectangles;
        }
        int verticalSlices = SortTileRecursive.ceilSqrt(leafPages);
        ArrayList<Geometry> nodes = new ArrayList<Geometry>(leafPages);
        rectangles.sort(X_COORDINATE);
        for (List<Geometry> verticalSlice : SortTileRecursive.partition(rectangles, verticalSlices)) {
            verticalSlice.sort(Y_COORDINATE);
            int runs = SortTileRecursive.ceilDiv(verticalSlice.size(), 16.0);
            for (List<Geometry> run : SortTileRecursive.partition(verticalSlice, runs)) {
                nodes.add(new MultiPolygon(run.toArray(new Geometry[0])));
            }
        }
        return SortTileRecursive.pack(nodes);
    }

    private static <T> List<List<T>> partition(List<T> list, int n) {
        int size = SortTileRecursive.ceilDiv(list.size(), n);
        ArrayList<List<T>> partitions = new ArrayList<List<T>>(n);
        for (int i = 0; i < n; ++i) {
            int start = i * size;
            int end = Math.min(start + size, list.size());
            partitions.add(list.subList(start, end));
        }
        return partitions;
    }

    private static int ceilDiv(double x, double y) {
        return (int)Math.ceil(x / y);
    }

    private static int ceilSqrt(double a) {
        return (int)Math.ceil(Math.sqrt(a));
    }
}

