/*
 * Decompiled with CFR 0.152.
 */
package ru.nsk.kstatemachine.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import ru.nsk.kstatemachine.event.DestroyEvent;
import ru.nsk.kstatemachine.event.SerializableGeneratedEvent;
import ru.nsk.kstatemachine.persistence.EventRecorder;
import ru.nsk.kstatemachine.persistence.EventRecorderKt;
import ru.nsk.kstatemachine.persistence.Record;
import ru.nsk.kstatemachine.persistence.RecordedEvents;
import ru.nsk.kstatemachine.statemachine.EventRecordingArguments;
import ru.nsk.kstatemachine.statemachine.ProcessingResult;
import ru.nsk.kstatemachine.statemachine.StateMachine;
import ru.nsk.kstatemachine.transition.EventAndArgument;
import ru.nsk.kstatemachine.visitors.GetStructureHashCodeVisitorKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/nsk/kstatemachine/persistence/EventRecorderImpl;", "Lru/nsk/kstatemachine/persistence/EventRecorder;", "machine", "Lru/nsk/kstatemachine/statemachine/StateMachine;", "arguments", "Lru/nsk/kstatemachine/statemachine/EventRecordingArguments;", "(Lru/nsk/kstatemachine/statemachine/StateMachine;Lru/nsk/kstatemachine/statemachine/EventRecordingArguments;)V", "records", "", "Lru/nsk/kstatemachine/persistence/Record;", "getRecordedEvents", "Lru/nsk/kstatemachine/persistence/RecordedEvents;", "onProcessEvent", "", "eventAndArgument", "Lru/nsk/kstatemachine/transition/EventAndArgument;", "processingResult", "Lru/nsk/kstatemachine/statemachine/ProcessingResult;", "kstatemachine"})
public final class EventRecorderImpl
implements EventRecorder {
    @NotNull
    private final StateMachine machine;
    @NotNull
    private final EventRecordingArguments arguments;
    @NotNull
    private final List<Record> records;

    public EventRecorderImpl(@NotNull StateMachine machine, @NotNull EventRecordingArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.machine = machine;
        this.arguments = arguments;
        this.records = new ArrayList();
    }

    public final void onProcessEvent(@NotNull EventAndArgument<?> eventAndArgument, @NotNull ProcessingResult processingResult) {
        block3: {
            Intrinsics.checkNotNullParameter(eventAndArgument, (String)"eventAndArgument");
            Intrinsics.checkNotNullParameter((Object)((Object)processingResult), (String)"processingResult");
            Object object = (Record)CollectionsKt.lastOrNull(this.records);
            Object lastEvent = object != null && (object = ((Record)object).getEventAndArgument()) != null ? ((EventAndArgument)object).getEvent() : null;
            SerializableGeneratedEvent serializableGeneratedEvent = lastEvent instanceof SerializableGeneratedEvent ? (SerializableGeneratedEvent)lastEvent : null;
            SerializableGeneratedEvent.EventType lastEventType = serializableGeneratedEvent != null ? serializableGeneratedEvent.getEventType() : null;
            if (!(!(lastEventType instanceof SerializableGeneratedEvent.EventType.Destroy))) {
                boolean bl = false;
                String string = "Internal error, onProcessEvent called after " + Reflection.getOrCreateKotlinClass(DestroyEvent.class).getSimpleName() + " processing, which is considered as last possible event";
                throw new IllegalStateException(string.toString());
            }
            if (this.arguments.getSkipIgnoredEvents() && processingResult == ProcessingResult.IGNORED) {
                return;
            }
            if (this.arguments.getClearRecordsOnMachineRestart() && Intrinsics.areEqual((Object)lastEventType, (Object)SerializableGeneratedEvent.EventType.Stop.INSTANCE)) {
                this.records.clear();
            }
            EventAndArgument eventAndArgument2 = EventRecorderKt.access$transformGeneratedEvent(eventAndArgument);
            if (eventAndArgument2 == null) break block3;
            EventAndArgument it = eventAndArgument2;
            boolean bl = false;
            ((Collection)this.records).add(new Record(it, processingResult));
        }
    }

    @Override
    @NotNull
    public RecordedEvents getRecordedEvents() {
        return new RecordedEvents(GetStructureHashCodeVisitorKt.getStructureHashCode(this.machine), CollectionsKt.toList((Iterable)this.records));
    }
}

