/*
 * Decompiled with CFR 0.152.
 */
package ru.nsk.kstatemachine.visitors;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.nsk.kstatemachine.event.Event;
import ru.nsk.kstatemachine.state.IState;
import ru.nsk.kstatemachine.statemachine.StateMachine;
import ru.nsk.kstatemachine.transition.Transition;
import ru.nsk.kstatemachine.visitors.RecursiveVisitor;
import ru.nsk.kstatemachine.visitors.RequireNonBlankNamesVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\f\u001a\u00020\t\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/nsk/kstatemachine/visitors/RequireNonBlankNamesVisitor;", "Lru/nsk/kstatemachine/visitors/RecursiveVisitor;", "()V", "invalidStates", "", "Lru/nsk/kstatemachine/state/IState;", "invalidTransitions", "Lru/nsk/kstatemachine/transition/Transition;", "checkNonBlankNames", "", "hasBlankNames", "", "visit", "state", "machine", "Lru/nsk/kstatemachine/statemachine/StateMachine;", "E", "Lru/nsk/kstatemachine/event/Event;", "transition", "kstatemachine"})
public final class RequireNonBlankNamesVisitor
implements RecursiveVisitor {
    @NotNull
    private final Set<IState> invalidStates = new LinkedHashSet();
    @NotNull
    private final Set<Transition<?>> invalidTransitions = new LinkedHashSet();

    @Override
    public void visit(@NotNull StateMachine machine) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        CharSequence charSequence = machine.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidStates).add(machine);
        }
        this.visitChildren(machine);
    }

    @Override
    public void visit(@NotNull IState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        CharSequence charSequence = state.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidStates).add(state);
        }
        if (!(state instanceof StateMachine)) {
            this.visitChildren(state);
        }
    }

    @Override
    public <E extends Event> void visit(@NotNull Transition<E> transition2) {
        Intrinsics.checkNotNullParameter(transition2, (String)"transition");
        CharSequence charSequence = transition2.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidTransitions).add(transition2);
        }
    }

    public final boolean hasBlankNames() {
        return !((Collection)this.invalidStates).isEmpty() || !((Collection)this.invalidTransitions).isEmpty();
    }

    public final void checkNonBlankNames() {
        if (!(!this.hasBlankNames())) {
            boolean bl = false;
            String statesText2 = CollectionsKt.joinToString$default((Iterable)this.invalidStates, null, null, null, (int)0, null, (Function1)checkNonBlankNames.1.statesText.1.INSTANCE, (int)31, null);
            String transitionsText2 = CollectionsKt.joinToString$default((Iterable)this.invalidTransitions, null, null, null, (int)0, null, (Function1)checkNonBlankNames.1.transitionsText.1.INSTANCE, (int)31, null);
            String string = "There were blank names in states: " + statesText2 + " transitions: " + transitionsText2;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void visitChildren(@NotNull IState $this$visitChildren) {
        RecursiveVisitor.DefaultImpls.visitChildren(this, $this$visitChildren);
    }
}

