/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.Arity;
import cz.jirutka.rsql.parser.ast.Assert;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public final class ComparisonOperator {
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("=[a-zA-Z]*=|[><]=?|!=");
    private final String[] symbols;
    private final Arity arity;

    @Deprecated
    public ComparisonOperator(String[] symbols, boolean multiValue) {
        this(symbols, multiValue ? Arity.of(1, Integer.MAX_VALUE) : Arity.nary(1));
    }

    public ComparisonOperator(String[] symbols, Arity arity) {
        Assert.notEmpty(symbols, "symbols must not be null or empty", new Object[0]);
        Assert.notNull(arity, "arity must not be null", new Object[0]);
        for (String sym : symbols) {
            Assert.isTrue(this.isValidOperatorSymbol(sym), "symbol \"%s\" must match: \"%s\"", sym, SYMBOL_PATTERN);
        }
        this.arity = arity;
        this.symbols = (String[])symbols.clone();
    }

    @Deprecated
    public ComparisonOperator(String symbol, boolean multiValue) {
        this(new String[]{symbol}, multiValue);
    }

    public ComparisonOperator(String symbol, Arity arity) {
        this(new String[]{symbol}, arity);
    }

    public ComparisonOperator(String symbol, String altSymbol, boolean multiValue) {
        this(new String[]{symbol, altSymbol}, multiValue);
    }

    public ComparisonOperator(String symbol, String altSymbol, Arity arity) {
        this(new String[]{symbol, altSymbol}, arity);
    }

    public ComparisonOperator(String ... symbols) {
        this(symbols, false);
    }

    public String getSymbol() {
        return this.symbols[0];
    }

    public String[] getSymbols() {
        return (String[])this.symbols.clone();
    }

    @Deprecated
    public boolean isMultiValue() {
        return this.arity.max() > 1;
    }

    public Arity getArity() {
        return this.arity;
    }

    private boolean isValidOperatorSymbol(String str) {
        return !StringUtils.isBlank(str) && SYMBOL_PATTERN.matcher(str).matches();
    }

    public String toString() {
        return this.getSymbol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonOperator)) {
            return false;
        }
        ComparisonOperator that = (ComparisonOperator)o;
        return this.getSymbol().equals(that.getSymbol());
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }
}

