/*
 * Decompiled with CFR 0.152.
 */
package io.github.obscure1910.flowlandscape.api.connection;

import io.github.obscure1910.flowlandscape.api.connection.ConnectionDefinition;
import io.github.obscure1910.flowlandscape.api.ref.AsyncConsumeHolder;
import io.github.obscure1910.flowlandscape.api.ref.AsyncPublishHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class ConnectionRegistry {
    private final List<ConnectionDefinition> knownConnections;

    public ConnectionRegistry(List<ConnectionDefinition> knownConnections) {
        this.knownConnections = Collections.synchronizedList(new ArrayList<ConnectionDefinition>(knownConnections));
    }

    public boolean isCompatible(Class<?> source, Class<?> target) {
        return this.knownConnections.stream().anyMatch(cd -> cd.getSource().equals(source) && cd.getTarget().equals(target));
    }

    public boolean hasSameDestination(AsyncConsumeHolder source, AsyncPublishHolder target) {
        return this.isCompatible(source.getClass(), target.getClass()) && source.getDestinationName().equals(target.getDestinationName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionRegistry)) {
            return false;
        }
        ConnectionRegistry that = (ConnectionRegistry)o;
        return Objects.equals(this.knownConnections, that.knownConnections);
    }

    public int hashCode() {
        return Objects.hash(this.knownConnections);
    }
}

