/*
 * Decompiled with CFR 0.152.
 */
package io.github.obscure1910.plugin;

import io.github.obscure1910.flowlandscape.api.GeneratorProperties;
import io.github.obscure1910.flowlandscape.api.ImageFormat;
import io.github.obscure1910.flowlandscape.api.ReferenceFinderProperties;
import io.github.obscure1910.flowlandscape.generator.GraphvizFlowLandscape;
import io.github.obscure1910.flowlandscape.parser.XPathReferenceFinder;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger((String)"Flow-Landscape");
    @Parameter(property="imageSpaceBetweenElements", defaultValue="2.0")
    Double imageSpaceBetweenElements;
    @Parameter(property="imageHeadline", defaultValue="FlowLandscape")
    String imageHeadline;
    @Parameter(property="imageFont", defaultValue="Arial")
    String imageFont;
    @Parameter(property="imageTotalMemory", defaultValue="33554432")
    int imageTotalMemory;
    @Parameter(property="imageFormat", defaultValue="PNG")
    String imageFormat;
    @Parameter(property="imageWidth", defaultValue="12000")
    int imageWidth;
    @Parameter(property="imageOutputDirectory", defaultValue="flowlandscape/")
    String imageOutputDirectory;
    @Parameter(property="parserSourceDirectory", defaultValue="src/main/mule/")
    String parserSourceDirectory;
    @Parameter(property="parserResourceDirectory", defaultValue="src/main/resources/")
    String parserResourceDirectory;

    public void execute() {
        Path sourceDirectory = new File(this.parserSourceDirectory).toPath();
        Path resourceDirectory = new File(this.parserResourceDirectory).toPath();
        ReferenceFinderProperties referenceFinderProperties = new ReferenceFinderProperties(sourceDirectory, resourceDirectory);
        Path generatorOutputDirectory = new File(this.imageOutputDirectory).toPath();
        GeneratorProperties generatorProperties = new GeneratorProperties(generatorOutputDirectory, this.imageSpaceBetweenElements, this.imageHeadline, this.imageFont, ImageFormat.valueOf((String)this.imageFormat), this.imageTotalMemory, this.imageWidth);
        XPathReferenceFinder finder = new XPathReferenceFinder();
        List configurations = finder.findReferences(referenceFinderProperties);
        GraphvizFlowLandscape generator = new GraphvizFlowLandscape();
        generator.generateConfigurations(configurations, generatorProperties);
        logger.info("Successfully generated image with Flow-Landscape! The generated image has been copied to the folder: {}", (Object)this.imageOutputDirectory);
    }
}

