/*
 * Decompiled with CFR 0.152.
 */
package io.github.obscure1910.flowlandscape.parser;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class StreamFunctions {
    StreamFunctions() {
    }

    static Stream<String> asStream(final Matcher matcher) {
        Iterable iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return matcher.find();
            }

            @Override
            public String next() {
                return matcher.group();
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static Stream<Node> asStream(final NodeList nodeList) {
        Iterable iterable = () -> new Iterator<Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < nodeList.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return nodeList.item(this.index++);
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @SafeVarargs
    static <A> Stream<A> streamConcat(Stream<A> ... streams) {
        return Arrays.stream(streams).reduce(Stream.empty(), Stream::concat);
    }
}

