/*
 * Decompiled with CFR 0.152.
 */
package io.github.obscure1910.flowlandscape.parser;

import io.github.obscure1910.flowlandscape.api.ConfigurationHolder;
import io.github.obscure1910.flowlandscape.api.ReferenceFinder;
import io.github.obscure1910.flowlandscape.api.ReferenceFinderProperties;
import io.github.obscure1910.flowlandscape.api.connection.ConnectionRegistry;
import io.github.obscure1910.flowlandscape.api.flow.FlowHolder;
import io.github.obscure1910.flowlandscape.api.ref.AsyncConsumeHolder;
import io.github.obscure1910.flowlandscape.api.ref.AsyncPublishHolder;
import io.github.obscure1910.flowlandscape.api.ref.ReferenceHolder;
import io.github.obscure1910.flowlandscape.parser.KnownConnections;
import io.github.obscure1910.flowlandscape.parser.PathFunctions;
import io.github.obscure1910.flowlandscape.parser.StreamFunctions;
import io.github.obscure1910.flowlandscape.parser.XPathFunctions;
import io.github.obscure1910.flowlandscape.parser.model.Configuration;
import io.github.obscure1910.flowlandscape.parser.model.Flow;
import io.github.obscure1910.flowlandscape.parser.model.FlowReference;
import io.github.obscure1910.flowlandscape.parser.model.IbmMqConsume;
import io.github.obscure1910.flowlandscape.parser.model.IbmMqPublish;
import io.github.obscure1910.flowlandscape.parser.model.JmsConsume;
import io.github.obscure1910.flowlandscape.parser.model.JmsPublish;
import io.github.obscure1910.flowlandscape.parser.model.LookupReference;
import io.github.obscure1910.flowlandscape.parser.model.VmConsume;
import io.github.obscure1910.flowlandscape.parser.model.VmPublish;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathReferenceFinder
implements ReferenceFinder {
    private final Pattern lookupsInString = Pattern.compile("(?<=((Mule::|\\s|\\[|\\()lookup)(\\((\"))|\\(('))[^(\"|')]*");
    private final ConnectionRegistry connectionRegistry = new KnownConnections();

    public List<ConfigurationHolder> findReferences(ReferenceFinderProperties referenceFinderProperties) {
        List<ConfigurationHolder> chList = PathFunctions.withXmlFiles(referenceFinderProperties.getSourceDirectory(), muleConfigurationFile -> {
            Document document = this.getDocument((File)muleConfigurationFile);
            List<FlowHolder> flows = this.getFlows(document).map(n -> {
                List<ReferenceHolder> references = StreamFunctions.streamConcat(this.getReferencesInText((Node)n), this.getReferencesInFlowRef((Node)n), this.getReferencesInAttribute((Node)n), this.getReferencesInDataweaveFile((Node)n, referenceFinderProperties.getResourceDirectory())).collect(Collectors.toList());
                List<AsyncPublishHolder> asyncPublishHolders = this.getAsyncPublisher((Node)n, document).collect(Collectors.toList());
                List<AsyncConsumeHolder> asyncConsumeHolders = this.getAsyncConsumer((Node)n, document).collect(Collectors.toList());
                return new Flow(this.getNameOfFlow((Node)n), references, asyncConsumeHolders, asyncPublishHolders);
            }).collect(Collectors.toList());
            return new Configuration(muleConfigurationFile.getName(), flows);
        });
        return chList;
    }

    protected Stream<Node> getFlows(Document document) {
        return XPathFunctions.withXPath(xPath -> StreamFunctions.asStream((NodeList)xPath.compile("//*[local-name()='flow' or local-name()='sub-flow']").evaluate(document, XPathConstants.NODESET)));
    }

    protected String getNameOfFlow(Node node) {
        return XPathFunctions.withXPath(xPath -> xPath.compile("@name").evaluate(node));
    }

    protected Stream<ReferenceHolder> getReferencesInText(Node node) {
        return XPathFunctions.withXPath(xPath -> StreamFunctions.asStream((NodeList)xPath.compile("descendant::*//text()[contains(., 'Mule::lookup') or contains(., 'lookup')]").evaluate(node, XPathConstants.NODESET)).flatMap(n -> StreamFunctions.asStream(this.lookupsInString.matcher(n.getNodeValue())).map(LookupReference::new)));
    }

    protected Stream<ReferenceHolder> getReferencesInAttribute(Node node) {
        return XPathFunctions.withXPath(xPath -> StreamFunctions.asStream((NodeList)xPath.compile("descendant::*//@*[contains(., 'Mule::lookup') or contains(., 'lookup')]").evaluate(node, XPathConstants.NODESET)).flatMap(n -> StreamFunctions.asStream(this.lookupsInString.matcher(n.getNodeValue())).map(LookupReference::new)));
    }

    protected Stream<ReferenceHolder> getReferencesInDataweaveFile(Node node, Path resourceDirectory) {
        return XPathFunctions.withXPath(xPath -> StreamFunctions.asStream((NodeList)xPath.compile("descendant::*//@resource[substring(., string-length(.) - 3) = '.dwl']").evaluate(node, XPathConstants.NODESET)).flatMap(nodeWithResource -> {
            String[] fileName = nodeWithResource.getNodeValue().split(":");
            String f = fileName[fileName.length - 1];
            try {
                byte[] bytes = Files.readAllBytes(resourceDirectory.resolve(f));
                String content = new String(bytes, StandardCharsets.UTF_8);
                return StreamFunctions.asStream(this.lookupsInString.matcher(content)).map(LookupReference::new);
            }
            catch (IOException ex) {
                return Stream.empty();
            }
        }));
    }

    protected Stream<ReferenceHolder> getReferencesInFlowRef(Node node) {
        return XPathFunctions.withXPath(xPath -> StreamFunctions.asStream((NodeList)xPath.compile("descendant::*[local-name()='flow-ref']/@name").evaluate(node, XPathConstants.NODESET)).filter(n -> !n.getNodeName().equals("doc:name")).map(n -> FlowReference.create(n.getNodeValue())));
    }

    protected Stream<AsyncPublishHolder> getAsyncPublisher(Node node, Document document) {
        return XPathFunctions.withXPathNS(document, xPath -> StreamFunctions.streamConcat(StreamFunctions.asStream((NodeList)xPath.compile("(descendant::jms:publish/@destination) | (descendant::jms:publish-consume/@destination) | (descendant::jms:outbound-endpoint/@queue)").evaluate(node, XPathConstants.NODESET)).map(n -> JmsPublish.create(n.getNodeValue(), this.connectionRegistry)), StreamFunctions.asStream((NodeList)xPath.compile("(descendant::vm:publish/@queueName) | (descendant::vm:publish-consume/@queueName) | (descendant::vm:outbound-endpoint/@path)").evaluate(node, XPathConstants.NODESET)).map(n -> VmPublish.create(n.getNodeValue(), this.connectionRegistry)), StreamFunctions.asStream((NodeList)xPath.compile("(descendant::ibm-mq:publish/@destination) | (descendant::ibm-mq:publish-consume/@destination)").evaluate(node, XPathConstants.NODESET)).map(n -> IbmMqPublish.create(n.getNodeValue(), this.connectionRegistry))));
    }

    protected Stream<AsyncConsumeHolder> getAsyncConsumer(Node node, Document document) {
        return XPathFunctions.withXPathNS(document, xPath -> StreamFunctions.streamConcat(StreamFunctions.asStream((NodeList)xPath.compile("(descendant::jms:consume/@destination) | (descendant::jms:listener/@destination) | (descendant::jms:inbound-endpoint/@queue)").evaluate(node, XPathConstants.NODESET)).map(n -> JmsConsume.create(n.getNodeValue(), this.connectionRegistry)), StreamFunctions.asStream((NodeList)xPath.compile("(descendant::vm:consume/@queueName) | (descendant::vm:listener/@queueName) | (descendant::vm:inbound-endpoint/@path)").evaluate(node, XPathConstants.NODESET)).map(n -> VmConsume.create(n.getNodeValue(), this.connectionRegistry)), StreamFunctions.asStream((NodeList)xPath.compile("(descendant::ibm-mq:consume/@destination) | (descendant::ibm-mq:listener/@destination)").evaluate(node, XPathConstants.NODESET)).map(n -> IbmMqConsume.create(n.getNodeValue(), this.connectionRegistry))));
    }

    protected Document getDocument(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            dbf.setXIncludeAware(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex);
        }
    }
}

