/*
 * Decompiled with CFR 0.152.
 */
package io.github.obscure1910.flowlandscape.parser.model;

import io.github.obscure1910.flowlandscape.api.flow.FlowHolder;
import io.github.obscure1910.flowlandscape.api.ref.AsyncConsumeHolder;
import io.github.obscure1910.flowlandscape.api.ref.AsyncPublishHolder;
import io.github.obscure1910.flowlandscape.api.ref.ReferenceHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Flow
implements FlowHolder {
    private final List<ReferenceHolder> flowReferences;
    private final List<AsyncConsumeHolder> asyncConsumer;
    private final List<AsyncPublishHolder> asyncPublisher;
    private final String flowName;

    public Flow(String flowName, List<ReferenceHolder> flowReferences, List<AsyncConsumeHolder> asyncConsumer, List<AsyncPublishHolder> asyncPublisher) {
        this.flowReferences = flowReferences;
        this.asyncConsumer = asyncConsumer;
        this.asyncPublisher = asyncPublisher;
        this.flowName = flowName;
    }

    public List<ReferenceHolder> getFlowReferences() {
        return new ArrayList<ReferenceHolder>(this.flowReferences);
    }

    public List<AsyncConsumeHolder> getAsyncConsumer() {
        return new ArrayList<AsyncConsumeHolder>(this.asyncConsumer);
    }

    public List<AsyncPublishHolder> getAsyncPublisher() {
        return new ArrayList<AsyncPublishHolder>(this.asyncPublisher);
    }

    public String getFlowName() {
        return this.flowName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow flow = (Flow)o;
        return Objects.equals(this.flowReferences, flow.flowReferences) && Objects.equals(this.asyncConsumer, flow.asyncConsumer) && Objects.equals(this.asyncPublisher, flow.asyncPublisher) && Objects.equals(this.flowName, flow.flowName);
    }

    public int hashCode() {
        return Objects.hash(this.flowReferences, this.asyncConsumer, this.asyncPublisher, this.flowName);
    }

    public String toString() {
        return "Flow{flowReferences=" + this.flowReferences + ", asyncConsumer=" + this.asyncConsumer + ", asyncPublisher=" + this.asyncPublisher + ", flowName='" + this.flowName + '\'' + '}';
    }
}

