/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.algorithms;

import com.google.ortools.algorithms.operations_research_algorithmsJNI;

public class KnapsackSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected KnapsackSolver(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(KnapsackSolver obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                operations_research_algorithmsJNI.delete_KnapsackSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public KnapsackSolver(String solver_name) {
        this(operations_research_algorithmsJNI.new_KnapsackSolver__SWIG_0(solver_name), true);
    }

    public KnapsackSolver(SolverType solver_type, String solver_name) {
        this(operations_research_algorithmsJNI.new_KnapsackSolver__SWIG_1(solver_type.swigValue(), solver_name), true);
    }

    public void init(long[] profits, long[][] weights, long[] capacities) {
        operations_research_algorithmsJNI.KnapsackSolver_init(this.swigCPtr, this, profits, weights, capacities);
    }

    public long solve() {
        return operations_research_algorithmsJNI.KnapsackSolver_solve(this.swigCPtr, this);
    }

    public boolean bestSolutionContains(int item_id) {
        return operations_research_algorithmsJNI.KnapsackSolver_bestSolutionContains(this.swigCPtr, this, item_id);
    }

    public static enum SolverType {
        KNAPSACK_BRUTE_FORCE_SOLVER(operations_research_algorithmsJNI.KnapsackSolver_KNAPSACK_BRUTE_FORCE_SOLVER_get()),
        KNAPSACK_64ITEMS_SOLVER(operations_research_algorithmsJNI.KnapsackSolver_KNAPSACK_64ITEMS_SOLVER_get()),
        KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER(operations_research_algorithmsJNI.KnapsackSolver_KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER(operations_research_algorithmsJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static SolverType swigToEnum(int swigValue) {
            SolverType[] swigValues = (SolverType[])SolverType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            SolverType[] solverTypeArray = swigValues;
            int n = swigValues.length;
            int n2 = 0;
            while (n2 < n) {
                SolverType swigEnum = solverTypeArray[n2];
                if (swigEnum.swigValue == swigValue) {
                    return swigEnum;
                }
                ++n2;
            }
            throw new IllegalArgumentException("No enum " + SolverType.class + " with value " + swigValue);
        }

        private SolverType() {
            int n2 = SwigNext.next;
            SwigNext.next = n2 + 1;
            this.swigValue = n2;
        }

        private SolverType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private SolverType(SolverType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

