/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.operations_research_linear_solverJNI;

public class MPConstraint {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPConstraint(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPConstraint obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                operations_research_linear_solverJNI.delete_MPConstraint(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public String name() {
        return operations_research_linear_solverJNI.MPConstraint_name(this.swigCPtr, this);
    }

    public void setCoefficient(MPVariable var, double coeff) {
        operations_research_linear_solverJNI.MPConstraint_setCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var, coeff);
    }

    public double getCoefficient(MPVariable var) {
        return operations_research_linear_solverJNI.MPConstraint_getCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var);
    }

    public double lb() {
        return operations_research_linear_solverJNI.MPConstraint_lb(this.swigCPtr, this);
    }

    public double ub() {
        return operations_research_linear_solverJNI.MPConstraint_ub(this.swigCPtr, this);
    }

    public void setLb(double lb) {
        operations_research_linear_solverJNI.MPConstraint_setLb(this.swigCPtr, this, lb);
    }

    public void setUb(double ub) {
        operations_research_linear_solverJNI.MPConstraint_setUb(this.swigCPtr, this, ub);
    }

    public void setBounds(double lb, double ub) {
        operations_research_linear_solverJNI.MPConstraint_setBounds(this.swigCPtr, this, lb, ub);
    }

    public boolean isLazy() {
        return operations_research_linear_solverJNI.MPConstraint_isLazy(this.swigCPtr, this);
    }

    public void setIsLazy(boolean laziness) {
        operations_research_linear_solverJNI.MPConstraint_setIsLazy(this.swigCPtr, this, laziness);
    }

    public int index() {
        return operations_research_linear_solverJNI.MPConstraint_index(this.swigCPtr, this);
    }

    public double dualValue() {
        return operations_research_linear_solverJNI.MPConstraint_dualValue(this.swigCPtr, this);
    }

    public MPSolver.BasisStatus basisStatus() {
        return MPSolver.BasisStatus.swigToEnum(operations_research_linear_solverJNI.MPConstraint_basisStatus(this.swigCPtr, this));
    }
}

