/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolverParameters;
import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.operations_research_linear_solverJNI;

public class MPSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPSolver(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPSolver obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                operations_research_linear_solverJNI.delete_MPSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer) {
        MPVariable[] array = new MPVariable[count];
        int i = 0;
        while (i < count) {
            array[i] = this.makeVar(lb, ub, integer, "");
            ++i;
        }
        return array;
    }

    public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer, String var_name) {
        MPVariable[] array = new MPVariable[count];
        int i = 0;
        while (i < count) {
            array[i] = this.makeVar(lb, ub, integer, String.valueOf(var_name) + i);
            ++i;
        }
        return array;
    }

    public MPVariable[] makeNumVarArray(int count, double lb, double ub) {
        return this.makeVarArray(count, lb, ub, false);
    }

    public MPVariable[] makeNumVarArray(int count, double lb, double ub, String var_name) {
        return this.makeVarArray(count, lb, ub, false, var_name);
    }

    public MPVariable[] makeIntVarArray(int count, double lb, double ub) {
        return this.makeVarArray(count, lb, ub, true);
    }

    public MPVariable[] makeIntVarArray(int count, double lb, double ub, String var_name) {
        return this.makeVarArray(count, lb, ub, true, var_name);
    }

    public MPVariable[] makeBoolVarArray(int count) {
        return this.makeVarArray(count, 0.0, 1.0, true);
    }

    public MPVariable[] makeBoolVarArray(int count, String var_name) {
        return this.makeVarArray(count, 0.0, 1.0, true, var_name);
    }

    public MPSolver(String name, OptimizationProblemType problem_type) {
        this(operations_research_linear_solverJNI.new_MPSolver(name, problem_type.swigValue()), true);
    }

    public static boolean supportsProblemType(OptimizationProblemType problem_type) {
        return operations_research_linear_solverJNI.MPSolver_supportsProblemType(problem_type.swigValue());
    }

    public void clear() {
        operations_research_linear_solverJNI.MPSolver_clear(this.swigCPtr, this);
    }

    public int numVariables() {
        return operations_research_linear_solverJNI.MPSolver_numVariables(this.swigCPtr, this);
    }

    public MPVariable lookupVariableOrNull(String var_name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_lookupVariableOrNull(this.swigCPtr, this, var_name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeVar(double lb, double ub, boolean integer, String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeVar(this.swigCPtr, this, lb, ub, integer, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeNumVar(double lb, double ub, String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeNumVar(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeIntVar(double lb, double ub, String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeIntVar(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeBoolVar(String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeBoolVar(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public int numConstraints() {
        return operations_research_linear_solverJNI.MPSolver_numConstraints(this.swigCPtr, this);
    }

    public MPConstraint lookupConstraintOrNull(String constraint_name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_lookupConstraintOrNull(this.swigCPtr, this, constraint_name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(double lb, double ub) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_0(this.swigCPtr, this, lb, ub);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint() {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(double lb, double ub, String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_2(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(String name) {
        long cPtr = operations_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_3(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPObjective objective() {
        long cPtr = operations_research_linear_solverJNI.MPSolver_objective(this.swigCPtr, this);
        return cPtr == 0L ? null : new MPObjective(cPtr, false);
    }

    public ResultStatus solve() {
        return ResultStatus.swigToEnum(operations_research_linear_solverJNI.MPSolver_solve__SWIG_0(this.swigCPtr, this));
    }

    public ResultStatus solve(MPSolverParameters param) {
        return ResultStatus.swigToEnum(operations_research_linear_solverJNI.MPSolver_solve__SWIG_1(this.swigCPtr, this, MPSolverParameters.getCPtr(param), param));
    }

    public double[] computeConstraintActivities() {
        return operations_research_linear_solverJNI.MPSolver_computeConstraintActivities(this.swigCPtr, this);
    }

    public boolean verifySolution(double tolerance, boolean log_errors) {
        return operations_research_linear_solverJNI.MPSolver_verifySolution(this.swigCPtr, this, tolerance, log_errors);
    }

    public void reset() {
        operations_research_linear_solverJNI.MPSolver_reset(this.swigCPtr, this);
    }

    public boolean setSolverSpecificParametersAsString(String parameters) {
        return operations_research_linear_solverJNI.MPSolver_setSolverSpecificParametersAsString(this.swigCPtr, this, parameters);
    }

    public static double infinity() {
        return operations_research_linear_solverJNI.MPSolver_infinity();
    }

    public void enableOutput() {
        operations_research_linear_solverJNI.MPSolver_enableOutput(this.swigCPtr, this);
    }

    public void suppressOutput() {
        operations_research_linear_solverJNI.MPSolver_suppressOutput(this.swigCPtr, this);
    }

    public void setTimeLimit(long time_limit_milliseconds) {
        operations_research_linear_solverJNI.MPSolver_setTimeLimit(this.swigCPtr, this, time_limit_milliseconds);
    }

    public long wallTime() {
        return operations_research_linear_solverJNI.MPSolver_wallTime(this.swigCPtr, this);
    }

    public long iterations() {
        return operations_research_linear_solverJNI.MPSolver_iterations(this.swigCPtr, this);
    }

    public long nodes() {
        return operations_research_linear_solverJNI.MPSolver_nodes(this.swigCPtr, this);
    }

    public double computeExactConditionNumber() {
        return operations_research_linear_solverJNI.MPSolver_computeExactConditionNumber(this.swigCPtr, this);
    }

    public String exportModelAsLpFormat(boolean obfuscated) {
        return operations_research_linear_solverJNI.MPSolver_exportModelAsLpFormat(this.swigCPtr, this, obfuscated);
    }

    public String exportModelAsMpsFormat(boolean fixed_format, boolean obfuscated) {
        return operations_research_linear_solverJNI.MPSolver_exportModelAsMpsFormat(this.swigCPtr, this, fixed_format, obfuscated);
    }

    public static enum BasisStatus {
        FREE(operations_research_linear_solverJNI.MPSolver_FREE_get()),
        AT_LOWER_BOUND,
        AT_UPPER_BOUND,
        FIXED_VALUE,
        BASIC;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static BasisStatus swigToEnum(int swigValue) {
            BasisStatus[] swigValues = (BasisStatus[])BasisStatus.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            BasisStatus[] basisStatusArray = swigValues;
            int n = swigValues.length;
            int n2 = 0;
            while (n2 < n) {
                BasisStatus swigEnum = basisStatusArray[n2];
                if (swigEnum.swigValue == swigValue) {
                    return swigEnum;
                }
                ++n2;
            }
            throw new IllegalArgumentException("No enum " + BasisStatus.class + " with value " + swigValue);
        }

        private BasisStatus() {
            int n2 = SwigNext.next;
            SwigNext.next = n2 + 1;
            this.swigValue = n2;
        }

        private BasisStatus(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private BasisStatus(BasisStatus swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum OptimizationProblemType {
        CLP_LINEAR_PROGRAMMING(operations_research_linear_solverJNI.MPSolver_CLP_LINEAR_PROGRAMMING_get()),
        GLOP_LINEAR_PROGRAMMING(operations_research_linear_solverJNI.MPSolver_GLOP_LINEAR_PROGRAMMING_get()),
        CBC_MIXED_INTEGER_PROGRAMMING(operations_research_linear_solverJNI.MPSolver_CBC_MIXED_INTEGER_PROGRAMMING_get()),
        BOP_INTEGER_PROGRAMMING(operations_research_linear_solverJNI.MPSolver_BOP_INTEGER_PROGRAMMING_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static OptimizationProblemType swigToEnum(int swigValue) {
            OptimizationProblemType[] swigValues = (OptimizationProblemType[])OptimizationProblemType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            OptimizationProblemType[] optimizationProblemTypeArray = swigValues;
            int n = swigValues.length;
            int n2 = 0;
            while (n2 < n) {
                OptimizationProblemType swigEnum = optimizationProblemTypeArray[n2];
                if (swigEnum.swigValue == swigValue) {
                    return swigEnum;
                }
                ++n2;
            }
            throw new IllegalArgumentException("No enum " + OptimizationProblemType.class + " with value " + swigValue);
        }

        private OptimizationProblemType() {
            int n2 = SwigNext.next;
            SwigNext.next = n2 + 1;
            this.swigValue = n2;
        }

        private OptimizationProblemType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private OptimizationProblemType(OptimizationProblemType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ResultStatus {
        OPTIMAL,
        FEASIBLE,
        INFEASIBLE,
        UNBOUNDED,
        ABNORMAL,
        NOT_SOLVED(operations_research_linear_solverJNI.MPSolver_NOT_SOLVED_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ResultStatus swigToEnum(int swigValue) {
            ResultStatus[] swigValues = (ResultStatus[])ResultStatus.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            ResultStatus[] resultStatusArray = swigValues;
            int n = swigValues.length;
            int n2 = 0;
            while (n2 < n) {
                ResultStatus swigEnum = resultStatusArray[n2];
                if (swigEnum.swigValue == swigValue) {
                    return swigEnum;
                }
                ++n2;
            }
            throw new IllegalArgumentException("No enum " + ResultStatus.class + " with value " + swigValue);
        }

        private ResultStatus() {
            int n2 = SwigNext.next;
            SwigNext.next = n2 + 1;
            this.swigValue = n2;
        }

        private ResultStatus(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ResultStatus(ResultStatus swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

