/*
 * Decompiled with CFR 0.152.
 */
package io.github.olivierlemasle.maven.plaintext;

import io.github.olivierlemasle.maven.plaintext.PlainTextFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="write", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class PlainTextMojo
extends AbstractMojo {
    private final FileSystem defaultFileSystem = FileSystems.getDefault();
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(required=true)
    private PlainTextFile[] files;

    void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void execute() throws MojoExecutionException {
        for (PlainTextFile file : this.files) {
            this.writeFile(file, this.defaultFileSystem);
        }
    }

    void writeFile(PlainTextFile file, FileSystem fs) throws MojoExecutionException {
        this.check(file);
        Path path = fs.getPath(this.outputDirectory, file.getName());
        this.getLog().debug((CharSequence)String.format("Write on path %s", path));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (file.isAppend() && Files.isRegularFile(path, new LinkOption[0])) {
                Files.write(path, file.getLines(), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
                this.getLog().debug((CharSequence)String.format("%s lines appended to file %s", file.getLines().size(), path));
            } else {
                Files.deleteIfExists(path);
                Files.write(path, file.getLines(), StandardCharsets.UTF_8, new OpenOption[0]);
                this.getLog().debug((CharSequence)String.format("%s lines written in file %s", file.getLines().size(), path));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("IOException with file %s", path), (Exception)e);
        }
    }

    private void check(PlainTextFile file) throws MojoExecutionException {
        if (file.getName() == null) {
            throw new MojoExecutionException("Parameter file.name is required.");
        }
        if (file.getLines() == null) {
            throw new MojoExecutionException("Parameter file.lines is required");
        }
    }
}

