/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.packet;

import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.SeparateResponse;

public class CoapTcpPacketConverter {
    public static CoapPacket toCoapPacket(CoapRequest request) {
        CoapPacket packet = new CoapPacket(request.getPeerAddress());
        packet.setMessageType(null);
        if (request.isPing()) {
            packet.setCode(Code.C702_PING);
        } else {
            packet.setMethod(request.getMethod());
            packet.setToken(request.getToken());
            packet.setHeaderOptions(request.options());
            packet.setPayload(request.getPayload());
        }
        return packet;
    }

    public static CoapPacket toCoapPacket(SeparateResponse resp) {
        CoapPacket packet = new CoapPacket(resp.getPeerAddress());
        packet.setMessageType(null);
        packet.setCode(resp.getCode());
        packet.setToken(resp.getToken());
        packet.setHeaderOptions(resp.options().duplicate());
        packet.setPayload(resp.getPayload());
        return packet;
    }
}

