/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.packet;

import com.mbed.coap.exception.CoapException;
import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapSerializer;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.EofInputStream;
import com.mbed.coap.packet.HeaderOptions;
import com.mbed.coap.packet.Method;
import com.mbed.coap.packet.Opaque;
import com.mbed.coap.packet.PacketUtils;
import com.mbed.coap.packet.SignallingHeaderOptions;
import com.mbed.coap.utils.Validations;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Optional;

public final class CoapTcpPacketSerializer {
    public static CoapPacket deserialize(InetSocketAddress remoteAddress, InputStream inputStream) throws IOException, CoapException {
        return CoapTcpPacketSerializer.deserialize0(remoteAddress, EofInputStream.wrap((InputStream)inputStream));
    }

    public static Optional<CoapPacket> deserializeIfEnoughData(InetSocketAddress remoteAddress, InputStream inputStream) throws IOException, CoapException {
        try {
            return Optional.of(CoapTcpPacketSerializer.deserialize0(remoteAddress, EofInputStream.wrap((InputStream)inputStream)));
        }
        catch (EOFException ex) {
            return Optional.empty();
        }
    }

    private static CoapPacket deserialize0(InetSocketAddress remoteAddress, EofInputStream is) throws IOException, CoapException {
        CoapPacketParsingContext pktContext = CoapTcpPacketSerializer.deserializeHeader(remoteAddress, is);
        CoapPacket pkt = pktContext.getCoapPacket();
        HeaderOptions options = pkt.getCode() != null && pkt.getCode().isSignaling() ? new SignallingHeaderOptions(pkt.getCode()) : new HeaderOptions();
        int leftPayloadLen = options.deserialize((InputStream)is, (int)pktContext.getLength());
        pkt.setHeaderOptions(options);
        if (leftPayloadLen > 0) {
            pkt.setPayload(Opaque.read((InputStream)is, (int)leftPayloadLen));
        }
        return pkt;
    }

    private static CoapPacketParsingContext deserializeHeader(InetSocketAddress remoteAddress, EofInputStream is) throws IOException, CoapException {
        int len1AndTKL = PacketUtils.read8((InputStream)is);
        int len1 = len1AndTKL >> 4 & 0xF;
        int tokenLength = len1AndTKL & 0xF;
        long len = CoapTcpPacketSerializer.readPacketLen(len1, is);
        int codeOrMethod = PacketUtils.read8((InputStream)is);
        Opaque token = CoapTcpPacketSerializer.readToken(is, tokenLength);
        CoapPacket coapPacket = new CoapPacket(remoteAddress);
        CoapTcpPacketSerializer.parseAndSetCodeOrMethod(coapPacket, codeOrMethod);
        coapPacket.setMessageType(null);
        coapPacket.setToken(token);
        return new CoapPacketParsingContext(coapPacket, len);
    }

    private static void parseAndSetCodeOrMethod(CoapPacket coapPacket, int codeOrMethod) throws CoapException {
        if (codeOrMethod >= 1 && codeOrMethod <= 10) {
            coapPacket.setMethod(Method.valueOf((int)codeOrMethod));
        } else {
            coapPacket.setCode(Code.valueOf((int)codeOrMethod));
        }
    }

    private static long readPacketLen(int len1, EofInputStream is) throws IOException {
        switch (len1) {
            case 15: {
                return CoapTcpPacketSerializer.read32((InputStream)is) + 65805L;
            }
            case 14: {
                return PacketUtils.read16((InputStream)is) + 269;
            }
            case 13: {
                return PacketUtils.read8((InputStream)is) + 13;
            }
        }
        return len1;
    }

    private static Opaque readToken(EofInputStream is, int tokenLength) throws IOException {
        Validations.assume((tokenLength <= 8 ? 1 : 0) != 0, (String)"Token length invalid, should be in range 0..8");
        return Opaque.read((InputStream)is, (int)tokenLength);
    }

    public static byte[] serialize(CoapPacket coapPacket) throws CoapException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CoapTcpPacketSerializer.writeTo(os, coapPacket);
        return os.toByteArray();
    }

    private static int packetLenCode(int packetLen) {
        if (packetLen < 13) {
            return packetLen;
        }
        if (packetLen < 269) {
            return 13;
        }
        if (packetLen < 65805) {
            return 14;
        }
        return 15;
    }

    private static void writeExtendedPacketLength(OutputStream os, int packetLenCode, int fullPacketLength) throws IOException {
        if (packetLenCode < 13) {
            return;
        }
        switch (packetLenCode) {
            case 13: {
                CoapTcpPacketSerializer.write8(os, fullPacketLength - 13);
                break;
            }
            case 14: {
                CoapTcpPacketSerializer.write16(os, fullPacketLength - 269);
                break;
            }
            case 15: {
                CoapTcpPacketSerializer.write32(os, fullPacketLength - 65805);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected packet len code: " + packetLenCode);
            }
        }
    }

    public static void writeTo(OutputStream os, CoapPacket coapPacket) throws CoapException, IOException {
        ByteArrayOutputStream headerOptionsStream = new ByteArrayOutputStream();
        coapPacket.headers().serialize((OutputStream)headerOptionsStream);
        int tokenLen = coapPacket.getToken().size();
        Validations.assume((tokenLen <= 8 ? 1 : 0) != 0, (String)"Token length should not exceed 8 bytes");
        int optionsLength = headerOptionsStream.size();
        int payloadLen = coapPacket.getPayload().size();
        int payloadMarkerLen = payloadLen > 0 ? 1 : 0;
        int packetLength = optionsLength + payloadMarkerLen + payloadLen;
        int packetLen1Code = CoapTcpPacketSerializer.packetLenCode(packetLength);
        CoapTcpPacketSerializer.write8(os, packetLen1Code << 4 | tokenLen);
        CoapTcpPacketSerializer.writeExtendedPacketLength(os, packetLen1Code, packetLength);
        CoapSerializer.writeCode((OutputStream)os, (CoapPacket)coapPacket);
        coapPacket.getToken().writeTo(os);
        os.write(headerOptionsStream.toByteArray());
        if (coapPacket.getPayload().size() > 0) {
            os.write(255);
            coapPacket.getPayload().writeTo(os);
        }
    }

    static long read32(InputStream is) throws IOException {
        long ret = is.read() << 24;
        ret |= (long)(is.read() << 16);
        ret |= (long)(is.read() << 8);
        return ret |= (long)is.read();
    }

    static void write8(OutputStream os, int data) throws IOException {
        os.write(data);
    }

    static void write16(OutputStream os, int data) throws IOException {
        os.write(data >> 8 & 0xFF);
        os.write(data >> 0 & 0xFF);
    }

    static void write32(OutputStream os, long data) throws IOException {
        os.write((int)(data >> 24 & 0xFFL));
        os.write((int)(data >> 16 & 0xFFL));
        os.write((int)(data >> 8 & 0xFFL));
        os.write((int)(data >> 0 & 0xFFL));
    }

    private static class CoapPacketParsingContext {
        private final CoapPacket coapPacket;
        private final long packetLength;

        public CoapPacketParsingContext(CoapPacket coapPacket, long packetLength) {
            this.coapPacket = coapPacket;
            this.packetLength = packetLength;
        }

        public CoapPacket getCoapPacket() {
            return this.coapPacket;
        }

        public long getLength() {
            return this.packetLength;
        }
    }
}

