/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.packet;

import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.Opaque;
import com.mbed.coap.utils.Validations;

public class SignalingOptions {
    private static final byte MAX_MESSAGE_SIZE = 2;
    private static final byte BLOCK_WISE_TRANSFER = 4;
    private static final byte CUSTODY = 2;
    private static final byte ALTERNATIVE_ADDRESS = 2;
    private static final byte HOLD_OFF = 4;
    private static final byte BAD_CSM_OPTION = 2;
    private Long maxMessageSize;
    private Boolean blockWiseTransfer;
    private Boolean custody;
    private String alternativeAddress;
    private Integer holdOff;
    private Integer badCsmOption;

    public static SignalingOptions capabilities(int maxMessageSize, boolean useBlockwiseTransfer) {
        SignalingOptions signalingOptions = new SignalingOptions();
        signalingOptions.setBlockWiseTransfer(useBlockwiseTransfer);
        signalingOptions.setMaxMessageSize(maxMessageSize);
        return signalingOptions;
    }

    SignalingOptions parse(int type, Opaque data, Code code) {
        if (code == Code.C701_CSM && type == 2) {
            this.setMaxMessageSize(data.toLong());
        } else if (code == Code.C701_CSM && type == 4) {
            this.setBlockWiseTransfer(true);
        } else if ((code == Code.C702_PING || code == Code.C703_PONG) && type == 2) {
            this.setCustody(true);
        } else if (code == Code.C704_RELEASE && type == 2) {
            Validations.assume((data.size() >= 1 && data.size() <= 255 ? 1 : 0) != 0, (String)("Illegal Alternative-Address size: " + data.size()));
            this.alternativeAddress = data.toUtf8String();
        } else if (code == Code.C704_RELEASE && type == 4) {
            this.setHoldOff(data.toInt());
        } else if (code == Code.C705_ABORT && type == 2) {
            this.setBadCsmOption(data.toInt());
        }
        return this;
    }

    Opaque serializeOption2() {
        if (this.maxMessageSize != null) {
            return Opaque.variableUInt((long)this.maxMessageSize);
        }
        if (this.custody != null && this.custody.booleanValue()) {
            return Opaque.EMPTY;
        }
        if (this.alternativeAddress != null) {
            return Opaque.of((String)this.alternativeAddress);
        }
        if (this.badCsmOption != null) {
            return Opaque.variableUInt((long)this.badCsmOption.longValue());
        }
        return null;
    }

    Opaque serializeOption4() {
        if (this.blockWiseTransfer != null && this.blockWiseTransfer.booleanValue()) {
            return Opaque.EMPTY;
        }
        if (this.holdOff != null) {
            return Opaque.variableUInt((long)this.holdOff.longValue());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        if (this.maxMessageSize != null) {
            sb.append(" MaxMsgSz:").append(this.maxMessageSize);
        }
        if (this.blockWiseTransfer != null && this.blockWiseTransfer.booleanValue()) {
            sb.append(" Blocks");
        }
        if (this.custody != null && this.custody.booleanValue()) {
            sb.append(" Custody");
        }
        if (this.alternativeAddress != null) {
            sb.append(" AltAdr:");
            sb.append(this.alternativeAddress);
        }
        if (this.holdOff != null) {
            sb.append(" Hold-Off:").append(this.holdOff);
        }
        if (this.badCsmOption != null) {
            sb.append(" Bad-CSM:").append(this.badCsmOption);
        }
        return sb.toString();
    }

    public Long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.setMaxMessageSize(Long.valueOf(maxMessageSize));
    }

    public void setMaxMessageSize(Long maxMessageSize) {
        if (this.custody != null || this.alternativeAddress != null || this.holdOff != null || this.badCsmOption != null) {
            throw new IllegalStateException("Other than 7.01 specific signaling option already set");
        }
        if (maxMessageSize != null && (maxMessageSize < 0L || maxMessageSize > 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Illegal Max-Message-Size argument: " + maxMessageSize);
        }
        this.maxMessageSize = maxMessageSize;
    }

    public Boolean getBlockWiseTransfer() {
        return this.blockWiseTransfer;
    }

    public void setBlockWiseTransfer(Boolean blockWiseTransfer) {
        if (this.custody != null || this.alternativeAddress != null || this.holdOff != null || this.badCsmOption != null) {
            throw new IllegalStateException("Other than 7.01 specific signaling option already set");
        }
        this.blockWiseTransfer = blockWiseTransfer;
    }

    public Boolean getCustody() {
        return this.custody;
    }

    public void setCustody(Boolean custody) {
        if (this.maxMessageSize != null || this.blockWiseTransfer != null || this.alternativeAddress != null || this.holdOff != null || this.badCsmOption != null) {
            throw new IllegalStateException("Other than 7.02 or 7.03 specific signaling option already set");
        }
        this.custody = custody;
    }

    public String getAlternativeAddress() {
        return this.alternativeAddress;
    }

    public void setAlternativeAddress(String alternativeAddress) {
        if (this.maxMessageSize != null || this.blockWiseTransfer != null || this.custody != null || this.badCsmOption != null) {
            throw new IllegalStateException("Other than 7.04 specific signaling option already set");
        }
        this.alternativeAddress = alternativeAddress;
    }

    public Integer getHoldOff() {
        return this.holdOff;
    }

    public void setHoldOff(Integer holdOff) {
        if (this.maxMessageSize != null || this.blockWiseTransfer != null || this.custody != null || this.badCsmOption != null) {
            throw new IllegalStateException("Other than 7.04 specific signaling option already set");
        }
        if (holdOff != null && (holdOff < 0 || holdOff > 4095)) {
            throw new IllegalArgumentException("Illegal Hold-Off argument: " + holdOff);
        }
        this.holdOff = holdOff;
    }

    public Integer getBadCsmOption() {
        return this.badCsmOption;
    }

    public void setBadCsmOption(Integer badCsmOption) {
        if (this.maxMessageSize != null || this.blockWiseTransfer != null || this.custody != null || this.alternativeAddress != null || this.holdOff != null) {
            throw new IllegalStateException("Other than 7.05 specific signaling option already set");
        }
        this.badCsmOption = badCsmOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalingOptions that = (SignalingOptions)o;
        if (this.maxMessageSize != null ? !this.maxMessageSize.equals(that.maxMessageSize) : that.maxMessageSize != null) {
            return false;
        }
        if (this.blockWiseTransfer != null ? !this.blockWiseTransfer.equals(that.blockWiseTransfer) : that.blockWiseTransfer != null) {
            return false;
        }
        if (this.custody != null ? !this.custody.equals(that.custody) : that.custody != null) {
            return false;
        }
        if (this.alternativeAddress != null ? !this.alternativeAddress.equals(that.alternativeAddress) : that.alternativeAddress != null) {
            return false;
        }
        if (this.holdOff != null ? !this.holdOff.equals(that.holdOff) : that.holdOff != null) {
            return false;
        }
        return this.badCsmOption != null ? this.badCsmOption.equals(that.badCsmOption) : that.badCsmOption == null;
    }

    public int hashCode() {
        int result = this.maxMessageSize != null ? this.maxMessageSize.hashCode() : 0;
        result = 31 * result + (this.blockWiseTransfer != null ? this.blockWiseTransfer.hashCode() : 0);
        result = 31 * result + (this.custody != null ? this.custody.hashCode() : 0);
        result = 31 * result + (this.alternativeAddress != null ? this.alternativeAddress.hashCode() : 0);
        result = 31 * result + (this.holdOff != null ? this.holdOff.hashCode() : 0);
        result = 31 * result + (this.badCsmOption != null ? this.badCsmOption.hashCode() : 0);
        return result;
    }
}

