/*
 * Decompiled with CFR 0.152.
 */
package com.mbed.coap.packet;

import com.mbed.coap.packet.BasicHeaderOptions;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.HeaderOptions;
import com.mbed.coap.packet.Opaque;
import com.mbed.coap.packet.RawOption;
import com.mbed.coap.packet.SignalingOptions;
import com.mbed.coap.utils.Validations;
import java.util.List;
import java.util.Objects;

public class SignallingHeaderOptions
extends HeaderOptions {
    private static final byte SIGN_OPTION_2 = 2;
    private static final byte SIGN_OPTION_4 = 4;
    private final Code code;
    private Opaque signallingOption2;
    private Opaque signallingOption4;

    public SignallingHeaderOptions(Code code) {
        Validations.require((boolean)code.isSignaling());
        this.code = code;
    }

    public boolean parseOption(int type, Opaque data) {
        switch (type) {
            case 2: {
                this.signallingOption2 = data;
                break;
            }
            case 4: {
                this.signallingOption4 = data;
                break;
            }
            default: {
                return super.parseOption(type, data);
            }
        }
        return true;
    }

    protected List<RawOption> getRawOptions() {
        List l = super.getRawOptions();
        if (this.signallingOption2 != null) {
            l.add(new RawOption(2, this.signallingOption2));
        }
        if (this.signallingOption4 != null) {
            l.add(new RawOption(4, this.signallingOption4));
        }
        return l;
    }

    public void buildToString(StringBuilder sb) {
        super.buildToString(sb);
        if (this.signallingOption2 != null || this.signallingOption4 != null) {
            SignalingOptions signOpt = new SignalingOptions();
            if (this.signallingOption2 != null) {
                signOpt.parse(2, this.signallingOption2, this.code);
            }
            if (this.signallingOption4 != null) {
                signOpt.parse(4, this.signallingOption4, this.code);
            }
            sb.append(signOpt.toString());
        }
    }

    public SignalingOptions toSignallingOptions(Code code) {
        if (this.signallingOption2 == null && this.signallingOption4 == null) {
            return null;
        }
        SignalingOptions signalingOptions = new SignalingOptions();
        if (this.signallingOption2 != null) {
            signalingOptions.parse(2, this.signallingOption2, code);
        }
        if (this.signallingOption4 != null) {
            signalingOptions.parse(4, this.signallingOption4, code);
        }
        return signalingOptions;
    }

    public void putSignallingOptions(SignalingOptions signalingOptions) {
        this.signallingOption2 = signalingOptions.serializeOption2();
        this.signallingOption4 = signalingOptions.serializeOption4();
    }

    public HeaderOptions duplicate() {
        SignallingHeaderOptions opts = new SignallingHeaderOptions(this.code);
        super.duplicate((BasicHeaderOptions)opts);
        opts.signallingOption2 = this.signallingOption2;
        opts.signallingOption4 = this.signallingOption4;
        return opts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SignallingHeaderOptions that = (SignallingHeaderOptions)((Object)o);
        return this.code == that.code && Objects.equals(this.signallingOption2, that.signallingOption2) && Objects.equals(this.signallingOption4, that.signallingOption4);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.code, this.signallingOption2, this.signallingOption4);
    }
}

